/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.openai.runtime.cost;

import io.quarkiverse.langchain4j.cost.CostEstimator;
import jakarta.annotation.Priority;
import jakarta.inject.Singleton;
import java.math.BigDecimal;

@Priority(value=-2147483648)
@Singleton
public class BasicGpt4oMiniCostEstimator
implements CostEstimator {
    private static final BigDecimal INPUT_COST = new BigDecimal("0.15").divide(BigDecimal.valueOf(1000000L));
    private static final BigDecimal OUTPUT_COST = new BigDecimal("0.6").divide(BigDecimal.valueOf(1000000L));

    public boolean supports(CostEstimator.SupportsContext context) {
        return "gpt-4o-mini".equals(context.model());
    }

    public CostEstimator.CostResult estimate(CostEstimator.CostContext context) {
        Integer inputTokens = context.inputTokens();
        Integer outputTokens = context.outputTokens();
        return new CostEstimator.CostResult(INPUT_COST.multiply(BigDecimal.valueOf(inputTokens.intValue())), OUTPUT_COST.multiply(BigDecimal.valueOf(outputTokens.intValue())), "USD");
    }
}

