/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.mcp.runtime.devui;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.mcp.client.McpClient;
import dev.langchain4j.model.chat.request.json.JsonSchemaElement;
import io.quarkiverse.langchain4j.mcp.runtime.McpClientName;
import io.quarkiverse.langchain4j.mcp.runtime.devui.json.JsonSchemaToExampleStringHelper;
import io.quarkiverse.langchain4j.mcp.runtime.devui.json.McpClientInfo;
import io.quarkiverse.langchain4j.mcp.runtime.devui.json.McpToolInfo;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InstanceHandle;
import jakarta.enterprise.inject.Any;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class McpClientsJsonRpcService {
    private final Map<String, McpClient> clients = new HashMap<String, McpClient>();

    public McpClientsJsonRpcService() {
        for (InstanceHandle handle : Arc.container().select(McpClient.class, new Annotation[]{Any.Literal.INSTANCE}).handles()) {
            InjectableBean bean = handle.getBean();
            String key = null;
            for (Annotation qualifier : bean.getQualifiers()) {
                if (!(qualifier instanceof McpClientName)) continue;
                McpClientName mcpClientName = (McpClientName)qualifier;
                key = mcpClientName.value();
                break;
            }
            this.clients.put(key == null ? "null" : key, (McpClient)handle.get());
        }
    }

    public List<McpClientInfo> clientInfos() {
        ArrayList<McpClientInfo> infos = new ArrayList<McpClientInfo>();
        for (String key : this.clients.keySet()) {
            McpClient client = this.clients.get(key);
            McpClientInfo info = this.buildClientInfo(client);
            info.setCdiName(key);
            infos.add(info);
        }
        return infos;
    }

    public String executeTool(String clientName, String toolName, String arguments) {
        ToolExecutionRequest request = ToolExecutionRequest.builder().name(toolName).arguments(arguments).build();
        return this.clients.get(clientName).executeTool(request);
    }

    private McpClientInfo buildClientInfo(McpClient client) {
        McpClientInfo info = new McpClientInfo();
        info.setTools(client.listTools().stream().map(this::buildToolInfo).toList());
        return info;
    }

    private McpToolInfo buildToolInfo(ToolSpecification toolSpec) {
        McpToolInfo info = new McpToolInfo();
        info.setName(toolSpec.name());
        info.setDescription(toolSpec.description());
        info.setExampleInput(JsonSchemaToExampleStringHelper.generateExampleStringFromSchema((JsonSchemaElement)toolSpec.parameters()));
        return info;
    }
}

