/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.mcp.runtime;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.mcp.McpToolProvider;
import dev.langchain4j.mcp.client.McpClient;
import dev.langchain4j.mcp.resourcesastools.DefaultMcpResourcesAsToolsPresenter;
import dev.langchain4j.mcp.resourcesastools.McpResourcesAsToolsPresenter;
import dev.langchain4j.service.tool.ToolExecutor;
import dev.langchain4j.service.tool.ToolProviderRequest;
import dev.langchain4j.service.tool.ToolProviderResult;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Scope;
import io.quarkiverse.langchain4j.runtime.aiservice.QuarkusToolProviderRequest;
import jakarta.enterprise.inject.Instance;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Function;

public class QuarkusMcpToolProvider
extends McpToolProvider {
    QuarkusMcpToolProvider(List<McpClient> mcpClients, Instance<Tracer> tracerInstance, boolean exposeResourcesAsTools) {
        super(mcpClients, false, (BiPredicate)AlwaysTrueMcpClientToolSpecificationBiPredicate.INSTANCE, QuarkusMcpToolProvider.determineToolWrapper(tracerInstance), (McpResourcesAsToolsPresenter)(exposeResourcesAsTools ? DefaultMcpResourcesAsToolsPresenter.builder().build() : null));
    }

    private static Function<ToolExecutor, ToolExecutor> determineToolWrapper(Instance<Tracer> tracerInstance) {
        if (tracerInstance.isResolvable()) {
            return new SpanToolExecutor(tracerInstance);
        }
        return Function.identity();
    }

    public ToolProviderResult provideTools(ToolProviderRequest request) {
        return this.provideTools(request, this.getMcpClientsFilter(request));
    }

    private BiPredicate<McpClient, ToolSpecification> getMcpClientsFilter(ToolProviderRequest request) {
        if (request instanceof QuarkusToolProviderRequest) {
            QuarkusToolProviderRequest quarkusRequest = (QuarkusToolProviderRequest)request;
            return new McpClientKeyFilter(quarkusRequest.getMcpClientNames());
        }
        return AlwaysTrueMcpClientToolSpecificationBiPredicate.INSTANCE;
    }

    private static class AlwaysTrueMcpClientToolSpecificationBiPredicate
    implements BiPredicate<McpClient, ToolSpecification> {
        private static final AlwaysTrueMcpClientToolSpecificationBiPredicate INSTANCE = new AlwaysTrueMcpClientToolSpecificationBiPredicate();

        private AlwaysTrueMcpClientToolSpecificationBiPredicate() {
        }

        @Override
        public boolean test(McpClient mcpClient, ToolSpecification toolSpecification) {
            return true;
        }
    }

    private static class SpanToolExecutor
    implements Function<ToolExecutor, ToolExecutor> {
        private final Instance<Tracer> tracerInstance;

        public SpanToolExecutor(Instance<Tracer> tracerInstance) {
            this.tracerInstance = tracerInstance;
        }

        @Override
        public ToolExecutor apply(final ToolExecutor toolExecutor) {
            return new ToolExecutor(){
                final /* synthetic */ SpanToolExecutor this$0;
                {
                    this.this$0 = this$0;
                }

                public String execute(ToolExecutionRequest toolExecutionRequest, Object memoryId) {
                    Span span = ((Tracer)this.this$0.tracerInstance.get()).spanBuilder("langchain4j.mcp-tools." + toolExecutionRequest.name()).startSpan();
                    try {
                        String string;
                        block11: {
                            Scope scope = span.makeCurrent();
                            try {
                                string = toolExecutor.execute(toolExecutionRequest, memoryId);
                                if (scope == null) break block11;
                            }
                            catch (Throwable throwable) {
                                try {
                                    if (scope != null) {
                                        try {
                                            scope.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                catch (Throwable t) {
                                    span.recordException(t);
                                    throw t;
                                }
                            }
                            scope.close();
                        }
                        return string;
                    }
                    finally {
                        span.end();
                    }
                }
            };
        }
    }

    private static class McpClientKeyFilter
    implements BiPredicate<McpClient, ToolSpecification> {
        private final List<String> keys;

        private McpClientKeyFilter(List<String> keys) {
            this.keys = keys;
        }

        @Override
        public boolean test(McpClient mcpClient, ToolSpecification tool) {
            return this.keys != null && (this.keys.isEmpty() || this.keys.stream().anyMatch(name -> name.equals(mcpClient.key())));
        }
    }
}

