/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.mcp.runtime;

import dev.langchain4j.mcp.client.McpClient;
import io.quarkiverse.langchain4j.mcp.runtime.McpClientName;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InstanceHandle;
import jakarta.enterprise.inject.Any;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Readiness;

@Readiness
public class McpClientHealthCheck
implements HealthCheck {
    private final Map<String, McpClient> clientMap = this.getClientMap();

    public HealthCheckResponse call() {
        HealthCheckResponseBuilder builder = HealthCheckResponse.builder().name("MCP clients health check").up();
        for (String name : this.clientMap.keySet()) {
            McpClient client = this.clientMap.get(name);
            try {
                client.checkHealth();
                builder.withData(name, "OK");
            }
            catch (Exception e) {
                builder.down().withData(name, e.getMessage());
            }
        }
        return builder.build();
    }

    private Map<String, McpClient> getClientMap() {
        HashMap<String, McpClient> map = new HashMap<String, McpClient>();
        for (InstanceHandle handle : Arc.container().select(McpClient.class, new Annotation[]{Any.Literal.INSTANCE}).handles()) {
            InjectableBean bean = handle.getBean();
            for (Annotation qualifier : bean.getQualifiers()) {
                if (!(qualifier instanceof McpClientName)) continue;
                McpClientName q = (McpClientName)qualifier;
                String name = q.value() != null && !q.value().isEmpty() ? q.value() : "<default>";
                map.put(name, (McpClient)handle.get());
            }
        }
        return map;
    }
}

