/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.mcp.deployment;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.langchain4j.mcp.client.McpClient;
import io.opentelemetry.api.trace.Tracer;
import io.quarkiverse.langchain4j.deployment.DotNames;
import io.quarkiverse.langchain4j.mcp.auth.McpClientAuthProvider;
import io.quarkiverse.langchain4j.mcp.deployment.McpConfigFileContentsBuildItem;
import io.quarkiverse.langchain4j.mcp.runtime.McpClientHealthCheck;
import io.quarkiverse.langchain4j.mcp.runtime.McpClientName;
import io.quarkiverse.langchain4j.mcp.runtime.McpRecorder;
import io.quarkiverse.langchain4j.mcp.runtime.config.LocalLaunchParams;
import io.quarkiverse.langchain4j.mcp.runtime.config.McpBuildTimeConfiguration;
import io.quarkiverse.langchain4j.mcp.runtime.config.McpTransportType;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.smallrye.health.deployment.spi.HealthBuildItem;
import io.quarkus.vertx.core.deployment.CoreVertxBuildItem;
import jakarta.enterprise.context.ApplicationScoped;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class McpProcessor {
    private static final Logger log = Logger.getLogger(McpProcessor.class);
    private static final DotName MCP_CLIENT = DotName.createSimple(McpClient.class);
    private static final DotName MCP_CLIENT_NAME = DotName.createSimple(McpClientName.class);
    private static final DotName TRACER = DotName.createSimple(Tracer.class);

    @BuildStep
    public void generateMcpConfigFileContents(McpBuildTimeConfiguration mcpBuildTimeConfiguration, BuildProducer<McpConfigFileContentsBuildItem> producer) {
        if (mcpBuildTimeConfiguration.configFile().isEmpty()) {
            return;
        }
        String configFileName = (String)mcpBuildTimeConfiguration.configFile().get();
        try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(configFileName);){
            HashMap<String, LocalLaunchParams> claudeConfigContents = new HashMap<String, LocalLaunchParams>();
            Map configFileAsMap = (Map)new ObjectMapper().readValue(is, (TypeReference)new TypeReference<Map<String, Map<String, Object>>>(){});
            configFileAsMap.getOrDefault("mcpServers", Collections.emptyMap()).forEach((serverName, serverConfig) -> {
                if (serverConfig instanceof Map) {
                    Map serverConfigMap = (Map)serverConfig;
                    String command = (String)serverConfigMap.get("command");
                    if (command == null) {
                        log.warnf("The configured MCP Config file '%s' contains an MCP server named %s that does not contain a command and will therefore be ignored.", (Object)configFileName, serverConfig);
                    } else {
                        ArrayList<String> commandAsList = new ArrayList<String>();
                        commandAsList.add(command);
                        Object args = serverConfigMap.get("args");
                        if (args instanceof List) {
                            List argsList = (List)args;
                            commandAsList.addAll(argsList);
                        }
                        HashMap environment = new HashMap();
                        Object env = serverConfigMap.get("env");
                        if (env instanceof Map) {
                            Map envMap = (Map)env;
                            environment.putAll(envMap);
                        }
                        claudeConfigContents.put((String)serverName, new LocalLaunchParams(commandAsList, environment));
                    }
                } else {
                    log.warnf("The configured MCP Config file '%s' contains the 'mcpServers' key that is not a JSON object so it will be ignored.", (Object)configFileName);
                }
            });
            producer.produce((BuildItem)new McpConfigFileContentsBuildItem(claudeConfigContents));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void recordConfigFile(Optional<McpConfigFileContentsBuildItem> maybeMcpConfigFileContents, McpRecorder recorder) {
        if (maybeMcpConfigFileContents.isEmpty()) {
            return;
        }
        recorder.claudeConfigContents(maybeMcpConfigFileContents.get().getContents());
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void registerMcpClients(McpBuildTimeConfiguration mcpBuildTimeConfiguration, Optional<McpConfigFileContentsBuildItem> maybeMcpConfigFileContents, BuildProducer<SyntheticBeanBuildItem> beanProducer, BuildProducer<HealthBuildItem> healthBuildItems, ShutdownContextBuildItem shutdown, Capabilities capabilities, CoreVertxBuildItem vertxBuildItem, McpRecorder recorder) {
        HashMap<String, McpTransportType> clients = new HashMap<String, McpTransportType>();
        if (mcpBuildTimeConfiguration.clients() != null && !mcpBuildTimeConfiguration.clients().isEmpty()) {
            mcpBuildTimeConfiguration.clients().forEach((name, config) -> clients.put((String)name, config.transportType()));
        }
        if (maybeMcpConfigFileContents.isPresent()) {
            maybeMcpConfigFileContents.get().getContents().keySet().forEach(name -> clients.put((String)name, McpTransportType.STDIO));
        }
        if (!clients.isEmpty()) {
            ArrayList qualifiers = new ArrayList();
            clients.forEach((client, transportType) -> {
                AnnotationInstance qualifier = AnnotationInstance.builder((DotName)MCP_CLIENT_NAME).add("value", client).build();
                qualifiers.add(qualifier);
                beanProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((DotName)MCP_CLIENT).addQualifier(qualifier)).setRuntimeInit().defaultBean()).unremovable()).scope(ApplicationScoped.class)).supplier(recorder.mcpClientSupplier(client, transportType, (ShutdownContext)shutdown, vertxBuildItem.getVertx())).done());
            });
            if (mcpBuildTimeConfiguration.generateToolProvider().orElse(true).booleanValue()) {
                SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((DotName)DotNames.TOOL_PROVIDER).setRuntimeInit().defaultBean()).unremovable()).scope(ApplicationScoped.class)).addInjectionPoint((Type)ParameterizedType.create((DotName)DotNames.CDI_INSTANCE, (Type[])new Type[]{ClassType.create((DotName)TRACER)}, null), new AnnotationInstance[0])).createWith(recorder.toolProviderFunction(clients.keySet()));
                for (AnnotationInstance qualifier : qualifiers) {
                    configurator.addInjectionPoint((Type)ClassType.create((DotName)MCP_CLIENT), new AnnotationInstance[]{qualifier});
                }
                beanProducer.produce((BuildItem)configurator.done());
            }
            if (mcpBuildTimeConfiguration.mpHealthEnabled() && capabilities.isPresent("io.quarkus.smallrye.health")) {
                healthBuildItems.produce((BuildItem)new HealthBuildItem(McpClientHealthCheck.class.getName(), true));
            }
        }
    }

    @BuildStep
    public void indexMcpClientDependency(BuildProducer<IndexDependencyBuildItem> index) {
        index.produce((BuildItem)new IndexDependencyBuildItem("dev.langchain4j", "langchain4j-mcp"));
    }

    @BuildStep
    public void reflectionRegistrations(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, CombinedIndexBuildItem indexBuildItem) {
        String PROTOCOL_PACKAGE_PATTERN = "dev\\.langchain4j\\.mcp\\.client\\.protocol\\..+";
        IndexView index = indexBuildItem.getIndex();
        for (ClassInfo clazz : index.getKnownClasses()) {
            if (!clazz.name().toString().matches(PROTOCOL_PACKAGE_PATTERN)) continue;
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{clazz.name().toString()}).fields(true).methods(true).build());
        }
    }

    @BuildStep
    public void addMcpAuthProvider(BuildProducer<UnremovableBeanBuildItem> unremovableProducer) {
        unremovableProducer.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{McpClientAuthProvider.class}));
    }
}

