/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.gemini.common;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.model.output.TokenUsage;
import io.quarkiverse.langchain4j.gemini.common.FunctionCall;
import io.quarkiverse.langchain4j.gemini.common.GenerateContentResponse;
import java.util.ArrayList;
import java.util.List;

public final class GenerateContentResponseHandler {
    private GenerateContentResponseHandler() {
    }

    public static String getText(GenerateContentResponse response) {
        List<GenerateContentResponse.Candidate.Part> parts;
        GenerateContentResponse.FinishReason finishReason = GenerateContentResponseHandler.getFinishReason(response);
        if (finishReason == GenerateContentResponse.FinishReason.SAFETY) {
            throw new IllegalArgumentException("The response is blocked due to safety reason.");
        }
        if (finishReason == GenerateContentResponse.FinishReason.RECITATION) {
            throw new IllegalArgumentException("The response is blocked due to unauthorized citations.");
        }
        StringBuilder text = new StringBuilder();
        if (response.candidates() != null && !response.candidates().isEmpty() && response.candidates().get(0).content() != null && (parts = response.candidates().get(0).content().parts()) != null && !parts.isEmpty()) {
            for (GenerateContentResponse.Candidate.Part part : parts) {
                if (part.thought() != null && part.thought().booleanValue()) continue;
                text.append(part.text());
            }
        }
        return text.toString();
    }

    public static String getThoughts(GenerateContentResponse response) {
        List<GenerateContentResponse.Candidate.Part> parts;
        GenerateContentResponse.FinishReason finishReason = GenerateContentResponseHandler.getFinishReason(response);
        if (finishReason == GenerateContentResponse.FinishReason.SAFETY) {
            throw new IllegalArgumentException("The response is blocked due to safety reason.");
        }
        if (finishReason == GenerateContentResponse.FinishReason.RECITATION) {
            throw new IllegalArgumentException("The response is blocked due to unauthorized citations.");
        }
        StringBuilder text = new StringBuilder();
        if (response.candidates() != null && !response.candidates().isEmpty() && response.candidates().get(0).content() != null && (parts = response.candidates().get(0).content().parts()) != null && !parts.isEmpty()) {
            for (GenerateContentResponse.Candidate.Part part : parts) {
                if (part.thought() == null || !part.thought().booleanValue()) continue;
                text.append(part.text());
            }
        }
        return text.toString();
    }

    public static GenerateContentResponse.FinishReason getFinishReason(GenerateContentResponse response) {
        if (response.candidates().size() != 1) {
            throw new IllegalArgumentException(String.format("This response should have exactly 1 candidate, but it has %s.", response.candidates().size()));
        }
        return response.candidates().get(0).finishReason();
    }

    public static TokenUsage getTokenUsage(GenerateContentResponse.UsageMetadata usageMetadata) {
        return new TokenUsage(usageMetadata.promptTokenCount(), usageMetadata.candidatesTokenCount(), usageMetadata.totalTokenCount());
    }

    public static List<ToolExecutionRequest> getToolExecutionRequests(GenerateContentResponse response) {
        List<GenerateContentResponse.Candidate.Part> parts = response.candidates().get(0).content().parts();
        ArrayList<ToolExecutionRequest> toolExecutionRequests = new ArrayList<ToolExecutionRequest>();
        for (GenerateContentResponse.Candidate.Part part : parts) {
            FunctionCall functionCall = part.functionCall();
            if (functionCall == null) continue;
            toolExecutionRequests.add(functionCall.toToolExecutionRequest());
        }
        return toolExecutionRequests;
    }
}

