/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.gemini.common;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.internal.ExceptionMapper;
import dev.langchain4j.internal.InternalStreamingChatResponseHandlerUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.ModelProvider;
import dev.langchain4j.model.chat.Capability;
import dev.langchain4j.model.chat.StreamingChatModel;
import dev.langchain4j.model.chat.listener.ChatModelErrorContext;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.listener.ChatModelRequestContext;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.chat.request.ResponseFormatType;
import dev.langchain4j.model.chat.request.json.JsonEnumSchema;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import io.quarkiverse.langchain4j.gemini.common.BaseGeminiChatModel;
import io.quarkiverse.langchain4j.gemini.common.ContentMapper;
import io.quarkiverse.langchain4j.gemini.common.GeminiStreamingResponseBuilder;
import io.quarkiverse.langchain4j.gemini.common.GenerateContentRequest;
import io.quarkiverse.langchain4j.gemini.common.GenerateContentResponse;
import io.quarkiverse.langchain4j.gemini.common.GenerationConfig;
import io.quarkiverse.langchain4j.gemini.common.SchemaMapper;
import io.smallrye.mutiny.Multi;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.jboss.resteasy.reactive.client.SseEvent;

public abstract class GeminiStreamingChatLanguageModel
extends BaseGeminiChatModel
implements StreamingChatModel {
    public GeminiStreamingChatLanguageModel(String modelId, Double temperature, Integer maxOutputTokens, Integer topK, Double topP, ResponseFormat responseFormat, List<ChatModelListener> listeners) {
        super(modelId, temperature, maxOutputTokens, topK, topP, responseFormat, listeners, null, false);
    }

    public Set<Capability> supportedCapabilities() {
        HashSet<Capability> capabilities = new HashSet<Capability>();
        if (this.responseFormat != null && ResponseFormatType.JSON.equals((Object)this.responseFormat.type())) {
            capabilities.add(Capability.RESPONSE_FORMAT_JSON_SCHEMA);
        } else if (this.responseFormat == null) {
            capabilities.add(Capability.RESPONSE_FORMAT_JSON_SCHEMA);
        }
        return capabilities;
    }

    public void doChat(ChatRequest chatRequest, StreamingChatResponseHandler aHandler) {
        ChatRequestParameters requestParameters = chatRequest.parameters();
        ResponseFormat effectiveResponseFormat = (ResponseFormat)Utils.getOrDefault((Object)requestParameters.responseFormat(), (Object)this.responseFormat);
        GenerationConfig generationConfig = GenerationConfig.builder().maxOutputTokens((Integer)Utils.getOrDefault((Object)requestParameters.maxOutputTokens(), (Object)this.maxOutputTokens)).responseMimeType(this.computeMimeType(effectiveResponseFormat)).responseSchema(effectiveResponseFormat != null ? SchemaMapper.fromJsonSchemaToSchema(effectiveResponseFormat.jsonSchema()) : null).stopSequences(requestParameters.stopSequences()).temperature((Double)Utils.getOrDefault((Object)requestParameters.temperature(), (Object)this.temperature)).topK((Integer)Utils.getOrDefault((Object)requestParameters.topK(), (Object)this.topK)).topP((Double)Utils.getOrDefault((Object)requestParameters.topP(), (Object)this.topP)).build();
        GenerateContentRequest request = ContentMapper.map(chatRequest.messages(), chatRequest.toolSpecifications(), generationConfig);
        ChatRequest modelListenerRequest = this.createModelListenerRequest(request, chatRequest.messages(), chatRequest.toolSpecifications());
        ConcurrentHashMap attributes = new ConcurrentHashMap();
        ChatModelRequestContext requestContext = new ChatModelRequestContext(modelListenerRequest, ModelProvider.OTHER, attributes);
        this.listeners.forEach(listener -> {
            try {
                listener.onRequest(requestContext);
            }
            catch (Exception e) {
                log.warn((Object)"Exception while calling model listener", (Throwable)e);
            }
        });
        try {
            GeminiStreamingResponseBuilder responseBuilder = new GeminiStreamingResponseBuilder();
            Multi<SseEvent<GenerateContentResponse>> event = this.generateStreamContext(request);
            event.subscribe().with((Consumer)new OnItemConsumer(responseBuilder, aHandler), (Consumer)new OnErrorConsumer(aHandler), (Runnable)new OnCompleteRunnable(responseBuilder, aHandler));
        }
        catch (RuntimeException e) {
            ChatModelErrorContext errorContext = new ChatModelErrorContext((Throwable)e, modelListenerRequest, null, attributes);
            this.listeners.forEach(listener -> {
                try {
                    listener.onError(errorContext);
                }
                catch (Exception e2) {
                    log.warn((Object)"Exception while calling model listener", (Throwable)e2);
                }
            });
            throw e;
        }
    }

    protected abstract Multi<SseEvent<GenerateContentResponse>> generateStreamContext(GenerateContentRequest var1);

    private ChatRequest createModelListenerRequest(GenerateContentRequest request, List<ChatMessage> messages, List<ToolSpecification> toolSpecifications) {
        ChatRequest.Builder builder = ChatRequest.builder().messages(messages).parameters(ChatRequestParameters.builder().modelName(this.modelId).toolSpecifications(toolSpecifications).temperature(this.temperature).topP(this.topP).maxOutputTokens(this.maxOutputTokens).build());
        return builder.build();
    }

    private String computeMimeType(ResponseFormat responseFormat) {
        if (responseFormat == null || ResponseFormatType.TEXT.equals((Object)responseFormat.type())) {
            return "text/plain";
        }
        if (ResponseFormatType.JSON.equals((Object)responseFormat.type()) && responseFormat.jsonSchema() != null && responseFormat.jsonSchema().rootElement() != null && responseFormat.jsonSchema().rootElement() instanceof JsonEnumSchema) {
            return "text/x.enum";
        }
        return "application/json";
    }

    private static class OnItemConsumer
    implements Consumer<SseEvent<GenerateContentResponse>> {
        private final GeminiStreamingResponseBuilder responseBuilder;
        private final StreamingChatResponseHandler handler;

        public OnItemConsumer(GeminiStreamingResponseBuilder responseBuilder, StreamingChatResponseHandler handler) {
            this.responseBuilder = responseBuilder;
            this.handler = handler;
        }

        @Override
        public void accept(SseEvent<GenerateContentResponse> t) {
            GenerateContentResponse response = (GenerateContentResponse)t.data();
            Optional<String> maybeText = this.responseBuilder.append(response);
            maybeText.ifPresent(text -> {
                try {
                    this.handler.onPartialResponse(text);
                }
                catch (Exception ex) {
                    InternalStreamingChatResponseHandlerUtils.withLoggingExceptions(() -> this.handler.onError((Throwable)ex));
                }
            });
        }
    }

    private static class OnErrorConsumer
    implements Consumer<Throwable> {
        private final StreamingChatResponseHandler handler;

        public OnErrorConsumer(StreamingChatResponseHandler handler) {
            this.handler = handler;
        }

        @Override
        public void accept(Throwable x) {
            RuntimeException mappedError = ExceptionMapper.DEFAULT.mapException(x);
            InternalStreamingChatResponseHandlerUtils.withLoggingExceptions(() -> this.handler.onError((Throwable)mappedError));
        }
    }

    private static class OnCompleteRunnable
    implements Runnable {
        private final GeminiStreamingResponseBuilder responseBuilder;
        private final StreamingChatResponseHandler handler;

        public OnCompleteRunnable(GeminiStreamingResponseBuilder responseBuilder, StreamingChatResponseHandler handler) {
            this.responseBuilder = responseBuilder;
            this.handler = handler;
        }

        @Override
        public void run() {
            ChatResponse chatResponse = this.responseBuilder.build();
            try {
                this.handler.onCompleteResponse(chatResponse);
            }
            catch (Exception e) {
                InternalStreamingChatResponseHandlerUtils.withLoggingExceptions(() -> this.handler.onError((Throwable)e));
            }
        }
    }
}

