/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.gemini.common;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.ModelProvider;
import dev.langchain4j.model.chat.Capability;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.listener.ChatModelErrorContext;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.listener.ChatModelRequestContext;
import dev.langchain4j.model.chat.listener.ChatModelResponseContext;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.chat.request.ResponseFormatType;
import dev.langchain4j.model.chat.request.json.JsonEnumSchema;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.ChatResponseMetadata;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import io.quarkiverse.langchain4j.gemini.common.BaseGeminiChatModel;
import io.quarkiverse.langchain4j.gemini.common.ContentMapper;
import io.quarkiverse.langchain4j.gemini.common.FinishReasonMapper;
import io.quarkiverse.langchain4j.gemini.common.GenerateContentRequest;
import io.quarkiverse.langchain4j.gemini.common.GenerateContentResponse;
import io.quarkiverse.langchain4j.gemini.common.GenerateContentResponseHandler;
import io.quarkiverse.langchain4j.gemini.common.GenerationConfig;
import io.quarkiverse.langchain4j.gemini.common.SchemaMapper;
import io.quarkiverse.langchain4j.gemini.common.ThinkingConfig;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class GeminiChatLanguageModel
extends BaseGeminiChatModel
implements ChatModel {
    public GeminiChatLanguageModel(String modelId, Double temperature, Integer maxOutputTokens, Integer topK, Double topP, ResponseFormat responseFormat, List<ChatModelListener> listeners, Long thinkingBudget, boolean includeThoughts) {
        super(modelId, temperature, maxOutputTokens, topK, topP, responseFormat, listeners, thinkingBudget, includeThoughts);
    }

    public Set<Capability> supportedCapabilities() {
        HashSet<Capability> capabilities = new HashSet<Capability>();
        if (this.responseFormat != null && ResponseFormatType.JSON.equals((Object)this.responseFormat.type())) {
            capabilities.add(Capability.RESPONSE_FORMAT_JSON_SCHEMA);
        } else if (this.responseFormat == null) {
            capabilities.add(Capability.RESPONSE_FORMAT_JSON_SCHEMA);
        }
        return capabilities;
    }

    public ChatResponse chat(ChatRequest chatRequest) {
        ChatRequestParameters requestParameters = chatRequest.parameters();
        ResponseFormat effectiveResponseFormat = (ResponseFormat)Utils.getOrDefault((Object)requestParameters.responseFormat(), (Object)this.responseFormat);
        GenerationConfig.Builder generationConfigBuilder = GenerationConfig.builder().maxOutputTokens((Integer)Utils.getOrDefault((Object)requestParameters.maxOutputTokens(), (Object)this.maxOutputTokens)).responseMimeType(this.computeMimeType(effectiveResponseFormat)).responseSchema(effectiveResponseFormat != null ? SchemaMapper.fromJsonSchemaToSchema(effectiveResponseFormat.jsonSchema()) : null).stopSequences(requestParameters.stopSequences()).temperature((Double)Utils.getOrDefault((Object)requestParameters.temperature(), (Object)this.temperature)).topK((Integer)Utils.getOrDefault((Object)requestParameters.topK(), (Object)this.topK)).topP((Double)Utils.getOrDefault((Object)requestParameters.topP(), (Object)this.topP));
        if (this.thinkingBudget != null || this.includeThoughts) {
            generationConfigBuilder.thinkingConfig(new ThinkingConfig(this.thinkingBudget, this.includeThoughts));
        }
        GenerationConfig generationConfig = generationConfigBuilder.build();
        GenerateContentRequest request = ContentMapper.map(chatRequest.messages(), chatRequest.toolSpecifications(), generationConfig);
        ChatRequest modelListenerRequest = this.createModelListenerRequest(request, chatRequest.messages(), chatRequest.toolSpecifications());
        ConcurrentHashMap attributes = new ConcurrentHashMap();
        ChatModelRequestContext requestContext = new ChatModelRequestContext(modelListenerRequest, ModelProvider.OTHER, attributes);
        this.listeners.forEach(listener -> {
            try {
                listener.onRequest(requestContext);
            }
            catch (Exception e) {
                log.warn((Object)"Exception while calling model listener", (Throwable)e);
            }
        });
        try {
            GenerateContentResponse response = this.generateContext(request);
            String text = GenerateContentResponseHandler.getText(response);
            String thoughts = this.includeThoughts ? GenerateContentResponseHandler.getThoughts(response) : null;
            List<ToolExecutionRequest> toolExecutionRequests = GenerateContentResponseHandler.getToolExecutionRequests(response);
            AiMessage.Builder aiMessageBuilder = AiMessage.builder().text(text).thinking(thoughts).toolExecutionRequests(toolExecutionRequests);
            AiMessage aiMessage = aiMessageBuilder.build();
            TokenUsage tokenUsage = GenerateContentResponseHandler.getTokenUsage(response.usageMetadata());
            FinishReason finishReason = FinishReasonMapper.map(GenerateContentResponseHandler.getFinishReason(response));
            Response aiMessageResponse = Response.from((Object)aiMessage, (TokenUsage)tokenUsage);
            ChatResponse modelListenerResponse = this.createModelListenerResponse(null, this.modelId, (Response<AiMessage>)aiMessageResponse);
            ChatModelResponseContext responseContext = new ChatModelResponseContext(modelListenerResponse, modelListenerRequest, ModelProvider.OTHER, attributes);
            this.listeners.forEach(listener -> {
                try {
                    listener.onResponse(responseContext);
                }
                catch (Exception e) {
                    log.warn((Object)"Exception while calling model listener", (Throwable)e);
                }
            });
            return ChatResponse.builder().aiMessage(aiMessage).tokenUsage(GenerateContentResponseHandler.getTokenUsage(response.usageMetadata())).finishReason(FinishReasonMapper.map(GenerateContentResponseHandler.getFinishReason(response))).build();
        }
        catch (RuntimeException e) {
            ChatModelErrorContext errorContext = new ChatModelErrorContext((Throwable)e, modelListenerRequest, null, attributes);
            this.listeners.forEach(listener -> {
                try {
                    listener.onError(errorContext);
                }
                catch (Exception e2) {
                    log.warn((Object)"Exception while calling model listener", (Throwable)e2);
                }
            });
            throw e;
        }
    }

    protected abstract GenerateContentResponse generateContext(GenerateContentRequest var1);

    private ChatRequest createModelListenerRequest(GenerateContentRequest request, List<ChatMessage> messages, List<ToolSpecification> toolSpecifications) {
        ChatRequest.Builder builder = ChatRequest.builder().messages(messages).parameters(ChatRequestParameters.builder().modelName(this.modelId).toolSpecifications(toolSpecifications).temperature(this.temperature).topP(this.topP).maxOutputTokens(this.maxOutputTokens).build());
        return builder.build();
    }

    private ChatResponse createModelListenerResponse(String responseId, String responseModel, Response<AiMessage> response) {
        if (response == null) {
            return null;
        }
        return ChatResponse.builder().aiMessage((AiMessage)response.content()).finishReason(response.finishReason()).metadata(ChatResponseMetadata.builder().id(responseId).modelName(responseModel).tokenUsage(response.tokenUsage()).build()).build();
    }

    private String computeMimeType(ResponseFormat responseFormat) {
        if (responseFormat == null || ResponseFormatType.TEXT.equals((Object)responseFormat.type())) {
            return "text/plain";
        }
        if (ResponseFormatType.JSON.equals((Object)responseFormat.type()) && responseFormat.jsonSchema() != null && responseFormat.jsonSchema().rootElement() != null && responseFormat.jsonSchema().rootElement() instanceof JsonEnumSchema) {
            return "text/x.enum";
        }
        return "application/json";
    }

    public ChatResponse doChat(ChatRequest chatRequest) {
        ChatResponse chatResponse = this.chat(ChatRequest.builder().messages(chatRequest.messages()).toolSpecifications(chatRequest.toolSpecifications()).build());
        return ChatResponse.builder().aiMessage(chatResponse.aiMessage()).tokenUsage(chatResponse.tokenUsage()).finishReason(chatResponse.finishReason()).build();
    }
}

