/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.easyrag.runtime;

import dev.langchain4j.data.document.Document;
import dev.langchain4j.data.document.DocumentSplitter;
import dev.langchain4j.data.document.loader.ClassPathDocumentLoader;
import dev.langchain4j.data.document.loader.FileSystemDocumentLoader;
import dev.langchain4j.data.document.splitter.DocumentSplitters;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.TokenCountEstimator;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.embedding.onnx.HuggingFaceTokenCountEstimator;
import dev.langchain4j.store.embedding.EmbeddingStore;
import dev.langchain4j.store.embedding.EmbeddingStoreIngestor;
import dev.langchain4j.store.embedding.inmemory.InMemoryEmbeddingStore;
import io.quarkiverse.langchain4j.easyrag.runtime.EasyRagConfig;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.jboss.logging.Logger;

public class EasyRagIngestor {
    private static final Logger LOGGER = Logger.getLogger(EasyRagIngestor.class);
    private EmbeddingModel embeddingModel;
    private EmbeddingStore<TextSegment> embeddingStore;
    private EasyRagConfig config;

    public EasyRagIngestor(EmbeddingModel embeddingModel, EmbeddingStore<TextSegment> embeddingStore, EasyRagConfig config) {
        this.embeddingModel = embeddingModel;
        this.embeddingStore = embeddingStore;
        this.config = config;
    }

    public void ingest() {
        if (this.config.reuseEmbeddings().enabled() && this.embeddingStore instanceof InMemoryEmbeddingStore) {
            Path embeddingsFile = Path.of(this.config.reuseEmbeddings().file(), new String[0]).toAbsolutePath();
            if (!Files.exists(embeddingsFile, new LinkOption[0])) {
                try {
                    Files.createDirectories(embeddingsFile.getParent(), new FileAttribute[0]);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                this.ingestDocumentsFromFilesystem(this.config, this.embeddingStore, this.embeddingModel);
                LOGGER.infof("Writing embeddings to %s", (Object)embeddingsFile);
                ((InMemoryEmbeddingStore)this.embeddingStore).serializeToFile(embeddingsFile);
            } else {
                this.embeddingStore.toString();
            }
        } else {
            this.ingestDocumentsFromFilesystem(this.config, this.embeddingStore, this.embeddingModel);
        }
    }

    private List<Document> getDocuments(EasyRagConfig config) {
        PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher(config.pathMatcher());
        boolean recursive = config.recursive();
        return switch (config.pathType()) {
            default -> throw new IncompatibleClassChangeError();
            case EasyRagConfig.PathType.CLASSPATH -> {
                if (recursive) {
                    yield ClassPathDocumentLoader.loadDocumentsRecursively((String)config.path(), (PathMatcher)pathMatcher);
                }
                yield ClassPathDocumentLoader.loadDocuments((String)config.path(), (PathMatcher)pathMatcher);
            }
            case EasyRagConfig.PathType.FILESYSTEM -> recursive ? FileSystemDocumentLoader.loadDocumentsRecursively((String)config.path(), (PathMatcher)pathMatcher) : FileSystemDocumentLoader.loadDocuments((String)config.path(), (PathMatcher)pathMatcher);
        };
    }

    private void ingestDocumentsFromFilesystem(EasyRagConfig config, EmbeddingStore<TextSegment> embeddingStore, EmbeddingModel embeddingModel) {
        String msg = "Ingesting documents from %s: %s, path matcher = %s, recursive = %s".formatted(config.pathType().name().toLowerCase(), config.path(), config.pathMatcher(), config.recursive());
        LOGGER.info((Object)msg);
        List<Document> documents = this.getDocuments(config);
        DocumentSplitter documentSplitter = DocumentSplitters.recursive((int)config.maxSegmentSize(), (int)config.maxOverlapSize(), (TokenCountEstimator)new HuggingFaceTokenCountEstimator());
        List<Document> splitDocuments = documentSplitter.splitAll(documents).stream().map(split -> Document.document((String)split.text())).toList();
        EmbeddingStoreIngestor.builder().embeddingModel(embeddingModel).embeddingStore(embeddingStore).build().ingest(splitDocuments);
        LOGGER.info((Object)("Ingested " + documents.size() + " files as " + splitDocuments.size() + " documents"));
    }
}

