/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.runtime.listeners;

import dev.langchain4j.model.chat.listener.ChatModelErrorContext;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.listener.ChatModelRequestContext;
import dev.langchain4j.model.chat.listener.ChatModelResponseContext;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.output.TokenUsage;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Scope;
import io.quarkiverse.langchain4j.cost.Cost;
import io.quarkiverse.langchain4j.cost.CostEstimatorService;
import io.quarkiverse.langchain4j.runtime.listeners.ChatModelSpanContributor;
import io.quarkus.arc.All;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;

public class SpanChatModelListener
implements ChatModelListener {
    private static final Logger log = Logger.getLogger(SpanChatModelListener.class);
    private static final String OTEL_SCOPE_KEY_NAME = "OTelScope";
    private static final String OTEL_SPAN_KEY_NAME = "OTelSpan";
    private final Tracer tracer;
    private final CostEstimatorService costEstimatorService;
    private final List<ChatModelSpanContributor> chatModelSpanContributors;

    @Inject
    public SpanChatModelListener(Tracer tracer, CostEstimatorService costEstimatorService, @All List<ChatModelSpanContributor> chatModelSpanContributors) {
        this.tracer = tracer;
        this.costEstimatorService = costEstimatorService;
        this.chatModelSpanContributors = chatModelSpanContributors;
    }

    public void onRequest(ChatModelRequestContext requestContext) {
        ChatRequest request = requestContext.chatRequest();
        Span span = this.tracer.spanBuilder("completion " + request.parameters().modelName()).setAttribute("gen_ai.request.model", request.parameters().modelName()).setAttribute("gen_ai.request.temperature", request.parameters().temperature() != null ? request.parameters().temperature() : 0.0).setAttribute("gen_ai.request.top_p", request.parameters().topP() != null ? request.parameters().topP() : 0.0).startSpan();
        Scope scope = span.makeCurrent();
        Map attributes = requestContext.attributes();
        attributes.put(OTEL_SCOPE_KEY_NAME, scope);
        attributes.put(OTEL_SPAN_KEY_NAME, span);
        this.notifyContributorsOnRequest(requestContext, span);
    }

    public void onResponse(ChatModelResponseContext responseContext) {
        Map attributes = responseContext.attributes();
        Span span = (Span)attributes.get(OTEL_SPAN_KEY_NAME);
        if (span != null) {
            TokenUsage tokenUsage;
            ChatResponse response = responseContext.chatResponse();
            span.setAttribute("gen_ai.response.id", response.metadata().id());
            if (response.metadata().modelName() != null) {
                span.setAttribute("gen_ai.response.model", response.metadata().modelName());
            }
            if (response.finishReason() != null) {
                span.setAttribute("gen_ai.response.finish_reasons", response.finishReason().toString());
            }
            if ((tokenUsage = response.tokenUsage()) != null) {
                span.setAttribute("gen_ai.usage.completion_tokens", (long)tokenUsage.outputTokenCount().intValue()).setAttribute("gen_ai.usage.prompt_tokens", (long)tokenUsage.inputTokenCount().intValue());
                Cost costEstimate = this.costEstimatorService.estimate(responseContext);
                if (costEstimate != null) {
                    span.setAttribute("gen_ai.client.estimated_cost", costEstimate.toString());
                }
            }
            this.notifyContributorsOnResponse(responseContext, span);
            span.end();
        } else {
            log.warn((Object)"No Span found in response");
        }
        this.safeCloseScope(attributes);
    }

    public void onError(ChatModelErrorContext errorContext) {
        Map attributes = errorContext.attributes();
        Span span = (Span)attributes.get(OTEL_SPAN_KEY_NAME);
        if (span != null) {
            span.recordException(errorContext.error());
            this.notifyContributorsOnError(errorContext, span);
            span.end();
        } else {
            log.warn((Object)"No Span found in response");
        }
        this.safeCloseScope(errorContext.attributes());
    }

    private void safeCloseScope(Map<Object, Object> attributes) {
        Scope scope = (Scope)attributes.get(OTEL_SCOPE_KEY_NAME);
        if (scope == null) {
            log.warn((Object)"No Scope found in response");
        } else {
            try {
                scope.close();
            }
            catch (Exception e) {
                log.warn((Object)"Error closing scope", (Throwable)e);
            }
        }
    }

    private void notifyContributorsOnRequest(ChatModelRequestContext requestContext, Span span) {
        for (ChatModelSpanContributor contributor : this.chatModelSpanContributors) {
            try {
                contributor.onRequest(requestContext, span);
            }
            catch (Exception ex) {
                this.recordLogAndSwallow(span, ex);
            }
        }
    }

    private void notifyContributorsOnResponse(ChatModelResponseContext responseContext, Span span) {
        for (ChatModelSpanContributor contributor : this.chatModelSpanContributors) {
            try {
                contributor.onResponse(responseContext, span);
            }
            catch (Exception ex) {
                this.recordLogAndSwallow(span, ex);
            }
        }
    }

    private void notifyContributorsOnError(ChatModelErrorContext errorContext, Span span) {
        for (ChatModelSpanContributor contributor : this.chatModelSpanContributors) {
            try {
                contributor.onError(errorContext, span);
            }
            catch (Exception ex) {
                this.recordLogAndSwallow(span, ex);
            }
        }
    }

    private void recordLogAndSwallow(Span span, Exception ex) {
        span.recordException((Throwable)ex);
        log.warn((Object)"failure on contributor", (Throwable)ex);
    }
}

