/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.runtime.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import java.io.IOException;
import java.time.LocalTime;
import org.jboss.logging.Logger;

public class CustomLocalTimeDeserializer
extends JsonDeserializer<LocalTime> {
    private static final Logger log = Logger.getLogger(CustomLocalTimeDeserializer.class);

    public LocalTime deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.currentToken() == JsonToken.START_OBJECT) {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            int hour = node.get("hour").asInt();
            int minute = node.get("minute").asInt();
            int second = node.get("second").asInt();
            int nano = node.get("nano").asInt();
            try {
                return LocalTime.of(hour, minute, second, nano);
            }
            catch (Exception e) {
                log.debug((Object)"Failed to deserialize LocalTime", (Throwable)e);
                return null;
            }
        }
        return LocalTimeDeserializer.INSTANCE.deserialize(p, ctxt);
    }
}

