/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.runtime.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.LocalDate;
import org.jboss.logging.Logger;

public class CustomLocalDateDeserializer
extends JsonDeserializer<LocalDate> {
    private static final Logger log = Logger.getLogger(CustomLocalDateDeserializer.class);

    public LocalDate deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.currentToken() == JsonToken.START_OBJECT) {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            int year = node.get("year").asInt();
            int month = node.get("month").asInt();
            int day = node.get("day").asInt();
            try {
                return LocalDate.of(year, month, day);
            }
            catch (DateTimeException e) {
                log.debug((Object)"Failed to deserialize LocalDate", (Throwable)e);
                return null;
            }
        }
        return LocalDateDeserializer.INSTANCE.deserialize(p, ctxt);
    }
}

