/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.runtime.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.data.message.AiMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AiMessageDeserializer
extends StdDeserializer<AiMessage> {
    public AiMessageDeserializer() {
        super(AiMessage.class);
    }

    public AiMessage deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        if (node.has("toolExecutionRequests")) {
            JsonNode toolExecutionRequestsNode = node.get("toolExecutionRequests");
            JsonParser toolExecutionsRequestsParser = toolExecutionRequestsNode.traverse();
            toolExecutionsRequestsParser.nextToken();
            List toolExecutionRequests = (List)ctxt.readValue(toolExecutionsRequestsParser, (JavaType)ctxt.getTypeFactory().constructCollectionType(ArrayList.class, ToolExecutionRequest.class));
            return node.has("text") ? new AiMessage(node.get("text").asText(), toolExecutionRequests) : new AiMessage(toolExecutionRequests);
        }
        return new AiMessage(node.get("text").asText());
    }
}

