/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.runtime.aiservice;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.PartialThinking;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.rag.content.Content;
import dev.langchain4j.service.AiServiceContext;
import dev.langchain4j.service.IllegalConfigurationException;
import dev.langchain4j.service.TokenStream;
import dev.langchain4j.service.tool.BeforeToolExecution;
import dev.langchain4j.service.tool.ToolExecution;
import dev.langchain4j.service.tool.ToolExecutor;
import io.quarkiverse.langchain4j.runtime.aiservice.QuarkusAiServiceStreamingResponseHandler;
import io.vertx.core.Context;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class QuarkusAiServiceTokenStream
implements TokenStream {
    private final List<ChatMessage> messages;
    private final List<ToolSpecification> toolSpecifications;
    private final Map<String, ToolExecutor> toolExecutors;
    private final List<Content> retrievedContents;
    private final AiServiceContext context;
    private final Object memoryId;
    private final Context cxtx;
    private final boolean switchToWorkerThreadForToolExecution;
    private final boolean switchToWorkerForEmission;
    private Consumer<String> partialResponseHandler;
    private Consumer<PartialThinking> partialThinkingHandler;
    private Consumer<List<Content>> contentsHandler;
    private Consumer<Throwable> errorHandler;
    private Consumer<Response<AiMessage>> completionHandler;
    private Consumer<BeforeToolExecution> beforeToolExecutionHandler;
    private Consumer<ToolExecution> toolExecuteHandler;
    private Consumer<ChatResponse> completeResponseHandler;
    private int onPartialResponseInvoked;
    private int onPartialThinkingInvoked;
    private int onCompleteResponseInvoked;
    private int onRetrievedInvoked;
    private int onErrorInvoked;
    private int ignoreErrorsInvoked;
    private int beforeToolExecutionInvoked;
    private int toolExecuteInvoked;

    public QuarkusAiServiceTokenStream(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications, Map<String, ToolExecutor> toolExecutors, List<Content> retrievedContents, AiServiceContext context, Object memoryId, Context ctxt, boolean switchToWorkerThreadForToolExecution, boolean switchToWorkerForEmission) {
        this.messages = (List)ValidationUtils.ensureNotEmpty(messages, (String)"messages");
        this.toolSpecifications = Utils.copyIfNotNull(toolSpecifications);
        this.toolExecutors = Utils.copyIfNotNull(toolExecutors);
        this.retrievedContents = retrievedContents;
        this.context = (AiServiceContext)ValidationUtils.ensureNotNull((Object)context, (String)"context");
        this.memoryId = ValidationUtils.ensureNotNull((Object)memoryId, (String)"memoryId");
        ValidationUtils.ensureNotNull((Object)context.streamingChatModel, (String)"streamingChatModel");
        this.cxtx = ctxt;
        this.switchToWorkerThreadForToolExecution = switchToWorkerThreadForToolExecution;
        this.switchToWorkerForEmission = switchToWorkerForEmission;
    }

    public TokenStream onPartialResponse(Consumer<String> partialResponseHandler) {
        this.partialResponseHandler = partialResponseHandler;
        ++this.onPartialResponseInvoked;
        return this;
    }

    public TokenStream onPartialThinking(Consumer<PartialThinking> partialThinkingHandler) {
        this.partialThinkingHandler = partialThinkingHandler;
        ++this.onPartialThinkingInvoked;
        return this;
    }

    public TokenStream onRetrieved(Consumer<List<Content>> contentsHandler) {
        this.contentsHandler = contentsHandler;
        ++this.onRetrievedInvoked;
        return this;
    }

    public TokenStream beforeToolExecution(Consumer<BeforeToolExecution> beforeToolExecutionHandler) {
        this.beforeToolExecutionHandler = beforeToolExecutionHandler;
        ++this.beforeToolExecutionInvoked;
        return this;
    }

    public TokenStream onToolExecuted(Consumer<ToolExecution> toolExecuteHandler) {
        this.toolExecuteHandler = toolExecuteHandler;
        ++this.toolExecuteInvoked;
        return this;
    }

    public TokenStream onCompleteResponse(Consumer<ChatResponse> completionHandler) {
        this.completeResponseHandler = completionHandler;
        ++this.onCompleteResponseInvoked;
        return this;
    }

    public TokenStream onError(Consumer<Throwable> errorHandler) {
        this.errorHandler = errorHandler;
        ++this.onErrorInvoked;
        return this;
    }

    public TokenStream ignoreErrors() {
        this.errorHandler = null;
        ++this.ignoreErrorsInvoked;
        return this;
    }

    public void start() {
        block3: {
            this.validateConfiguration();
            ChatRequest chatRequest = new ChatRequest.Builder().messages(this.messages).toolSpecifications(this.toolSpecifications).build();
            QuarkusAiServiceStreamingResponseHandler handler = new QuarkusAiServiceStreamingResponseHandler(this.context, this.memoryId, this.partialResponseHandler, this.partialThinkingHandler, this.beforeToolExecutionHandler, this.toolExecuteHandler, this.completeResponseHandler, this.completionHandler, this.errorHandler, this.initTemporaryMemory(this.context, this.messages), new TokenUsage(), this.toolSpecifications, this.toolExecutors, this.switchToWorkerThreadForToolExecution, this.switchToWorkerForEmission, this.cxtx);
            if (this.contentsHandler != null && this.retrievedContents != null) {
                this.contentsHandler.accept(this.retrievedContents);
            }
            try {
                this.context.streamingChatModel.chat(chatRequest, (StreamingChatResponseHandler)handler);
            }
            catch (Exception e) {
                if (this.errorHandler == null) break block3;
                this.errorHandler.accept(e);
            }
        }
    }

    private void validateConfiguration() {
        if (this.onPartialResponseInvoked != 1) {
            throw new IllegalConfigurationException("One of [onPartialResponse, onNext] must be invoked on TokenStream exactly 1 time");
        }
        if (this.onCompleteResponseInvoked > 1) {
            throw new IllegalConfigurationException("One of [onCompleteResponse, onComplete] can be invoked on TokenStream at most 1 time");
        }
        if (this.onRetrievedInvoked > 1) {
            throw new IllegalConfigurationException("onRetrieved can be invoked on TokenStream at most 1 time");
        }
        if (this.toolExecuteInvoked > 1) {
            throw new IllegalConfigurationException("onToolExecuted can be invoked on TokenStream at most 1 time");
        }
        if (this.beforeToolExecutionInvoked > 1) {
            throw new IllegalConfigurationException("beforeToolExecution can be invoked on TokenStream at most 1 time");
        }
        if (this.onPartialThinkingInvoked > 1) {
            throw new IllegalConfigurationException("onPartialThinking can be invoked on TokenStream at most 1 time");
        }
        if (this.onErrorInvoked + this.ignoreErrorsInvoked != 1) {
            throw new IllegalConfigurationException("One of [onError, ignoreErrors] must be invoked on TokenStream exactly 1 time");
        }
    }

    private List<ChatMessage> initTemporaryMemory(AiServiceContext context, List<ChatMessage> messagesToSend) {
        if (context.hasChatMemory()) {
            return Collections.emptyList();
        }
        return new ArrayList<ChatMessage>(messagesToSend);
    }
}

