/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.runtime.aiservice;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.DefaultChatRequestParameters;
import dev.langchain4j.model.chat.request.ToolChoice;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.ChatResponseMetadata;
import dev.langchain4j.model.chat.response.PartialThinking;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.service.AiServiceContext;
import dev.langchain4j.service.tool.BeforeToolExecution;
import dev.langchain4j.service.tool.ToolExecution;
import dev.langchain4j.service.tool.ToolExecutor;
import io.vertx.core.Context;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import org.jboss.logging.Logger;

public class QuarkusAiServiceStreamingResponseHandler
implements StreamingChatResponseHandler {
    private final Logger log = Logger.getLogger(QuarkusAiServiceStreamingResponseHandler.class);
    private final AiServiceContext context;
    private final Object memoryId;
    private final Consumer<String> partialResponseHandler;
    private final Consumer<PartialThinking> partialThinkingHandler;
    private final Consumer<Response<AiMessage>> completionHandler;
    private final Consumer<BeforeToolExecution> beforeToolExecutionHandler;
    private final Consumer<ToolExecution> toolExecuteHandler;
    private final Consumer<ChatResponse> completeResponseHandler;
    private final Consumer<Throwable> errorHandler;
    private final List<ChatMessage> temporaryMemory;
    private final TokenUsage tokenUsage;
    private final List<ToolSpecification> toolSpecifications;
    private final Map<String, ToolExecutor> toolExecutors;
    private final Context executionContext;
    private final boolean mustSwitchToWorkerThread;
    private final boolean switchToWorkerForEmission;
    private final ExecutorService executor;

    QuarkusAiServiceStreamingResponseHandler(AiServiceContext context, Object memoryId, Consumer<String> partialResponseHandler, Consumer<PartialThinking> partialThinkingHandler, Consumer<BeforeToolExecution> beforeToolExecutionHandler, Consumer<ToolExecution> toolExecuteHandler, Consumer<ChatResponse> completeResponseHandler, Consumer<Response<AiMessage>> completionHandler, Consumer<Throwable> errorHandler, List<ChatMessage> temporaryMemory, TokenUsage tokenUsage, List<ToolSpecification> toolSpecifications, Map<String, ToolExecutor> toolExecutors, boolean mustSwitchToWorkerThread, boolean switchToWorkerForEmission, Context cxtx) {
        this.context = (AiServiceContext)ValidationUtils.ensureNotNull((Object)context, (String)"context");
        this.memoryId = ValidationUtils.ensureNotNull((Object)memoryId, (String)"memoryId");
        this.partialResponseHandler = (Consumer)ValidationUtils.ensureNotNull(partialResponseHandler, (String)"partialResponseHandler");
        this.partialThinkingHandler = partialThinkingHandler;
        this.beforeToolExecutionHandler = beforeToolExecutionHandler;
        this.completeResponseHandler = completeResponseHandler;
        this.completionHandler = completionHandler;
        this.toolExecuteHandler = toolExecuteHandler;
        this.errorHandler = errorHandler;
        this.temporaryMemory = new ArrayList<ChatMessage>(temporaryMemory);
        this.tokenUsage = (TokenUsage)ValidationUtils.ensureNotNull((Object)tokenUsage, (String)"tokenUsage");
        this.toolSpecifications = Utils.copyIfNotNull(toolSpecifications);
        this.toolExecutors = Utils.copyIfNotNull(toolExecutors);
        this.mustSwitchToWorkerThread = mustSwitchToWorkerThread;
        this.executionContext = cxtx;
        this.switchToWorkerForEmission = switchToWorkerForEmission;
        this.executor = this.executionContext == null ? Executors.newSingleThreadExecutor() : null;
    }

    public QuarkusAiServiceStreamingResponseHandler(AiServiceContext context, Object memoryId, Consumer<String> partialResponseHandler, Consumer<PartialThinking> partialThinkingHandler, Consumer<BeforeToolExecution> beforeToolExecutionHandler, Consumer<ToolExecution> toolExecuteHandler, Consumer<ChatResponse> completeResponseHandler, Consumer<Response<AiMessage>> completionHandler, Consumer<Throwable> errorHandler, List<ChatMessage> temporaryMemory, TokenUsage sum, List<ToolSpecification> toolSpecifications, Map<String, ToolExecutor> toolExecutors, boolean mustSwitchToWorkerThread, boolean switchToWorkerForEmission, Context executionContext, ExecutorService executor) {
        this.context = context;
        this.memoryId = memoryId;
        this.partialResponseHandler = (Consumer)ValidationUtils.ensureNotNull(partialResponseHandler, (String)"partialResponseHandler");
        this.partialThinkingHandler = partialThinkingHandler;
        this.beforeToolExecutionHandler = beforeToolExecutionHandler;
        this.toolExecuteHandler = toolExecuteHandler;
        this.completeResponseHandler = completeResponseHandler;
        this.completionHandler = completionHandler;
        this.errorHandler = errorHandler;
        this.temporaryMemory = temporaryMemory;
        this.tokenUsage = sum;
        this.toolSpecifications = toolSpecifications;
        this.toolExecutors = toolExecutors;
        this.mustSwitchToWorkerThread = mustSwitchToWorkerThread;
        this.switchToWorkerForEmission = switchToWorkerForEmission;
        this.executionContext = executionContext;
        this.executor = executor;
    }

    public void onPartialResponse(final String partialResponse) {
        this.execute(new Runnable(){
            final /* synthetic */ QuarkusAiServiceStreamingResponseHandler this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.partialResponseHandler.accept(partialResponse);
            }
        });
    }

    public void onPartialThinking(final PartialThinking partialThinking) {
        if (this.partialThinkingHandler != null) {
            this.execute(new Runnable(){
                final /* synthetic */ QuarkusAiServiceStreamingResponseHandler this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    this.this$0.partialThinkingHandler.accept(partialThinking);
                }
            });
        }
    }

    private void executeTools(Runnable runnable) {
        if (this.mustSwitchToWorkerThread && Context.isOnEventLoopThread()) {
            this.executeOnWorkerThread(runnable, false);
        } else {
            runnable.run();
        }
    }

    private void execute(Runnable runnable) {
        if (this.switchToWorkerForEmission && Context.isOnEventLoopThread()) {
            this.executeOnWorkerThread(runnable, true);
        } else {
            runnable.run();
        }
    }

    private void executeOnWorkerThread(final Runnable runnable, boolean ordered) {
        if (this.executionContext != null) {
            this.executionContext.executeBlocking((Callable)new Callable<Object>(){
                final /* synthetic */ QuarkusAiServiceStreamingResponseHandler this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public Object call() throws Exception {
                    runnable.run();
                    return null;
                }
            }, ordered);
        } else {
            this.executor.submit(runnable);
        }
    }

    public void onCompleteResponse(final ChatResponse completeResponse) {
        final AiMessage aiMessage = completeResponse.aiMessage();
        if (aiMessage.hasToolExecutionRequests()) {
            this.executeTools(new Runnable(){
                final /* synthetic */ QuarkusAiServiceStreamingResponseHandler this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    ToolChoice toolChoice;
                    this.this$0.addToMemory((ChatMessage)aiMessage);
                    for (ToolExecutionRequest toolExecutionRequest : aiMessage.toolExecutionRequests()) {
                        if (this.this$0.beforeToolExecutionHandler != null) {
                            BeforeToolExecution beforeToolExecution = BeforeToolExecution.builder().request(toolExecutionRequest).build();
                            this.this$0.beforeToolExecutionHandler.accept(beforeToolExecution);
                        }
                        String toolName = toolExecutionRequest.name();
                        ToolExecutor toolExecutor = this.this$0.toolExecutors.get(toolName);
                        String toolExecutionResult = toolExecutor.execute(toolExecutionRequest, this.this$0.memoryId);
                        ToolExecutionResultMessage toolExecutionResultMessage = ToolExecutionResultMessage.from((ToolExecutionRequest)toolExecutionRequest, (String)toolExecutionResult);
                        ToolExecution toolExecution = ToolExecution.builder().request(toolExecutionRequest).result(toolExecutionResult).build();
                        if (this.this$0.toolExecuteHandler != null) {
                            this.this$0.toolExecuteHandler.accept(toolExecution);
                        }
                        this.this$0.addToMemory((ChatMessage)toolExecutionResultMessage);
                    }
                    DefaultChatRequestParameters.Builder parametersBuilder = ChatRequestParameters.builder();
                    parametersBuilder.toolSpecifications(this.this$0.toolSpecifications);
                    if (Objects.nonNull(this.this$0.context.streamingChatModel.defaultRequestParameters()) && Objects.nonNull(toolChoice = this.this$0.context.streamingChatModel.defaultRequestParameters().toolChoice()) && toolChoice.equals((Object)ToolChoice.REQUIRED)) {
                        parametersBuilder.toolChoice(ToolChoice.AUTO);
                    }
                    ChatRequest chatRequest = ChatRequest.builder().messages(this.this$0.messagesToSend(this.this$0.memoryId)).parameters(parametersBuilder.build()).build();
                    QuarkusAiServiceStreamingResponseHandler handler = new QuarkusAiServiceStreamingResponseHandler(this.this$0.context, this.this$0.memoryId, this.this$0.partialResponseHandler, this.this$0.partialThinkingHandler, this.this$0.beforeToolExecutionHandler, this.this$0.toolExecuteHandler, this.this$0.completeResponseHandler, this.this$0.completionHandler, this.this$0.errorHandler, this.this$0.temporaryMemory, TokenUsage.sum((TokenUsage)this.this$0.tokenUsage, (TokenUsage)completeResponse.metadata().tokenUsage()), this.this$0.toolSpecifications, this.this$0.toolExecutors, this.this$0.mustSwitchToWorkerThread, this.this$0.switchToWorkerForEmission, this.this$0.executionContext, this.this$0.executor);
                    this.this$0.context.streamingChatModel.chat(chatRequest, (StreamingChatResponseHandler)handler);
                }
            });
        } else if (this.completeResponseHandler != null) {
            Runnable runnable = new Runnable(){
                final /* synthetic */ QuarkusAiServiceStreamingResponseHandler this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        ChatResponse finalChatResponse = ChatResponse.builder().aiMessage(aiMessage).metadata(ChatResponseMetadata.builder().id(completeResponse.metadata().id()).modelName(completeResponse.metadata().modelName()).tokenUsage(TokenUsage.sum((TokenUsage)this.this$0.tokenUsage, (TokenUsage)completeResponse.metadata().tokenUsage())).finishReason(completeResponse.metadata().finishReason()).build()).build();
                        this.this$0.addToMemory((ChatMessage)aiMessage);
                        this.this$0.completeResponseHandler.accept(finalChatResponse);
                    }
                    finally {
                        this.this$0.shutdown();
                    }
                }
            };
            this.execute(runnable);
        } else if (this.completionHandler != null) {
            Runnable runnable = new Runnable(){
                final /* synthetic */ QuarkusAiServiceStreamingResponseHandler this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    Response finalResponse = Response.from((Object)aiMessage, (TokenUsage)TokenUsage.sum((TokenUsage)this.this$0.tokenUsage, (TokenUsage)completeResponse.metadata().tokenUsage()), (FinishReason)completeResponse.metadata().finishReason());
                    this.this$0.addToMemory((ChatMessage)aiMessage);
                    this.this$0.completionHandler.accept((Response<AiMessage>)finalResponse);
                }
            };
            this.execute(runnable);
        }
    }

    private void shutdown() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    private void addToMemory(ChatMessage chatMessage) {
        if (this.context.hasChatMemory()) {
            this.context.chatMemoryService.getChatMemory(this.memoryId).add(chatMessage);
        } else {
            this.temporaryMemory.add(chatMessage);
        }
    }

    private List<ChatMessage> messagesToSend(Object memoryId) {
        return this.context.hasChatMemory() ? this.context.chatMemoryService.getChatMemory(memoryId).messages() : this.temporaryMemory;
    }

    public void onError(final Throwable error) {
        if (this.errorHandler != null) {
            this.execute(new Runnable(){
                final /* synthetic */ QuarkusAiServiceStreamingResponseHandler this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        this.this$0.errorHandler.accept(error);
                    }
                    catch (Exception e) {
                        this.this$0.log.error((Object)"While handling the following error...", error);
                        this.this$0.log.error((Object)"...the following error happened", (Throwable)e);
                    }
                    finally {
                        this.this$0.shutdown();
                    }
                }
            });
        } else {
            this.log.warn((Object)"Ignored error", error);
        }
    }
}

