/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.runtime.aiservice;

import dev.langchain4j.memory.ChatMemory;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.image.ImageModel;
import dev.langchain4j.service.AiServiceContext;
import io.quarkiverse.langchain4j.ModelName;
import io.quarkiverse.langchain4j.runtime.aiservice.AiServiceMethodCreateInfo;
import io.quarkiverse.langchain4j.runtime.aiservice.ChatMemorySeeder;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;

public class QuarkusAiServiceContext
extends AiServiceContext {
    public ChatMemorySeeder chatMemorySeeder;
    public ImageModel imageModel;
    public Integer maxSequentialToolExecutions;

    public QuarkusAiServiceContext() {
        super(null);
    }

    public QuarkusAiServiceContext(Class<?> aiServiceClass) {
        super(aiServiceClass);
    }

    public void close() {
        this.clearChatMemory();
    }

    private void clearChatMemory() {
        if (this.hasChatMemory()) {
            this.chatMemoryService.clearAll();
        }
    }

    public void removeChatMemoryIds(Object ... ids) {
        if (!this.hasChatMemory()) {
            return;
        }
        for (Object id : ids) {
            ChatMemory chatMemory = this.chatMemoryService.evictChatMemory(id);
            if (chatMemory == null) continue;
            chatMemory.clear();
        }
    }

    public boolean evictChatMemory(Object id) {
        if (!this.hasChatMemory()) {
            return false;
        }
        return this.chatMemoryService.evictChatMemory(id) != null;
    }

    public ChatMemory getChatMemory(Object id) {
        if (!this.hasChatMemory()) {
            return null;
        }
        return this.chatMemoryService.getChatMemory(id);
    }

    public ChatModel effectiveChatModel(AiServiceMethodCreateInfo createInfo, Object[] methodArgs) {
        if (createInfo.getOverrideChatModelParamPosition().isPresent()) {
            return this.effectiveChatModel((String)methodArgs[createInfo.getOverrideChatModelParamPosition().get()]);
        }
        return this.chatModel;
    }

    private ChatModel effectiveChatModel(String modelName) {
        if (modelName == null) {
            return this.chatModel;
        }
        InstanceHandle instance = Arc.container().instance(ChatModel.class, new Annotation[]{ModelName.Literal.of(modelName)});
        if (instance.isAvailable()) {
            return (ChatModel)instance.get();
        }
        HashSet<String> availableNames = new HashSet<String>();
        block0: for (Instance.Handle handle : Arc.container().select(ChatModel.class, new Annotation[]{Any.Literal.INSTANCE}).handles()) {
            Set qualifiers = handle.getBean().getQualifiers();
            for (Annotation qualifier : qualifiers) {
                if (!qualifier.annotationType().equals(ModelName.class)) continue;
                availableNames.add(((ModelName)qualifier).value());
                continue block0;
            }
        }
        throw new IllegalStateException("No configured ChatModel named '" + modelName + "' was found. The application has made available the following named ChatModel instances: " + String.join((CharSequence)", ", availableNames));
    }
}

