/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.runtime.aiservice;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.ChatResponseMetadata;
import dev.langchain4j.rag.content.Content;
import dev.langchain4j.service.tool.ToolExecution;
import java.util.List;

public class ChatEvent {
    private final ChatEventType eventType;

    public ChatEvent(ChatEventType eventType) {
        this.eventType = eventType;
    }

    public ChatEventType getEventType() {
        return this.eventType;
    }

    public static enum ChatEventType {
        Completed,
        ToolExecuted,
        BeforeToolExecution,
        PartialResponse,
        ContentFetched,
        AccumulatedResponse,
        PartialThinking;

    }

    public static class PartialThinkingEvent
    extends ChatEvent {
        private final String text;

        public PartialThinkingEvent(String text) {
            super(ChatEventType.PartialThinking);
            this.text = text;
        }

        public String getText() {
            return this.text;
        }
    }

    public static class AccumulatedResponseEvent
    extends ChatEvent {
        private final String message;
        private final ChatResponseMetadata metadata;

        public AccumulatedResponseEvent(String message, ChatResponseMetadata metadata) {
            super(ChatEventType.AccumulatedResponse);
            this.message = message;
            this.metadata = metadata;
        }

        public String getMessage() {
            return this.message;
        }

        public ChatResponseMetadata getMetadata() {
            return this.metadata;
        }
    }

    public static class ContentFetchedEvent
    extends ChatEvent {
        private final List<Content> content;

        public ContentFetchedEvent(List<Content> content) {
            super(ChatEventType.ContentFetched);
            this.content = content;
        }

        public List<Content> getContent() {
            return this.content;
        }
    }

    public static class PartialResponseEvent
    extends ChatEvent {
        private final String chunk;

        public PartialResponseEvent(String chunk) {
            super(ChatEventType.PartialResponse);
            this.chunk = chunk;
        }

        public String getChunk() {
            return this.chunk;
        }
    }

    public static class BeforeToolExecutionEvent
    extends ChatEvent {
        private final ToolExecutionRequest request;

        public BeforeToolExecutionEvent(ToolExecutionRequest request) {
            super(ChatEventType.BeforeToolExecution);
            this.request = request;
        }

        public ToolExecutionRequest getRequest() {
            return this.request;
        }
    }

    public static class ToolExecutedEvent
    extends ChatEvent {
        private final ToolExecution execution;

        public ToolExecutedEvent(ToolExecution execution) {
            super(ChatEventType.ToolExecuted);
            this.execution = execution;
        }

        public ToolExecution getExecution() {
            return this.execution;
        }
    }

    public static class ChatCompletedEvent
    extends ChatEvent {
        private final ChatResponse chatResponse;

        public ChatCompletedEvent(ChatResponse chatResponse) {
            super(ChatEventType.Completed);
            this.chatResponse = chatResponse;
        }

        public ChatResponse getChatResponse() {
            return this.chatResponse;
        }
    }
}

