/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.runtime.aiservice;

import io.quarkiverse.langchain4j.audit.AuditSourceInfo;
import io.quarkiverse.langchain4j.runtime.aiservice.AiServiceMethodCreateInfo;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

final class AuditSourceInfoImpl
implements AuditSourceInfo {
    private final UUID interactionId = UUID.randomUUID();
    private final String interfaceName;
    private final String methodName;
    private final Optional<Integer> memoryIDParamPosition;
    private final Object[] methodParams;

    public AuditSourceInfoImpl(String interfaceName, String methodName, Optional<Integer> memoryIDParamPosition, Object ... methodParams) {
        this.interfaceName = interfaceName;
        this.methodName = methodName;
        this.memoryIDParamPosition = memoryIDParamPosition;
        this.methodParams = methodParams;
    }

    public AuditSourceInfoImpl(AiServiceMethodCreateInfo createInfo, Object ... methodParams) {
        this(createInfo.getInterfaceName(), createInfo.getMethodName(), createInfo.getMemoryIdParamPosition(), methodParams);
    }

    @Override
    public String interfaceName() {
        return this.interfaceName;
    }

    @Override
    public String methodName() {
        return this.methodName;
    }

    @Override
    public Optional<Integer> memoryIDParamPosition() {
        return this.memoryIDParamPosition;
    }

    @Override
    public Object[] methodParams() {
        return this.methodParams;
    }

    @Override
    public UUID interactionId() {
        return this.interactionId;
    }

    public String toString() {
        return "AuditSourceInfo{interactionId=" + String.valueOf(this.interactionId) + ", interfaceName='" + this.interfaceName + "', methodName='" + this.methodName + "', memoryIDParamPosition=" + String.valueOf(this.memoryIDParamPosition) + ", methodParams=" + Arrays.toString(this.methodParams) + "}";
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuditSourceInfoImpl that = (AuditSourceInfoImpl)o;
        return Objects.equals(this.interactionId, that.interactionId);
    }

    public int hashCode() {
        return Objects.hashCode(this.interactionId);
    }
}

