/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.runtime.aiservice;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.audio.Audio;
import dev.langchain4j.data.image.Image;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.AudioContent;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ImageContent;
import dev.langchain4j.data.message.PdfFileContent;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.TextContent;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.data.pdf.PdfFile;
import dev.langchain4j.guardrail.ChatExecutor;
import dev.langchain4j.guardrail.GuardrailRequestParams;
import dev.langchain4j.internal.Exceptions;
import dev.langchain4j.memory.ChatMemory;
import dev.langchain4j.model.chat.Capability;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.DefaultChatRequestParameters;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.chat.request.ResponseFormatType;
import dev.langchain4j.model.chat.request.ToolChoice;
import dev.langchain4j.model.chat.request.json.JsonSchema;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.input.Prompt;
import dev.langchain4j.model.input.PromptTemplate;
import dev.langchain4j.model.input.structured.StructuredPrompt;
import dev.langchain4j.model.input.structured.StructuredPromptProcessor;
import dev.langchain4j.model.moderation.Moderation;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.rag.AugmentationRequest;
import dev.langchain4j.rag.AugmentationResult;
import dev.langchain4j.rag.query.Metadata;
import dev.langchain4j.service.AiServiceContext;
import dev.langchain4j.service.AiServiceTokenStream;
import dev.langchain4j.service.AiServiceTokenStreamParameters;
import dev.langchain4j.service.AiServices;
import dev.langchain4j.service.Result;
import dev.langchain4j.service.guardrail.GuardrailService;
import dev.langchain4j.service.output.ServiceOutputParser;
import dev.langchain4j.service.tool.ToolErrorHandlerResult;
import dev.langchain4j.service.tool.ToolExecutor;
import dev.langchain4j.service.tool.ToolProviderRequest;
import dev.langchain4j.service.tool.ToolProviderResult;
import dev.langchain4j.spi.ServiceHelper;
import io.quarkiverse.langchain4j.audit.AuditSourceInfo;
import io.quarkiverse.langchain4j.audit.InitialMessagesCreatedEvent;
import io.quarkiverse.langchain4j.audit.LLMInteractionCompleteEvent;
import io.quarkiverse.langchain4j.audit.LLMInteractionFailureEvent;
import io.quarkiverse.langchain4j.audit.ResponseFromLLMReceivedEvent;
import io.quarkiverse.langchain4j.audit.ToolExecutedEvent;
import io.quarkiverse.langchain4j.audit.internal.DefaultInitialMessagesCreatedEvent;
import io.quarkiverse.langchain4j.audit.internal.DefaultLLMInteractionCompleteEvent;
import io.quarkiverse.langchain4j.audit.internal.DefaultLLMInteractionFailureEvent;
import io.quarkiverse.langchain4j.audit.internal.DefaultResponseFromLLMReceivedEvent;
import io.quarkiverse.langchain4j.audit.internal.DefaultToolExecutedEvent;
import io.quarkiverse.langchain4j.response.ResponseAugmenterParams;
import io.quarkiverse.langchain4j.runtime.ContextLocals;
import io.quarkiverse.langchain4j.runtime.QuarkusServiceOutputParser;
import io.quarkiverse.langchain4j.runtime.ResponseSchemaUtil;
import io.quarkiverse.langchain4j.runtime.aiservice.AiServiceMethodCreateInfo;
import io.quarkiverse.langchain4j.runtime.aiservice.AuditSourceInfoImpl;
import io.quarkiverse.langchain4j.runtime.aiservice.ChatEvent;
import io.quarkiverse.langchain4j.runtime.aiservice.ChatMemorySeeder;
import io.quarkiverse.langchain4j.runtime.aiservice.CommittableChatMemory;
import io.quarkiverse.langchain4j.runtime.aiservice.DefaultCommittableChatMemory;
import io.quarkiverse.langchain4j.runtime.aiservice.EmptyUserMessage;
import io.quarkiverse.langchain4j.runtime.aiservice.GuardrailsSupport;
import io.quarkiverse.langchain4j.runtime.aiservice.NoopChatMemory;
import io.quarkiverse.langchain4j.runtime.aiservice.QuarkusAiServiceContext;
import io.quarkiverse.langchain4j.runtime.aiservice.QuarkusToolProviderRequest;
import io.quarkiverse.langchain4j.runtime.aiservice.ResponseAugmenterSupport;
import io.quarkiverse.langchain4j.runtime.aiservice.TokenStreamMulti;
import io.quarkiverse.langchain4j.runtime.types.TypeUtil;
import io.quarkiverse.langchain4j.spi.DefaultMemoryIdProvider;
import io.quarkus.arc.Arc;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.vertx.core.Context;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Flow;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

public class AiServiceMethodImplementationSupport {
    private static final Logger log = Logger.getLogger(AiServiceMethodImplementationSupport.class);
    private static final int DEFAULT_MAX_SEQUENTIAL_TOOL_EXECUTIONS = 10;
    private static final List<DefaultMemoryIdProvider> DEFAULT_MEMORY_ID_PROVIDERS;
    private static final ServiceOutputParser SERVICE_OUTPUT_PARSER;

    public Object implement(Input input) {
        if (ContextLocals.duplicatedContextActive()) {
            ContextLocals.put("aiservice.classname", input.context.aiServiceClass.getName());
            ContextLocals.put("aiservice.methodname", input.createInfo.getMethodName());
        }
        QuarkusAiServiceContext context = input.context;
        AiServiceMethodCreateInfo createInfo = input.createInfo;
        Object[] methodArgs = input.methodArgs;
        AuditSourceInfoImpl auditSourceInfo = new AuditSourceInfoImpl(createInfo, methodArgs);
        BeanManager beanManager = Arc.container().beanManager();
        try {
            Object result = AiServiceMethodImplementationSupport.doImplement(createInfo, methodArgs, context, auditSourceInfo);
            beanManager.getEvent().select(LLMInteractionCompleteEvent.class, new Annotation[0]).fire((Object)new DefaultLLMInteractionCompleteEvent(auditSourceInfo, result));
            return result;
        }
        catch (Exception e) {
            beanManager.getEvent().select(LLMInteractionFailureEvent.class, new Annotation[0]).fire((Object)new DefaultLLMInteractionFailureEvent(auditSourceInfo, e));
            throw e;
        }
    }

    private static Object doImplement(final AiServiceMethodCreateInfo methodCreateInfo, Object[] methodArgs, final QuarkusAiServiceContext context, AuditSourceInfo auditSourceInfo) {
        int maxSequentialToolExecutions;
        List<ChatMessage> messagesToSend;
        CommittableChatMemory committableChatMemory;
        HashMap<String, ToolExecutor> toolExecutors;
        boolean isStringMulti;
        final boolean isRunningOnWorkerThread = !Context.isOnEventLoopThread();
        final Object memoryId = AiServiceMethodImplementationSupport.memoryId(methodCreateInfo, methodArgs, context.hasChatMemory());
        final Optional<SystemMessage> systemMessage = AiServiceMethodImplementationSupport.prepareSystemMessage(methodCreateInfo, methodArgs, context, memoryId);
        boolean supportsJsonSchema = AiServiceMethodImplementationSupport.supportsJsonSchema(context, methodCreateInfo, methodArgs);
        UserMessage userMessage = AiServiceMethodImplementationSupport.prepareUserMessage(context, methodCreateInfo, methodArgs, supportsJsonSchema);
        final Map<String, Object> templateVariables = AiServiceMethodImplementationSupport.getTemplateVariables(methodArgs, methodCreateInfo.getUserMessageInfo());
        Type returnType = methodCreateInfo.getReturnType();
        boolean isMulti = TypeUtil.isMulti(returnType);
        boolean bl = isStringMulti = isMulti && returnType instanceof ParameterizedType && TypeUtil.isTypeOf(((ParameterizedType)returnType).getActualTypeArguments()[0], String.class);
        if (TypeUtil.isImage(returnType) || TypeUtil.isResultImage(returnType)) {
            return AiServiceMethodImplementationSupport.doImplementGenerateImage(methodCreateInfo, context, systemMessage, userMessage, memoryId, returnType, templateVariables, auditSourceInfo);
        }
        BeanManager beanManager = Arc.container().beanManager();
        beanManager.getEvent().select(InitialMessagesCreatedEvent.class, new Annotation[0]).fire((Object)new DefaultInitialMessagesCreatedEvent(auditSourceInfo, systemMessage, userMessage));
        final boolean needsMemorySeed = AiServiceMethodImplementationSupport.needsMemorySeed(context, memoryId);
        boolean hasMethodSpecificTools = methodCreateInfo.getToolClassInfo() != null && !methodCreateInfo.getToolClassInfo().isEmpty();
        ArrayList<ToolSpecification> toolSpecifications = hasMethodSpecificTools ? methodCreateInfo.getToolSpecifications() : context.toolService.toolSpecifications();
        HashMap<String, ToolExecutor> hashMap = toolExecutors = hasMethodSpecificTools ? methodCreateInfo.getToolExecutors() : context.toolService.toolExecutors();
        if (context.toolService.toolProvider() != null) {
            toolSpecifications = toolSpecifications != null ? new ArrayList<ToolSpecification>(toolSpecifications) : new ArrayList();
            toolExecutors = toolExecutors != null ? new HashMap<String, ToolExecutor>(toolExecutors) : new HashMap();
            QuarkusToolProviderRequest request = new QuarkusToolProviderRequest(memoryId, userMessage, methodCreateInfo.getMcpClientNames());
            ToolProviderResult result = context.toolService.toolProvider().provideTools((ToolProviderRequest)request);
            for (ToolSpecification specification : result.tools().keySet()) {
                toolSpecifications.add(specification);
                toolExecutors.put(specification.name(), (ToolExecutor)result.tools().get(specification));
            }
        }
        final ArrayList<ToolSpecification> effectiveToolSpecifications = toolSpecifications;
        final HashMap<String, ToolExecutor> finalToolExecutors = toolExecutors;
        AugmentationResult augmentationResult = null;
        if (context.retrievalAugmentor != null) {
            List chatMemory = context.hasChatMemory() ? context.chatMemoryService.getChatMemory(memoryId).messages() : null;
            Metadata metadata = Metadata.from((ChatMessage)userMessage, (Object)memoryId, (List)chatMemory);
            final AugmentationRequest augmentationRequest = new AugmentationRequest((ChatMessage)userMessage, metadata);
            if (!isMulti) {
                augmentationResult = context.retrievalAugmentor.augment(augmentationRequest);
                userMessage = (UserMessage)augmentationResult.chatMessage();
            } else {
                CompletableFuture<AugmentationResult> augmentationResultCF = CompletableFuture.supplyAsync(new Supplier<AugmentationResult>(){

                    @Override
                    public AugmentationResult get() {
                        return context.retrievalAugmentor.augment(augmentationRequest);
                    }
                }, Infrastructure.getDefaultWorkerPool());
                return Multi.createFrom().completionStage(augmentationResultCF).flatMap((Function)new Function<AugmentationResult, Flow.Publisher<? extends Object>>(){

                    @Override
                    public Flow.Publisher<?> apply(AugmentationResult ar) {
                        ChatMessage augmentedUserMessage = ar.chatMessage();
                        ChatMemory memory = context.chatMemoryService.getChatMemory(memoryId);
                        UserMessage guardrailsMessage = GuardrailsSupport.executeInputGuardrails(context.guardrailService(), (UserMessage)augmentedUserMessage, methodCreateInfo, memory, ar, templateVariables);
                        List<ChatMessage> messagesToSend = this.messagesToSend(guardrailsMessage, needsMemorySeed);
                        TokenStreamMulti stream = new TokenStreamMulti(messagesToSend, effectiveToolSpecifications, finalToolExecutors, ar.contents(), context, memoryId, methodCreateInfo.isSwitchToWorkerThreadForToolExecution(), isRunningOnWorkerThread);
                        return stream.filter(event -> !isStringMulti || event instanceof ChatEvent.PartialResponseEvent).map(event -> {
                            if (isStringMulti && event instanceof ChatEvent.PartialResponseEvent) {
                                return ((ChatEvent.PartialResponseEvent)event).getChunk();
                            }
                            return event;
                        }).plug(m -> ResponseAugmenterSupport.apply(m, methodCreateInfo, new ResponseAugmenterParams((UserMessage)augmentedUserMessage, memory, ar, methodCreateInfo.getUserMessageTemplate(), templateVariables)));
                    }

                    private List<ChatMessage> messagesToSend(UserMessage augmentedUserMessage, boolean needsMemorySeed2) {
                        return context.hasChatMemory() ? AiServiceMethodImplementationSupport.createMessagesToSendForExistingMemory(systemMessage, (ChatMessage)augmentedUserMessage, context.chatMemoryService.getChatMemory(memoryId), needsMemorySeed2, context, methodCreateInfo) : AiServiceMethodImplementationSupport.createMessagesToSendForNoMemory(systemMessage, (ChatMessage)augmentedUserMessage, needsMemorySeed2, context, methodCreateInfo);
                    }
                });
            }
        }
        GuardrailService guardrailService = context.guardrailService();
        ChatMemory chatMemory = context.hasChatMemory() ? context.chatMemoryService.getChatMemory(memoryId) : null;
        userMessage = GuardrailsSupport.executeInputGuardrails(guardrailService, userMessage, methodCreateInfo, chatMemory, augmentationResult, templateVariables);
        if (context.hasChatMemory()) {
            committableChatMemory = new DefaultCommittableChatMemory(chatMemory);
            messagesToSend = AiServiceMethodImplementationSupport.createMessagesToSendForExistingMemory(systemMessage, (ChatMessage)userMessage, committableChatMemory, needsMemorySeed, context, methodCreateInfo);
        } else {
            committableChatMemory = new NoopChatMemory();
            messagesToSend = AiServiceMethodImplementationSupport.createMessagesToSendForNoMemory(systemMessage, (ChatMessage)userMessage, needsMemorySeed, context, methodCreateInfo);
        }
        if (TypeUtil.isTokenStream(returnType)) {
            committableChatMemory.commit();
            AiServiceTokenStreamParameters aiServiceTokenStreamParams = AiServiceTokenStreamParameters.builder().messages(messagesToSend).toolSpecifications(toolSpecifications).toolExecutors(toolExecutors).retrievedContents(augmentationResult != null ? augmentationResult.contents() : null).context((AiServiceContext)context).memoryId(memoryId).methodKey((Object)methodCreateInfo).toolArgumentsErrorHandler((e, c) -> {
                throw new RuntimeException(e);
            }).toolExecutionErrorHandler((e, c) -> ToolErrorHandlerResult.text((String)e.getMessage())).commonGuardrailParams(GuardrailRequestParams.builder().chatMemory((ChatMemory)committableChatMemory).augmentationResult(augmentationResult).userMessageTemplate(methodCreateInfo.getUserMessageTemplate()).variables(templateVariables).build()).build();
            return new AiServiceTokenStream(aiServiceTokenStreamParams);
        }
        AugmentationResult actualAugmentationResult = augmentationResult;
        UserMessage actualUserMessage = userMessage;
        if (isMulti) {
            committableChatMemory.commit();
            boolean hasUpstreamGuardrails = methodCreateInfo.getOutputGuardrails().hasGuardrails();
            TokenStreamMulti stream = new TokenStreamMulti(messagesToSend, toolSpecifications, toolExecutors, augmentationResult != null ? augmentationResult.contents() : null, context, memoryId, methodCreateInfo.isSwitchToWorkerThreadForToolExecution(), isRunningOnWorkerThread);
            stream = hasUpstreamGuardrails ? stream.filter(o -> o instanceof ChatEvent).map(ChatEvent.class::cast).plug(s -> GuardrailsSupport.accumulate((Multi<ChatEvent>)s, methodCreateInfo)).map((Function)new GuardrailsSupport.OutputGuardrailStreamingMapper(guardrailService, methodCreateInfo, committableChatMemory, actualAugmentationResult, templateVariables, isStringMulti)).onFailure(GuardrailsSupport::isOutputGuardrailRetry).retry().atMost((long)methodCreateInfo.getOutputGuardrails().getMaxRetriesAsSetByConfig()) : stream.filter(event -> !isStringMulti || event instanceof ChatEvent.PartialResponseEvent).map(event -> {
                if (isStringMulti && event instanceof ChatEvent.PartialResponseEvent) {
                    return ((ChatEvent.PartialResponseEvent)event).getChunk();
                }
                return event;
            });
            return stream.plug(m -> ResponseAugmenterSupport.apply(m, methodCreateInfo, new ResponseAugmenterParams(actualUserMessage, chatMemory, actualAugmentationResult, methodCreateInfo.getUserMessageTemplate(), templateVariables)));
        }
        Future<Moderation> moderationFuture = AiServiceMethodImplementationSupport.triggerModerationIfNeeded(context, methodCreateInfo, messagesToSend);
        log.debug((Object)"Attempting to obtain AI response");
        ChatRequest chatRequest = (ChatRequest)context.chatRequestTransformer.apply(AiServiceMethodImplementationSupport.createChatRequest(context, methodCreateInfo, methodArgs, messagesToSend, toolSpecifications), memoryId);
        ChatExecutor chatExecutor = ChatExecutor.builder((ChatModel)context.effectiveChatModel(methodCreateInfo, methodArgs)).chatRequest(chatRequest).build();
        ChatResponse response = chatExecutor.execute();
        log.debug((Object)"AI response obtained");
        beanManager.getEvent().select(ResponseFromLLMReceivedEvent.class, new Annotation[0]).fire((Object)new DefaultResponseFromLLMReceivedEvent(auditSourceInfo, response));
        TokenUsage tokenUsageAccumulator = response.tokenUsage();
        AiServices.verifyModerationIfNeeded(moderationFuture);
        int executionsLeft = maxSequentialToolExecutions = context.maxSequentialToolExecutions != null && context.maxSequentialToolExecutions > 0 ? context.maxSequentialToolExecutions : AiServiceMethodImplementationSupport.getMaxSequentialToolExecutions();
        while (true) {
            ToolChoice toolChoice;
            if (executionsLeft-- == 0) {
                throw Exceptions.runtime((String)"Something is wrong, exceeded %s sequential tool executions", (Object[])new Object[]{maxSequentialToolExecutions});
            }
            AiMessage aiMessage = response.aiMessage();
            committableChatMemory.add((ChatMessage)aiMessage);
            if (!aiMessage.hasToolExecutionRequests()) break;
            for (ToolExecutionRequest toolExecutionRequest : aiMessage.toolExecutionRequests()) {
                log.debugv("Attempting to execute tool {0}", (Object)toolExecutionRequest);
                ToolExecutor toolExecutor = (ToolExecutor)toolExecutors.get(toolExecutionRequest.name());
                ToolExecutionResultMessage toolExecutionResultMessage = toolExecutor == null ? context.toolService.applyToolHallucinationStrategy(toolExecutionRequest) : AiServiceMethodImplementationSupport.executeTool(auditSourceInfo, toolExecutionRequest, toolExecutor, memoryId, beanManager);
                committableChatMemory.add((ChatMessage)toolExecutionResultMessage);
            }
            log.debug((Object)"Attempting to obtain AI response");
            ChatModel effectiveChatModel = context.effectiveChatModel(methodCreateInfo, methodArgs);
            ChatRequest.Builder chatRequestBuilder = ChatRequest.builder().messages(committableChatMemory.messages());
            DefaultChatRequestParameters.Builder<?> parametersBuilder = ChatRequestParameters.builder();
            if (AiServiceMethodImplementationSupport.supportsJsonSchema(effectiveChatModel)) {
                Optional<JsonSchema> jsonSchema = methodCreateInfo.getResponseSchemaInfo().structuredOutputSchema();
                if (jsonSchema.isPresent()) {
                    parametersBuilder = AiServiceMethodImplementationSupport.constructStructuredResponseParams(toolSpecifications, jsonSchema.get());
                } else {
                    parametersBuilder.toolSpecifications(toolSpecifications);
                }
            } else {
                parametersBuilder.toolSpecifications(toolSpecifications);
            }
            if (Objects.nonNull(context.chatModel.defaultRequestParameters()) && Objects.nonNull(toolChoice = context.chatModel.defaultRequestParameters().toolChoice()) && toolChoice.equals((Object)ToolChoice.REQUIRED)) {
                parametersBuilder.toolChoice(ToolChoice.AUTO);
            }
            response = effectiveChatModel.chat(chatRequestBuilder.parameters(parametersBuilder.build()).build());
            log.debug((Object)"AI response obtained");
            beanManager.getEvent().select(ResponseFromLLMReceivedEvent.class, new Annotation[0]).fire((Object)new DefaultResponseFromLLMReceivedEvent(auditSourceInfo, response));
            tokenUsageAccumulator = TokenUsage.sum((TokenUsage)tokenUsageAccumulator, (TokenUsage)response.tokenUsage());
        }
        String userMessageTemplate = methodCreateInfo.getUserMessageTemplate();
        Object guardrailResult = GuardrailsSupport.executeOutputGuardrails(guardrailService, methodCreateInfo, response, chatExecutor, committableChatMemory, augmentationResult, templateVariables);
        committableChatMemory.commit();
        ResponseAugmenterParams responseAugmenterParam = new ResponseAugmenterParams(userMessage, committableChatMemory, augmentationResult, userMessageTemplate, templateVariables);
        if (guardrailResult != null && TypeUtil.isTypeOf(returnType, guardrailResult.getClass())) {
            return ResponseAugmenterSupport.invoke(guardrailResult, methodCreateInfo, responseAugmenterParam);
        }
        if (guardrailResult instanceof ChatResponse) {
            response = (ChatResponse)guardrailResult;
        }
        response = ChatResponse.builder().aiMessage(response.aiMessage()).metadata(response.metadata()).build();
        if (TypeUtil.isResult(returnType)) {
            Object parsedResponse = SERVICE_OUTPUT_PARSER.parse(ChatResponse.builder().aiMessage(response.aiMessage()).build(), TypeUtil.resultTypeParam((ParameterizedType)returnType));
            parsedResponse = ResponseAugmenterSupport.invoke(parsedResponse, methodCreateInfo, responseAugmenterParam);
            return Result.builder().content(parsedResponse).tokenUsage(tokenUsageAccumulator).sources(augmentationResult == null ? null : augmentationResult.contents()).finishReason(response.finishReason()).build();
        }
        return ResponseAugmenterSupport.invoke(SERVICE_OUTPUT_PARSER.parse(ChatResponse.builder().aiMessage(response.aiMessage()).build(), returnType), methodCreateInfo, responseAugmenterParam);
    }

    private static ToolExecutionResultMessage executeTool(AuditSourceInfo auditSourceInfo, ToolExecutionRequest toolExecutionRequest, ToolExecutor toolExecutor, Object memoryId, BeanManager beanManager) {
        String toolExecutionResult = toolExecutor.execute(toolExecutionRequest, memoryId);
        log.debugv("Result of {0} is '{1}'", (Object)toolExecutionRequest, (Object)toolExecutionResult);
        ToolExecutionResultMessage toolExecutionResultMessage = ToolExecutionResultMessage.from((ToolExecutionRequest)toolExecutionRequest, (String)toolExecutionResult);
        beanManager.getEvent().select(ToolExecutedEvent.class, new Annotation[0]).fire((Object)new DefaultToolExecutedEvent(auditSourceInfo, toolExecutionRequest, toolExecutionResult));
        return toolExecutionResultMessage;
    }

    private static ChatRequest createChatRequest(JsonSchema jsonSchema, List<ChatMessage> messagesToSend, ChatModel chatModel, List<ToolSpecification> toolSpecifications) {
        return ChatRequest.builder().messages(messagesToSend).parameters(AiServiceMethodImplementationSupport.constructStructuredResponseParams(toolSpecifications, jsonSchema).build()).build();
    }

    static ChatRequest createChatRequest(List<ChatMessage> messagesToSend, ChatModel chatModel, List<ToolSpecification> toolSpecifications) {
        ChatRequest.Builder chatRequest = ChatRequest.builder().messages(messagesToSend);
        if (toolSpecifications != null) {
            chatRequest.toolSpecifications(toolSpecifications);
        }
        return chatRequest.build();
    }

    static ChatRequest createChatRequest(AiServiceMethodCreateInfo methodCreateInfo, List<ChatMessage> messagesToSend, ChatModel chatModel, List<ToolSpecification> toolSpecifications) {
        Optional jsonSchema = AiServiceMethodImplementationSupport.supportsJsonSchema(chatModel) ? methodCreateInfo.getResponseSchemaInfo().structuredOutputSchema() : Optional.empty();
        return jsonSchema.isPresent() ? AiServiceMethodImplementationSupport.createChatRequest((JsonSchema)jsonSchema.get(), messagesToSend, chatModel, toolSpecifications) : AiServiceMethodImplementationSupport.createChatRequest(messagesToSend, chatModel, toolSpecifications);
    }

    static ChatRequest createChatRequest(QuarkusAiServiceContext context, AiServiceMethodCreateInfo methodCreateInfo, Object[] methodArgs, List<ChatMessage> messagesToSend, List<ToolSpecification> toolSpecifications) {
        return AiServiceMethodImplementationSupport.createChatRequest(methodCreateInfo, messagesToSend, context.effectiveChatModel(methodCreateInfo, methodArgs), toolSpecifications);
    }

    private static Object doImplementGenerateImage(AiServiceMethodCreateInfo methodCreateInfo, QuarkusAiServiceContext context, Optional<SystemMessage> systemMessage, UserMessage userMessage, Object memoryId, Type returnType, Map<String, Object> templateVariables, AuditSourceInfo auditSourceInfo) {
        BeanManager beanManager = Arc.container().beanManager();
        beanManager.getEvent().select(InitialMessagesCreatedEvent.class, new Annotation[0]).fire((Object)new DefaultInitialMessagesCreatedEvent(auditSourceInfo, systemMessage, userMessage));
        AugmentationResult augmentationResult = null;
        ChatMemory chatMemory = context.hasChatMemory() ? context.chatMemoryService.getChatMemory(memoryId) : null;
        UserMessage um = GuardrailsSupport.executeInputGuardrails(context.guardrailService(), userMessage, methodCreateInfo, chatMemory, augmentationResult, templateVariables);
        String imagePrompt = systemMessage.map(sm -> "%s\n%s".formatted(sm.text(), um.singleText())).orElseGet(() -> ((UserMessage)um).singleText());
        Response imageResponse = context.imageModel.generate(imagePrompt);
        beanManager.getEvent().select(LLMInteractionCompleteEvent.class, new Annotation[0]).fire((Object)new DefaultLLMInteractionCompleteEvent(auditSourceInfo, imageResponse.content()));
        if (TypeUtil.isImage(returnType)) {
            return imageResponse.content();
        }
        if (TypeUtil.isResultImage(returnType)) {
            return Result.builder().content((Object)imageResponse).tokenUsage(imageResponse.tokenUsage()).sources(augmentationResult == null ? null : augmentationResult.contents()).finishReason(imageResponse.finishReason()).build();
        }
        throw new IllegalStateException("Unsupported return type: " + String.valueOf(returnType));
    }

    private static boolean needsMemorySeed(QuarkusAiServiceContext context, Object memoryId) {
        if (context.chatMemorySeeder == null) {
            return false;
        }
        if (!context.hasChatMemory()) {
            return false;
        }
        ChatMemory chatMemory = context.chatMemoryService.getChatMemory(memoryId);
        return chatMemory.messages().isEmpty();
    }

    private static List<ChatMessage> createMessagesToSendForExistingMemory(Optional<SystemMessage> systemMessage, ChatMessage userMessage, ChatMemory chatMemory, boolean needsMemorySeed, QuarkusAiServiceContext context, AiServiceMethodCreateInfo methodCreateInfo) {
        if (systemMessage.isPresent()) {
            chatMemory.add((ChatMessage)systemMessage.get());
        }
        if (needsMemorySeed) {
            List<ChatMessage> seedChatMessages = context.chatMemorySeeder.seed(new ChatMemorySeeder.Context(methodCreateInfo.getMethodName()));
            for (ChatMessage seedChatMessage : seedChatMessages) {
                chatMemory.add(seedChatMessage);
            }
        }
        chatMemory.add(userMessage);
        return chatMemory.messages();
    }

    private static List<ChatMessage> createMessagesToSendForNoMemory(Optional<SystemMessage> systemMessage, ChatMessage userMessage, boolean needsMemorySeed, QuarkusAiServiceContext context, AiServiceMethodCreateInfo methodCreateInfo) {
        ArrayList<ChatMessage> result = new ArrayList<ChatMessage>();
        if (systemMessage.isPresent()) {
            result.add((ChatMessage)systemMessage.get());
        }
        if (needsMemorySeed) {
            result.addAll(context.chatMemorySeeder.seed(new ChatMemorySeeder.Context(methodCreateInfo.getMethodName())));
        }
        result.add(userMessage);
        return result;
    }

    private static DefaultChatRequestParameters.Builder<?> constructStructuredResponseParams(List<ToolSpecification> toolSpecifications, JsonSchema jsonSchema) {
        return ChatRequestParameters.builder().toolSpecifications(toolSpecifications).responseFormat(ResponseFormat.builder().type(ResponseFormatType.JSON).jsonSchema(jsonSchema).build());
    }

    private static boolean supportsJsonSchema(ChatModel chatModel) {
        return chatModel != null && chatModel.supportedCapabilities().contains(Capability.RESPONSE_FORMAT_JSON_SCHEMA);
    }

    private static boolean supportsJsonSchema(QuarkusAiServiceContext context, AiServiceMethodCreateInfo methodCreateInfo, Object[] methodArgs) {
        return AiServiceMethodImplementationSupport.supportsJsonSchema(context.effectiveChatModel(methodCreateInfo, methodArgs));
    }

    private static Future<Moderation> triggerModerationIfNeeded(final QuarkusAiServiceContext context, AiServiceMethodCreateInfo createInfo, final List<ChatMessage> messages) {
        Future<Moderation> moderationFuture = null;
        if (createInfo.isRequiresModeration()) {
            log.debug((Object)"Moderation is required and it will be executed in the background");
            ExecutorService defaultExecutor = (ExecutorService)Infrastructure.getDefaultExecutor();
            moderationFuture = defaultExecutor.submit(new Callable<Moderation>(){

                @Override
                public Moderation call() {
                    List messagesToModerate = AiServices.removeToolMessages((List)messages);
                    log.debug((Object)"Attempting to moderate messages");
                    Moderation result = (Moderation)context.moderationModel.moderate(messagesToModerate).content();
                    log.debug((Object)"Moderation completed");
                    return result;
                }
            });
        }
        return moderationFuture;
    }

    private static Optional<SystemMessage> prepareSystemMessage(AiServiceMethodCreateInfo createInfo, Object[] methodArgs, QuarkusAiServiceContext context, Object memoryId) {
        List previousChatMessages;
        List list = previousChatMessages = context.hasChatMemory() ? context.chatMemoryService.getOrCreateChatMemory(memoryId).messages() : Collections.emptyList();
        if (createInfo.getSystemMessageInfo().isEmpty()) {
            return ((Optional)context.systemMessageProvider.apply(memoryId)).map(SystemMessage::new);
        }
        AiServiceMethodCreateInfo.TemplateInfo systemMessageInfo = createInfo.getSystemMessageInfo().get();
        HashMap<String, Object> templateParams = new HashMap<String, Object>();
        Map<String, Integer> nameToParamPosition = systemMessageInfo.nameToParamPosition();
        for (Map.Entry<String, Integer> entry : nameToParamPosition.entrySet()) {
            if (entry.getKey() == null) continue;
            templateParams.put(entry.getKey(), methodArgs[entry.getValue()]);
        }
        templateParams.put(ResponseSchemaUtil.templateParam(), createInfo.getResponseSchemaInfo().outputFormatInstructions());
        templateParams.put("chat_memory", previousChatMessages);
        Optional<String> maybeText = systemMessageInfo.text();
        if (maybeText.isPresent()) {
            return Optional.of(PromptTemplate.from((String)maybeText.get()).apply(templateParams).toSystemMessage());
        }
        return Optional.empty();
    }

    private static UserMessage prepareUserMessage(AiServiceContext context, AiServiceMethodCreateInfo createInfo, Object[] methodArgs, boolean supportsJsonSchema) {
        Image i;
        URL u;
        URI u2;
        String s;
        AiServiceMethodCreateInfo.UserMessageInfo userMessageInfo = createInfo.getUserMessageInfo();
        String userName = null;
        ImageContent imageContent = null;
        AudioContent audioContent = null;
        PdfFileContent pdfFileContent = null;
        if (userMessageInfo.userNameParamPosition().isPresent()) {
            userName = methodArgs[userMessageInfo.userNameParamPosition().get()].toString();
        }
        if (userMessageInfo.imageParamPosition().isPresent()) {
            Object imageParamValue = methodArgs[userMessageInfo.imageParamPosition().get()];
            if (imageParamValue instanceof String) {
                s = (String)imageParamValue;
                imageContent = ImageContent.from((String)s);
            } else if (imageParamValue instanceof URI) {
                u2 = (URI)imageParamValue;
                imageContent = ImageContent.from((URI)u2);
            } else if (imageParamValue instanceof URL) {
                u = (URL)imageParamValue;
                try {
                    imageContent = ImageContent.from((URI)u.toURI());
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            } else if (imageParamValue instanceof Image) {
                i = (Image)imageParamValue;
                imageContent = ImageContent.from((Image)i);
            } else {
                throw new IllegalStateException("Unsupported parameter type '" + String.valueOf(imageParamValue.getClass()) + "' annotated with @ImageUrl. Offending AiService is '" + createInfo.getInterfaceName() + "#" + createInfo.getMethodName());
            }
        }
        if (userMessageInfo.audioParamPosition().isPresent()) {
            Object audioParamValue = methodArgs[userMessageInfo.audioParamPosition().get()];
            if (audioParamValue instanceof String) {
                s = (String)audioParamValue;
                audioContent = AudioContent.from((String)s);
            } else if (audioParamValue instanceof URI) {
                u2 = (URI)audioParamValue;
                audioContent = AudioContent.from((URI)u2);
            } else if (audioParamValue instanceof URL) {
                u = (URL)audioParamValue;
                try {
                    audioContent = AudioContent.from((URI)u.toURI());
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            } else if (audioParamValue instanceof Audio) {
                Audio a = (Audio)audioParamValue;
                audioContent = AudioContent.from((Audio)a);
            } else {
                throw new IllegalStateException("Unsupported parameter type '" + String.valueOf(audioParamValue.getClass()) + "' annotated with @AudioUrl. Offending AiService is '" + createInfo.getInterfaceName() + "#" + createInfo.getMethodName());
            }
        }
        if (userMessageInfo.pdfParamPosition().isPresent()) {
            Object pdfParamValue = methodArgs[userMessageInfo.pdfParamPosition().get()];
            if (pdfParamValue instanceof String) {
                s = (String)pdfParamValue;
                pdfFileContent = PdfFileContent.from((String)s);
            } else if (pdfParamValue instanceof URI) {
                u2 = (URI)pdfParamValue;
                pdfFileContent = PdfFileContent.from((URI)u2);
            } else if (pdfParamValue instanceof URL) {
                u = (URL)pdfParamValue;
                try {
                    pdfFileContent = PdfFileContent.from((URI)u.toURI());
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            } else if (pdfParamValue instanceof PdfFile) {
                i = (PdfFile)pdfParamValue;
                pdfFileContent = PdfFileContent.from((PdfFile)i);
            } else {
                throw new IllegalStateException("Unsupported parameter type '" + String.valueOf(pdfParamValue.getClass()) + "' annotated with @PdfUrl. Offending AiService is '" + createInfo.getInterfaceName() + "#" + createInfo.getMethodName());
            }
        }
        if (userMessageInfo.template().isPresent()) {
            boolean hasResponseSchema;
            AiServiceMethodCreateInfo.TemplateInfo templateInfo = userMessageInfo.template().get();
            Map<String, Object> templateVariables = AiServiceMethodImplementationSupport.getTemplateVariables(methodArgs, userMessageInfo);
            String templateText = templateInfo.text().isPresent() ? templateInfo.text().get() : (String)methodArgs[templateInfo.methodParamPosition().get()];
            boolean bl = hasResponseSchema = createInfo.getResponseSchemaInfo().isInUserMessage().orElse(false) != false || ResponseSchemaUtil.hasResponseSchema(templateText);
            if (hasResponseSchema && !createInfo.getResponseSchemaInfo().enabled()) {
                throw new RuntimeException("The %s placeholder cannot be used if the property quarkus.langchain4j.response-schema is set to false. Found in: %s".formatted(ResponseSchemaUtil.placeholder(), createInfo.getInterfaceName()));
            }
            if (createInfo.getResponseSchemaInfo().enabled()) {
                if (!(createInfo.getResponseSchemaInfo().isInSystemMessage() || hasResponseSchema || supportsJsonSchema)) {
                    templateText = templateText.concat(ResponseSchemaUtil.placeholder());
                }
                templateVariables.put(ResponseSchemaUtil.templateParam(), createInfo.getResponseSchemaInfo().outputFormatInstructions());
            }
            Prompt prompt = PromptTemplate.from((String)templateText).apply(templateVariables);
            return AiServiceMethodImplementationSupport.createUserMessage(userName, imageContent, audioContent, pdfFileContent, prompt.text());
        }
        if (userMessageInfo.paramPosition().isPresent()) {
            Integer paramIndex = userMessageInfo.paramPosition().get();
            Object argValue = methodArgs[paramIndex];
            if (argValue == null) {
                throw new IllegalArgumentException("Unable to construct UserMessage for class '" + context.aiServiceClass.getName() + "' because parameter with index " + paramIndex + " is null");
            }
            String text = AiServiceMethodImplementationSupport.toString(argValue);
            return AiServiceMethodImplementationSupport.createUserMessage(userName, imageContent, audioContent, pdfFileContent, text.concat(supportsJsonSchema || !createInfo.getResponseSchemaInfo().enabled() ? "" : createInfo.getResponseSchemaInfo().outputFormatInstructions()));
        }
        return EmptyUserMessage.INSTANCE;
    }

    private static Map<String, Object> getTemplateVariables(Object[] methodArgs, AiServiceMethodCreateInfo.UserMessageInfo userMessageInfo) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (userMessageInfo.template().isPresent()) {
            AiServiceMethodCreateInfo.TemplateInfo templateInfo = userMessageInfo.template().get();
            Map<String, Integer> nameToParamPosition = templateInfo.nameToParamPosition();
            for (Map.Entry<String, Integer> entry : nameToParamPosition.entrySet()) {
                Object value = AiServiceMethodImplementationSupport.transformTemplateParamValue(methodArgs[entry.getValue()]);
                if (entry.getKey() == null) continue;
                variables.put(entry.getKey(), value);
            }
        }
        return variables;
    }

    private static UserMessage createUserMessage(String name, ImageContent imageContent, AudioContent audioContent, PdfFileContent pdfFileContent, String text) {
        ArrayList<Object> contents = new ArrayList<Object>();
        contents.add(TextContent.from((String)text));
        if (imageContent != null) {
            contents.add(imageContent);
        }
        if (audioContent != null) {
            contents.add(audioContent);
        }
        if (pdfFileContent != null) {
            contents.add(pdfFileContent);
        }
        if (name == null) {
            return UserMessage.userMessage(contents);
        }
        return UserMessage.userMessage((String)name, contents);
    }

    private static Object transformTemplateParamValue(Object value) {
        if (value == null) {
            return "";
        }
        if (value.getClass().isArray()) {
            return Arrays.toString((Object[])value);
        }
        return value;
    }

    private static Object memoryId(AiServiceMethodCreateInfo createInfo, Object[] methodArgs, boolean hasChatMemoryProvider) {
        if (createInfo.getMemoryIdParamPosition().isPresent()) {
            return methodArgs[createInfo.getMemoryIdParamPosition().get()];
        }
        if (hasChatMemoryProvider) {
            for (DefaultMemoryIdProvider provider : DEFAULT_MEMORY_ID_PROVIDERS) {
                Object memoryId = provider.getMemoryId();
                if (memoryId == null) continue;
                String perServiceSuffix = "#" + createInfo.getInterfaceName() + "." + createInfo.getMethodName();
                return String.valueOf(memoryId) + perServiceSuffix;
            }
        }
        return "default";
    }

    private static String toString(Object arg) {
        if (arg.getClass().isArray()) {
            return AiServiceMethodImplementationSupport.arrayToString(arg);
        }
        if (arg.getClass().isAnnotationPresent(StructuredPrompt.class)) {
            return StructuredPromptProcessor.toPrompt((Object)arg).text();
        }
        return arg.toString();
    }

    private static String arrayToString(Object arg) {
        StringBuilder sb = new StringBuilder("[");
        int length = Array.getLength(arg);
        for (int i = 0; i < length; ++i) {
            sb.append(AiServiceMethodImplementationSupport.toString(Array.get(arg, i)));
            if (i >= length - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    private static int getMaxSequentialToolExecutions() {
        return ConfigProvider.getConfig().getOptionalValue("quarkus.langchain4j.ai-service.max-tool-executions", Integer.class).orElse(10);
    }

    static {
        SERVICE_OUTPUT_PARSER = new QuarkusServiceOutputParser();
        Collection defaultMemoryIdProviders = ServiceHelper.loadFactories(DefaultMemoryIdProvider.class);
        if (defaultMemoryIdProviders.isEmpty()) {
            DEFAULT_MEMORY_ID_PROVIDERS = Collections.emptyList();
        } else {
            DEFAULT_MEMORY_ID_PROVIDERS = new ArrayList<DefaultMemoryIdProvider>(defaultMemoryIdProviders);
            DEFAULT_MEMORY_ID_PROVIDERS.sort(new Comparator<DefaultMemoryIdProvider>(){

                @Override
                public int compare(DefaultMemoryIdProvider o1, DefaultMemoryIdProvider o2) {
                    return Integer.compare(o1.priority(), o2.priority());
                }
            });
        }
    }

    public static class Input {
        final QuarkusAiServiceContext context;
        final AiServiceMethodCreateInfo createInfo;
        final Object[] methodArgs;

        public Input(QuarkusAiServiceContext context, AiServiceMethodCreateInfo createInfo, Object[] methodArgs) {
            this.context = context;
            this.createInfo = createInfo;
            this.methodArgs = methodArgs;
        }
    }

    public static interface Wrapper {
        public Object wrap(Input var1, Function<Input, Object> var2);
    }
}

