/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.guardrails;

import dev.langchain4j.guardrail.Guardrail;
import jakarta.enterprise.util.AnnotationLiteral;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class ClassProvidingAnnotationLiteral<A extends Annotation, G extends Guardrail>
extends AnnotationLiteral<A> {
    private final List<String> classNames = new ArrayList<String>();
    private volatile transient List<Class<G>> guardrailClasses;

    protected ClassProvidingAnnotationLiteral(List<String> classNames) {
        if (classNames != null) {
            this.classNames.addAll(classNames);
        }
    }

    public List<String> getClassNames() {
        return this.classNames;
    }

    public void setClassNames(List<String> classNames) {
        this.classNames.clear();
        if (classNames != null) {
            this.classNames.addAll(classNames);
        }
    }

    public Class<G>[] value() {
        return this.getClasses();
    }

    private boolean neesCacheInitialization() {
        return this.guardrailClasses == null || this.guardrailClasses.size() != this.classNames.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkClassCache() {
        if (this.neesCacheInitialization()) {
            ClassProvidingAnnotationLiteral classProvidingAnnotationLiteral = this;
            synchronized (classProvidingAnnotationLiteral) {
                if (this.neesCacheInitialization()) {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    this.guardrailClasses = this.classNames.stream().map(className -> {
                        try {
                            return Class.forName(className, false, classLoader);
                        }
                        catch (ClassNotFoundException e) {
                            throw new RuntimeException(e);
                        }
                    }).toList();
                }
            }
        }
    }

    protected final Class<G>[] getClasses() {
        this.checkClassCache();
        return (Class[])this.guardrailClasses.toArray(Class[]::new);
    }

    public boolean hasGuardrails() {
        this.checkClassCache();
        return !this.guardrailClasses.isEmpty();
    }
}

