/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j;

import dev.langchain4j.spi.ServiceHelper;
import dev.langchain4j.spi.prompt.PromptTemplateFactory;
import io.quarkiverse.langchain4j.spi.PromptTemplateFactoryContentFilterProvider;
import io.quarkus.arc.Arc;
import io.quarkus.arc.impl.LazyValue;
import io.quarkus.qute.Engine;
import io.quarkus.qute.ParserHelper;
import io.quarkus.qute.ParserHook;
import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateInstance;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;

public class QuarkusPromptTemplateFactory
implements PromptTemplateFactory {
    private static final AtomicReference<LazyValue<Engine>> engineLazyValue = new AtomicReference();

    public QuarkusPromptTemplateFactory() {
        engineLazyValue.set((LazyValue<Engine>)new LazyValue((Supplier)new Supplier<Engine>(){

            @Override
            public Engine get() {
                return ((Engine)Arc.container().instance(Engine.class, new Annotation[0]).get()).newBuilder().addParserHook((ParserHook)new MustacheTemplateVariableStyleParserHook()).build();
            }
        }));
    }

    public static void clear() {
        LazyValue<Engine> lazyValue = engineLazyValue.get();
        if (lazyValue != null) {
            lazyValue.clear();
        }
    }

    public PromptTemplateFactory.Template create(PromptTemplateFactory.Input input) {
        return new QuteTemplate(((Engine)engineLazyValue.get().get()).parse(input.getTemplate()));
    }

    private static class QuteTemplate
    implements PromptTemplateFactory.Template {
        private final Template template;

        private QuteTemplate(Template template) {
            this.template = template;
        }

        public String render(Map<String, Object> vars) {
            TemplateInstance templateInstance = this.template.instance();
            for (Map.Entry<String, Object> entry : vars.entrySet()) {
                templateInstance = templateInstance.data(entry.getKey(), entry.getValue());
            }
            return templateInstance.render();
        }
    }

    public static class MustacheTemplateVariableStyleParserHook
    implements ParserHook {
        private static final List<Function<String, String>> customContentFilters;

        public void beforeParsing(ParserHelper parserHelper) {
            parserHelper.addContentFilter((Function)new Function<String, String>(){

                @Override
                public String apply(String contents) {
                    return contents.replace("{{", "{").replace("}}", "}");
                }
            });
            for (Function<String, String> customContentFilter : customContentFilters) {
                parserHelper.addContentFilter(customContentFilter);
            }
        }

        static {
            ArrayList<Function> ccf = new ArrayList<Function>();
            Collection promptTemplateFactoryContentFilterProviders = ServiceHelper.loadFactories(PromptTemplateFactoryContentFilterProvider.class);
            for (PromptTemplateFactoryContentFilterProvider p : promptTemplateFactoryContentFilterProviders) {
                ccf.add(p.getContentFilter());
            }
            customContentFilters = Collections.unmodifiableList(ccf);
        }
    }
}

