/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j;

import dev.langchain4j.service.guardrail.InputGuardrails;
import dev.langchain4j.service.guardrail.OutputGuardrails;
import dev.langchain4j.spi.classloading.ClassMetadataProviderFactory;
import io.quarkiverse.langchain4j.runtime.AiServicesRecorder;
import io.quarkiverse.langchain4j.runtime.aiservice.AiServiceClassCreateInfo;
import io.quarkiverse.langchain4j.runtime.aiservice.AiServiceMethodCreateInfo;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

public class QuarkusClassMetadataProviderFactory
implements ClassMetadataProviderFactory<AiServiceMethodCreateInfo> {
    public <T extends Annotation> Optional<T> getAnnotation(AiServiceMethodCreateInfo method, Class<T> annotationClass) {
        return GuardrailType.fromAnnotationClass(annotationClass).getAnnotation(method);
    }

    public <T extends Annotation> Optional<T> getAnnotation(Class<?> clazz, Class<T> annotationClass) {
        return GuardrailType.fromAnnotationClass(annotationClass).getAnnotation(clazz);
    }

    public Iterable<AiServiceMethodCreateInfo> getNonStaticMethodsOnClass(Class<?> aiServiceClass) {
        return QuarkusClassMetadataProviderFactory.getClassMetadata(aiServiceClass).map(AiServiceClassCreateInfo::methodMap).map(Map::values).orElseGet(Collections::emptyList);
    }

    private static Optional<AiServiceClassCreateInfo> getClassMetadata(Class<?> aiServiceClass) {
        return Optional.ofNullable(AiServicesRecorder.getMetadata().get(aiServiceClass.getName()));
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum GuardrailType {
        INPUT(InputGuardrails.class){

            @Override
            protected <T extends Annotation> Optional<T> getAnnotation(AiServiceMethodCreateInfo method) {
                return Optional.ofNullable(method.getInputGuardrails());
            }

            @Override
            protected <T extends Annotation> Optional<T> getAnnotation(Class<?> clazz) {
                return QuarkusClassMetadataProviderFactory.getClassMetadata(clazz).map(classCreateInfo -> classCreateInfo.inputGuardrails());
            }
        }
        ,
        OUTPUT(OutputGuardrails.class){

            @Override
            protected <T extends Annotation> Optional<T> getAnnotation(AiServiceMethodCreateInfo method) {
                return Optional.ofNullable(method.getOutputGuardrails());
            }

            @Override
            protected <T extends Annotation> Optional<T> getAnnotation(Class<?> clazz) {
                return QuarkusClassMetadataProviderFactory.getClassMetadata(clazz).map(classCreateInfo -> classCreateInfo.outputGuardrails());
            }
        };

        private final Class<? extends Annotation> annotationClass;

        private GuardrailType(Class<? extends Annotation> annotationClass) {
            this.annotationClass = annotationClass;
        }

        protected abstract <T extends Annotation> Optional<T> getAnnotation(AiServiceMethodCreateInfo var1);

        protected abstract <T extends Annotation> Optional<T> getAnnotation(Class<?> var1);

        public static GuardrailType fromAnnotationClass(Class<? extends Annotation> annotationClass) {
            return Arrays.stream(GuardrailType.values()).filter(type -> type.annotationClass.equals(annotationClass)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unsupported guardrail annotation: %s".formatted(annotationClass.getName())));
        }
    }
}

