/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.runtime.devui;

import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.store.embedding.EmbeddingMatch;
import dev.langchain4j.store.embedding.EmbeddingStore;
import io.quarkus.arc.All;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import jakarta.enterprise.inject.Default;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;

public class EmbeddingStoreJsonRPCService {
    final EmbeddingStore<TextSegment> embeddingStore;
    final EmbeddingModel embeddingModel;
    private static Logger log = Logger.getLogger(EmbeddingStoreJsonRPCService.class);
    private static final Pattern COMMA_OR_NEWLINE = Pattern.compile(",|\\r?\\n");

    public EmbeddingStoreJsonRPCService(@All List<EmbeddingStore<TextSegment>> embeddingStores) {
        List embeddingModels = Arc.container().listAll(EmbeddingModel.class, new Annotation[0]);
        if (embeddingModels.isEmpty()) {
            this.embeddingModel = null;
            log.warn((Object)"EmbeddingStoreJsonRPCService is unable to find any embedding model in CDI, the embedding store Dev UI page will not work");
        } else if (embeddingModels.size() > 1) {
            Default.Literal DEFAULT = new Default.Literal();
            EmbeddingModel chosenModel = null;
            for (InstanceHandle candidate : embeddingModels) {
                if (!candidate.getBean().getQualifiers().contains(DEFAULT)) continue;
                chosenModel = (EmbeddingModel)candidate.get();
                break;
            }
            this.embeddingModel = chosenModel == null ? (EmbeddingModel)((InstanceHandle)embeddingModels.get(0)).get() : chosenModel;
            log.warn((Object)("EmbeddingStoreJsonRPCService found multiple embedding models in CDI, using the first one: " + this.embeddingModel.getClass().getName()));
        } else {
            this.embeddingModel = (EmbeddingModel)((InstanceHandle)embeddingModels.get(0)).get();
        }
        if (embeddingStores.isEmpty()) {
            this.embeddingStore = null;
            log.warn((Object)"EmbeddingStoreJsonRPCService is unable to find any embedding store in CDI, the embedding store Dev UI page will not work");
        } else {
            this.embeddingStore = embeddingStores.get(0);
            if (embeddingStores.size() > 1) {
                log.warn((Object)("EmbeddingStoreJsonRPCService found multiple embedding stores in CDI, using the first one: " + this.embeddingStore.getClass().getName()));
            }
        }
    }

    public String add(String id, String text, String metadata) {
        this.verifyEmbeddingModelAndStore();
        if (id == null || id.isEmpty()) {
            return this.embeddingStore.add((Embedding)this.embeddingModel.embed(text).content(), (Object)TextSegment.from((String)text, (Metadata)this.parseMetadata(metadata)));
        }
        this.embeddingStore.add(id, (Embedding)this.embeddingModel.embed(TextSegment.from((String)text, (Metadata)this.parseMetadata(metadata))).content());
        return id;
    }

    private Metadata parseMetadata(String metadata) {
        Metadata metadataObject = new Metadata();
        for (String metadataField : COMMA_OR_NEWLINE.split(metadata)) {
            String[] keyValue = metadataField.split("=");
            if (keyValue.length != 2) continue;
            metadataObject.add(keyValue[0].trim(), keyValue[1].trim());
        }
        return metadataObject;
    }

    public JsonArray findRelevant(String text, String limit) {
        this.verifyEmbeddingModelAndStore();
        int limitInt = Integer.parseInt(limit);
        JsonArray result = new JsonArray();
        for (EmbeddingMatch match : this.embeddingStore.findRelevant((Embedding)this.embeddingModel.embed(text).content(), limitInt)) {
            JsonObject matchJson = new JsonObject();
            matchJson.put("embeddingId", (Object)match.embeddingId());
            matchJson.put("score", (Object)match.score());
            matchJson.put("embedded", match.embedded() != null ? ((TextSegment)match.embedded()).text() : null);
            JsonArray metadata = new JsonArray();
            if (match.embedded() != null && ((TextSegment)match.embedded()).metadata() != null) {
                for (String key : ((TextSegment)match.embedded()).metadata().asMap().keySet()) {
                    JsonObject metadataEntry = new JsonObject();
                    metadataEntry.put("key", (Object)key);
                    metadataEntry.put("value", (Object)((TextSegment)match.embedded()).metadata().get(key));
                    metadata.add((Object)metadataEntry);
                }
            }
            matchJson.put("metadata", (Object)metadata);
            result.add((Object)matchJson);
        }
        return result;
    }

    private void verifyEmbeddingModelAndStore() {
        if (this.embeddingModel == null) {
            throw new RuntimeException("No embedding model found in CDI. Please add an embedding model to your application.");
        }
        if (this.embeddingStore == null) {
            throw new RuntimeException("No embedding store found in CDI. Please add an embedding store to your application.");
        }
    }
}

