/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.runtime.aiservice;

import dev.langchain4j.memory.ChatMemory;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.image.ImageModel;
import dev.langchain4j.service.AiServiceContext;
import io.quarkiverse.langchain4j.ModelName;
import io.quarkiverse.langchain4j.runtime.aiservice.AiServiceMethodCreateInfo;
import io.quarkiverse.langchain4j.runtime.aiservice.ChatMemorySeeder;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;

public class QuarkusAiServiceContext
extends AiServiceContext {
    public ChatMemorySeeder chatMemorySeeder;
    public ImageModel imageModel;

    public QuarkusAiServiceContext() {
        super(null);
    }

    public QuarkusAiServiceContext(Class<?> aiServiceClass) {
        super(aiServiceClass);
    }

    public void close() {
        this.clearChatMemory();
    }

    private void clearChatMemory() {
        if (this.chatMemories != null) {
            this.chatMemories.forEach(new BiConsumer<Object, ChatMemory>(){

                @Override
                public void accept(Object memoryId, ChatMemory chatMemory) {
                    chatMemory.clear();
                }
            });
            this.chatMemories = null;
        }
    }

    public void removeChatMemoryIds(Object ... ids) {
        if (this.chatMemories == null) {
            return;
        }
        for (Object id : ids) {
            ChatMemory chatMemory = (ChatMemory)this.chatMemories.remove(id);
            if (chatMemory == null) continue;
            chatMemory.clear();
        }
    }

    public ChatLanguageModel effectiveChatModel(AiServiceMethodCreateInfo createInfo, Object[] methodArgs) {
        if (createInfo.getOverrideChatModelParamPosition().isPresent()) {
            return this.effectiveChatModel((String)methodArgs[createInfo.getOverrideChatModelParamPosition().get()]);
        }
        return this.chatModel;
    }

    private ChatLanguageModel effectiveChatModel(String modelName) {
        if (modelName == null) {
            return this.chatModel;
        }
        InstanceHandle instance = Arc.container().instance(ChatLanguageModel.class, new Annotation[]{ModelName.Literal.of(modelName)});
        if (instance.isAvailable()) {
            return (ChatLanguageModel)instance.get();
        }
        HashSet<String> availableNames = new HashSet<String>();
        block0: for (Instance.Handle handle : Arc.container().select(ChatLanguageModel.class, new Annotation[]{Any.Literal.INSTANCE}).handles()) {
            Set qualifiers = handle.getBean().getQualifiers();
            for (Annotation qualifier : qualifiers) {
                if (!qualifier.annotationType().equals(ModelName.class)) continue;
                availableNames.add(((ModelName)qualifier).value());
                continue block0;
            }
        }
        throw new IllegalStateException("No configured ChatLanguageModel named '" + modelName + "' was found. The application has made available the following named ChatLanguageModel instances: " + String.join((CharSequence)", ", availableNames));
    }
}

