/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.deployment.items;

import io.quarkiverse.langchain4j.guardrails.ClassProvidingAnnotationLiteral;
import io.quarkiverse.langchain4j.guardrails.InputGuardrailsLiteral;
import io.quarkiverse.langchain4j.guardrails.OutputGuardrailAccumulator;
import io.quarkiverse.langchain4j.guardrails.OutputGuardrailsLiteral;
import io.quarkiverse.langchain4j.response.ResponseAugmenter;
import io.quarkiverse.langchain4j.runtime.aiservice.AiServiceMethodCreateInfo;
import io.quarkus.builder.item.MultiBuildItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public final class AiServicesMethodBuildItem
extends MultiBuildItem {
    private final MethodInfo methodInfo;
    private final InputGuardrailsLiteral inputGuardrails;
    private final OutputGuardrailsLiteral outputGuardrails;
    private final AiServiceMethodCreateInfo methodCreateInfo;
    private final String responseAugmenter;

    public AiServicesMethodBuildItem(MethodInfo methodInfo, InputGuardrailsLiteral inputGuardrails, OutputGuardrailsLiteral outputGuardrails, String responseAugmenter, AiServiceMethodCreateInfo methodCreateInfo) {
        this.methodInfo = methodInfo;
        this.inputGuardrails = inputGuardrails;
        this.outputGuardrails = outputGuardrails;
        this.responseAugmenter = responseAugmenter;
        this.methodCreateInfo = methodCreateInfo;
    }

    public Optional<InputGuardrailsLiteral> getInputGuardrails() {
        return Optional.ofNullable(this.inputGuardrails);
    }

    public Optional<OutputGuardrailsLiteral> getOutputGuardrails() {
        return Optional.ofNullable(this.outputGuardrails);
    }

    public boolean hasInputGuardrails() {
        return this.getInputGuardrails().map(ClassProvidingAnnotationLiteral::hasGuardrails).orElse(false);
    }

    public boolean hasOutputGuardrails() {
        return this.getOutputGuardrails().map(ClassProvidingAnnotationLiteral::hasGuardrails).orElse(false);
    }

    public MethodInfo getMethodInfo() {
        return this.methodInfo;
    }

    public AiServiceMethodCreateInfo getMethodCreateInfo() {
        return this.methodCreateInfo;
    }

    public String getResponseAugmenter() {
        return this.responseAugmenter;
    }

    public static List<String> gatherGuardrails(MethodInfo methodInfo, DotName annotation) {
        ArrayList<String> guardrails = new ArrayList<String>();
        AnnotationInstance instance = methodInfo.annotation(annotation);
        if (instance == null) {
            instance = methodInfo.declaringClass().declaredAnnotation(annotation);
        }
        if (instance != null) {
            Type[] array;
            for (Type type : array = instance.value().asClassArray()) {
                if (guardrails.contains(type.name().toString())) continue;
                guardrails.add(type.name().toString());
            }
        }
        return guardrails;
    }

    public static String gatherAccumulator(MethodInfo methodInfo) {
        DotName annotation = DotName.createSimple(OutputGuardrailAccumulator.class);
        AnnotationInstance instance = methodInfo.annotation(annotation);
        if (instance == null) {
            instance = methodInfo.declaringClass().declaredAnnotation(annotation);
        }
        if (instance != null) {
            return instance.value().asClass().name().toString();
        }
        return null;
    }

    public static String gatherResponseAugmenter(MethodInfo methodInfo) {
        DotName annotation = DotName.createSimple(ResponseAugmenter.class);
        AnnotationInstance instance = methodInfo.annotation(annotation);
        if (instance == null) {
            instance = methodInfo.declaringClass().declaredAnnotation(annotation);
        }
        if (instance != null) {
            return instance.value().asClass().name().toString();
        }
        return null;
    }
}

