/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.deployment.devui;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.command.StartContainerCmd;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.exception.NotModifiedException;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.DeviceRequest;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Volume;
import io.quarkiverse.langchain4j.runtime.devui.OpenWebUIJsonRPCService;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.devui.spi.JsonRPCProvidersBuildItem;
import io.quarkus.devui.spi.buildtime.BuildTimeActionBuildItem;
import java.io.IOException;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.testcontainers.DockerClientFactory;

public final class OpenWebUIDevUIProcessor {
    private static final String CONTAINER_NAME_PREFIX = "quarkus-open-webui-";

    @BuildStep
    JsonRPCProvidersBuildItem jsonRpcProviders() {
        return new JsonRPCProvidersBuildItem(OpenWebUIJsonRPCService.class);
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    void registerOpenWebUiCard(BuildProducer<BuildTimeActionBuildItem> buildTimeActionProducer, CuratedApplicationShutdownBuildItem closeBuildItem) {
        closeBuildItem.addCloseTask(() -> this.stopOpenWebUI(), true);
        ArrayList<BuildTimeActionBuildItem> buildTimeActions = new ArrayList<BuildTimeActionBuildItem>();
        BuildTimeActionBuildItem inspectOpenWebUIContainer = new BuildTimeActionBuildItem();
        inspectOpenWebUIContainer.addAction("inspectOpenWebUIContainer", params -> this.toMap(this.inspectOpenWebUIContainer()));
        buildTimeActions.add(inspectOpenWebUIContainer);
        DockerClient lazyClient = DockerClientFactory.lazyClient();
        BuildTimeActionBuildItem startOpenWebUI = new BuildTimeActionBuildItem();
        startOpenWebUI.addAction("startOpenWebUI", params -> {
            try {
                String image = (String)params.get("image");
                boolean requestGpu = Boolean.valueOf((String)params.get("requestGpu"));
                ObjectMapper objectMapper = new ObjectMapper();
                Map portBindings = (Map)objectMapper.readValue((String)params.get("portBindings"), Map.class);
                Map envVars = (Map)objectMapper.readValue((String)params.get("envVars"), Map.class);
                Map volumes = (Map)objectMapper.readValue((String)params.get("volumes"), Map.class);
                if (!this.isOpenWebUIRunning()) {
                    ArrayList<PortBinding> allPortBindings = new ArrayList<PortBinding>();
                    ArrayList<CallSite> allEnvVars = new ArrayList<CallSite>();
                    ArrayList<Bind> allBinds = new ArrayList<Bind>();
                    ArrayList<Volume> allVolumes = new ArrayList<Volume>();
                    ArrayList<DeviceRequest> allDeviceRequests = new ArrayList<DeviceRequest>();
                    try {
                        List images = (List)DockerClientFactory.lazyClient().listImagesCmd().exec();
                        if (images.stream().filter(i -> i.getRepoTags() != null).noneMatch(i -> Arrays.asList(i.getRepoTags()).contains(image))) {
                            DockerClientFactory.lazyClient().pullImageCmd(image).start().awaitCompletion();
                        }
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    for (Map.Entry e : portBindings.entrySet()) {
                        allPortBindings.add(PortBinding.parse((String)(String.valueOf(e.getKey()) + ":" + String.valueOf(e.getValue()))));
                    }
                    for (Map.Entry e : envVars.entrySet()) {
                        allEnvVars.add((CallSite)((Object)((String)e.getKey() + "=" + (String)e.getValue())));
                    }
                    for (Map.Entry e : volumes.entrySet()) {
                        String path = (String)e.getKey();
                        Volume volume = new Volume((String)e.getValue());
                        allBinds.add(new Bind(path, volume));
                        allVolumes.add(volume);
                        try {
                            DockerClientFactory.lazyClient().inspectVolumeCmd(path).exec();
                        }
                        catch (NotFoundException nfe) {
                            DockerClientFactory.lazyClient().createVolumeCmd().withName(path).exec();
                        }
                    }
                    if (requestGpu) {
                        DeviceRequest gpu = new DeviceRequest().withCount(Integer.valueOf(-1)).withCapabilities(List.of(List.of("gpu")));
                        allDeviceRequests.add(gpu);
                    }
                    HostConfig hostConfig = new HostConfig().withBinds(allBinds).withPortBindings(allPortBindings).withExtraHosts(new String[]{"host.docker.internal:host-gateway"}).withDeviceRequests(allDeviceRequests);
                    CreateContainerResponse container = DockerClientFactory.lazyClient().createContainerCmd(image).withEnv(allEnvVars).withVolumes(allVolumes).withName(CONTAINER_NAME_PREFIX + System.currentTimeMillis()).withHostConfig(hostConfig).exec();
                    StartContainerCmd startContainerCmd = lazyClient.startContainerCmd(container.getId());
                    startContainerCmd.exec();
                    return true;
                }
                return null;
            }
            catch (JsonProcessingException ex) {
                throw new RuntimeException("Groot Kak", ex);
            }
        });
        buildTimeActions.add(startOpenWebUI);
        BuildTimeActionBuildItem isOpenWebUIRunning = new BuildTimeActionBuildItem();
        isOpenWebUIRunning.addAction("isOpenWebUIRunning", params -> this.isOpenWebUIRunning());
        buildTimeActions.add(isOpenWebUIRunning);
        BuildTimeActionBuildItem getOpenWebUIUrl = new BuildTimeActionBuildItem();
        getOpenWebUIUrl.addAction("getOpenWebUIUrl", params -> {
            InspectContainerResponse container = this.inspectOpenWebUIContainer();
            if (container != null) {
                return container.getNetworkSettings().getPorts().getBindings().values().stream().flatMap(Arrays::stream).map(p -> "http://localhost:" + p.getHostPortSpec()).findFirst().orElse(null);
            }
            return null;
        });
        buildTimeActions.add(getOpenWebUIUrl);
        BuildTimeActionBuildItem stopOpenWebUI = new BuildTimeActionBuildItem();
        stopOpenWebUI.addAction("stopOpenWebUI", params -> this.stopOpenWebUI());
        buildTimeActions.add(stopOpenWebUI);
        buildTimeActionProducer.produce(buildTimeActions);
    }

    private boolean stopOpenWebUI() throws NotFoundException, NotModifiedException {
        InspectContainerResponse container = this.inspectOpenWebUIContainer();
        if (container != null) {
            DockerClientFactory.lazyClient().stopContainerCmd(container.getId()).exec();
            DockerClientFactory.lazyClient().removeContainerCmd(container.getId()).exec();
            return true;
        }
        return false;
    }

    private InspectContainerResponse inspectOpenWebUIContainer() {
        return ((List)DockerClientFactory.lazyClient().listContainersCmd().exec()).stream().filter(OpenWebUIDevUIProcessor::isOpenWebUIContainer).findFirst().map(c -> c.getId()).map(id -> DockerClientFactory.lazyClient().inspectContainerCmd(id).exec()).orElse(null);
    }

    private Map<String, String> toMap(InspectContainerResponse containerDetails) {
        if (containerDetails != null) {
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("id", containerDetails.getId());
            m.put("name", containerDetails.getName());
            if (containerDetails.getConfig() != null) {
                m.put("image", containerDetails.getConfig().getImage());
            }
            if (containerDetails.getConfig() != null && containerDetails.getConfig().getCmd() != null) {
                m.put("cmd", String.join((CharSequence)" ", containerDetails.getConfig().getCmd()));
            }
            return m;
        }
        return null;
    }

    private boolean isOpenWebUIRunning() {
        InspectContainerResponse container = this.inspectOpenWebUIContainer();
        return container != null && container.getState().getRunning() != false;
    }

    private static boolean isOpenWebUIContainer(Container c) {
        return Arrays.stream(c.getNames()).anyMatch(n -> n.startsWith("/quarkus-open-webui-"));
    }

    private <K, V> Map<K, V> unmarshalMap(String input, Class<K> keyClass, Class<V> valueClass) {
        try {
            Properties properties = new Properties();
            properties.load(new StringReader(input));
            HashMap map = new HashMap();
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
                Object keyConverted = this.convert(key, keyClass);
                Object valueConverted = this.convert(value, valueClass);
                map.put(keyConverted, valueConverted);
            }));
            return map;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private <T> T convert(Object obj, Class<T> clazz) {
        String value = obj.toString();
        if (clazz.isAssignableFrom(Integer.class)) {
            return clazz.cast(Integer.parseInt(value));
        }
        return clazz.cast(value);
    }
}

