/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.deployment.devservice;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import io.quarkiverse.langchain4j.deployment.devservice.OllamaClient;
import io.smallrye.mutiny.operators.multi.builders.EmitterBasedMulti;
import io.smallrye.mutiny.subscription.BackPressureStrategy;
import io.smallrye.mutiny.subscription.MultiEmitter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.ConnectException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.concurrent.Flow;

public class JdkOllamaClient
implements OllamaClient {
    private final ObjectMapper objectMapper;
    private final OllamaClient.Options options;

    public JdkOllamaClient(OllamaClient.Options options) {
        this.options = options;
        this.objectMapper = new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE).setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @Override
    public boolean isRunning() {
        boolean bl;
        Socket s = new Socket(this.options.host(), this.options.port());
        try {
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    s.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return false;
            }
        }
        s.close();
        return bl;
    }

    @Override
    public List<OllamaClient.ModelInfo> localModels() {
        String serverUrl = String.format("http://%s:%d/api/tags", this.options.host(), this.options.port());
        try {
            HttpRequest httpRequest = HttpRequest.newBuilder().uri(new URI(serverUrl)).GET().build();
            HttpResponse<String> httpResponse = HttpClient.newHttpClient().send(httpRequest, HttpResponse.BodyHandlers.ofString());
            if (httpResponse.statusCode() != 200) {
                throw new RuntimeException("Unexpected response code: " + httpResponse.statusCode() + " response body: " + httpResponse.body());
            }
            return ((ModelsResponse)this.objectMapper.readValue(httpResponse.body(), ModelsResponse.class)).models();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Unable to convert " + serverUrl + " to URI", e);
        }
        catch (ConnectException e) {
            throw new OllamaClient.ServerUnavailableException(this.options.host(), this.options.port());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public OllamaClient.ModelInfo modelInfo(String modelName) {
        String serverUrl = String.format("http://%s:%d/api/show", this.options.host(), this.options.port());
        try {
            HttpRequest httpRequest = HttpRequest.newBuilder().uri(new URI(serverUrl)).POST(HttpRequest.BodyPublishers.ofString(String.format("{\"name\":\"%s\"}", modelName))).build();
            HttpResponse<String> httpResponse = HttpClient.newHttpClient().send(httpRequest, HttpResponse.BodyHandlers.ofString());
            if (httpResponse.statusCode() != 200) {
                if (httpResponse.statusCode() == 404) {
                    throw new OllamaClient.ModelNotFoundException(modelName);
                }
                throw new RuntimeException("Unexpected response code: " + httpResponse.statusCode() + " response body: " + httpResponse.body());
            }
            return (OllamaClient.ModelInfo)this.objectMapper.readValue(httpResponse.body(), OllamaClient.ModelInfo.class);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Unable to convert " + serverUrl + " to URI", e);
        }
        catch (ConnectException e) {
            throw new OllamaClient.ServerUnavailableException(this.options.host(), this.options.port());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Flow.Publisher<OllamaClient.PullAsyncLine> pullAsync(String modelName) {
        String serverUrl = String.format("http://%s:%d/api/pull", this.options.host(), this.options.port());
        try {
            HttpRequest httpRequest = HttpRequest.newBuilder().uri(new URI(serverUrl)).POST(HttpRequest.BodyPublishers.ofString(String.format("{\"name\":\"%s\", \"stream\": true}", modelName))).build();
            return new EmitterBasedMulti(emitter -> {
                try {
                    HttpClient.newHttpClient().send(httpRequest, HttpResponse.BodyHandlers.fromLineSubscriber(new PullAsyncLineSubscriber((MultiEmitter<? super OllamaClient.PullAsyncLine>)emitter, this.objectMapper, modelName)));
                }
                catch (ConnectException e) {
                    throw new OllamaClient.ServerUnavailableException(this.options.host(), this.options.port());
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }, BackPressureStrategy.BUFFER);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Unable to convert " + serverUrl + " to URI", e);
        }
    }

    @Override
    public void preloadChatModel(String modelName) {
        String serverUrl = String.format("http://%s:%d/api/chat", this.options.host(), this.options.port());
        try {
            HttpRequest httpRequest = HttpRequest.newBuilder().uri(new URI(serverUrl)).POST(HttpRequest.BodyPublishers.ofString(String.format("{\"model\": \"%s\"}", modelName))).build();
            HttpResponse<String> httpResponse = HttpClient.newHttpClient().send(httpRequest, HttpResponse.BodyHandlers.ofString());
            if (httpResponse.statusCode() != 200) {
                throw new RuntimeException("Unexpected response code: " + httpResponse.statusCode() + " response body: " + httpResponse.body());
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Unable to convert " + serverUrl + " to URI", e);
        }
        catch (ConnectException e) {
            throw new OllamaClient.ServerUnavailableException(this.options.host(), this.options.port());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private record ModelsResponse(List<OllamaClient.ModelInfo> models) {
    }

    private record PullAsyncLineSubscriber(MultiEmitter<? super OllamaClient.PullAsyncLine> emitter, ObjectMapper objectMapper, String modelName) implements Flow.Subscriber<String>
    {
        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            subscription.request(Long.MAX_VALUE);
        }

        @Override
        public void onNext(String item) {
            if (item.isBlank()) {
                return;
            }
            if (item.contains("file does not exist")) {
                this.emitter.fail((Throwable)new OllamaClient.ModelDoesNotExistException(this.modelName));
            }
            try {
                this.emitter.emit(this.objectMapper.readValue(item, OllamaClient.PullAsyncLine.class));
            }
            catch (Exception e) {
                this.emitter.fail((Throwable)e);
            }
        }

        @Override
        public void onError(Throwable throwable) {
            this.emitter.fail(throwable);
        }

        @Override
        public void onComplete() {
            this.emitter.complete();
        }
    }
}

