/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.deployment;

import dev.langchain4j.model.embedding.EmbeddingModel;
import io.quarkiverse.langchain4j.ModelName;
import io.quarkiverse.langchain4j.deployment.RequireOnnxRuntimeBuildItem;
import io.quarkiverse.langchain4j.deployment.items.InProcessEmbeddingBuildItem;
import io.quarkiverse.langchain4j.deployment.items.SelectedEmbeddingModelCandidateBuildItem;
import io.quarkiverse.langchain4j.runtime.InProcessEmbeddingRecorder;
import io.quarkiverse.langchain4j.runtime.NamedConfigUtil;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.List;
import java.util.Optional;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;

public class InProcessEmbeddingProcessor {
    private static final Logger LOGGER = Logger.getLogger(InProcessEmbeddingProcessor.class);
    private static final List<LocalEmbeddingModel> MODELS = List.of(new LocalEmbeddingModel("dev.langchain4j.model.embedding.onnx.allminilml6v2q.AllMiniLmL6V2QuantizedEmbeddingModel", "all-minilm-l6-v2-q", "all-minilm-l6-v2-q.onnx", "all-minilm-l6-v2-q-tokenizer.json"), new LocalEmbeddingModel("dev.langchain4j.model.embedding.onnx.allminilml6v2.AllMiniLmL6V2EmbeddingModel", "all-minilm-l6-v2", "all-minilm-l6-v2.onnx", "all-minilm-l6-v2-tokenizer.json"), new LocalEmbeddingModel("dev.langchain4j.model.embedding.onnx.bgesmallenq.BgeSmallEnQuantizedEmbeddingModel", "bge-small-en-q", "bge-small-en-q.onnx", "bge-small-en-q-tokenizer.json"), new LocalEmbeddingModel("dev.langchain4j.model.embedding.onnx.bgesmallen.BgeSmallEnEmbeddingModel", "bge-small-en", "bge-small-en.onnx", "bge-small-en-tokenizer.json"), new LocalEmbeddingModel("dev.langchain4j.model.embedding.onnx.bgesmallenv15q.BgeSmallEnV15QuantizedEmbeddingModel", "bge-small-en-v1.5-q", "bge-small-en-v1.5-q.onnx", "bge-small-en-v1.5-q-tokenizer.json"), new LocalEmbeddingModel("dev.langchain4j.model.embedding.onnx.bgesmallenv15.BgeSmallEnV15EmbeddingModel", "bge-small-en-v1.5", "bge-small-en-v1.5.onnx", "bge-small-en-v1.5-tokenizer.json"), new LocalEmbeddingModel("dev.langchain4j.model.embedding.onnx.bgesmallzhq.BgeSmallZhQuantizedEmbeddingModel", "bge-small-zh-q", "bge-small-zh-q.onnx", "bge-small-zh-q-tokenizer.json"), new LocalEmbeddingModel("dev.langchain4j.model.embedding.onnx.bgesmallzh.BgeSmallZhEmbeddingModel", "bge-small-zh", "bge-small-zh.onnx", "bge-small-zh-tokenizer.json"), new LocalEmbeddingModel("dev.langchain4j.model.embedding.onnx.e5smallv2q.E5SmallV2QuantizedEmbeddingModel", "e5-small-v2-q", "e5-small-v2-q.onnx", "e5-small-v2-q-tokenizer.json"), new LocalEmbeddingModel("dev.langchain4j.model.embedding.onnx.e5smallv2.E5SmallV2EmbeddingModel", "e5-small-v2", "e5-small-v2.onnx", "e5-small-v2-tokenizer.json"));

    @BuildStep
    public void generateLocalEmbeddingBuildItems(BuildProducer<InProcessEmbeddingBuildItem> producer) {
        for (LocalEmbeddingModel model : MODELS) {
            if (!QuarkusClassLoader.isClassPresentAtRuntime((String)model.classname())) continue;
            LOGGER.debugf("%s found in the runtime classpath", (Object)model.classname());
            if (!QuarkusClassLoader.isResourcePresentAtRuntime((String)model.onnxModelPath())) {
                throw new RuntimeException("Model " + model.modelName() + " is missing the ONNX model file: " + model.onnxModelPath());
            }
            if (!QuarkusClassLoader.isResourcePresentAtRuntime((String)model.vocabularyPath())) {
                throw new RuntimeException("Model " + model.modelName() + " is missing the vocabulary file: " + model.vocabularyPath());
            }
            producer.produce((BuildItem)new InProcessEmbeddingBuildItem(model.modelName(), model.classname(), model.onnxModelPath(), model.vocabularyPath()));
        }
    }

    @BuildStep
    void requireOnnxRuntime(List<InProcessEmbeddingBuildItem> embedding, BuildProducer<RequireOnnxRuntimeBuildItem> producer) {
        for (InProcessEmbeddingBuildItem item : embedding) {
            if (!item.requireOnnxRuntime()) continue;
            producer.produce((BuildItem)new RequireOnnxRuntimeBuildItem());
            break;
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void exposeInProcessEmbeddingBeans(InProcessEmbeddingRecorder recorder, List<InProcessEmbeddingBuildItem> embeddings, List<SelectedEmbeddingModelCandidateBuildItem> selectedEmbedding, BuildProducer<SyntheticBeanBuildItem> beanProducer) {
        for (InProcessEmbeddingBuildItem embedding : embeddings) {
            Optional<SelectedEmbeddingModelCandidateBuildItem> matchingSelected = selectedEmbedding.stream().filter(se -> se.getProvider().equals(embedding.getProvider())).findFirst();
            if (matchingSelected.isEmpty() && !selectedEmbedding.isEmpty()) continue;
            SyntheticBeanBuildItem.ExtendedBeanConfigurator builder = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((DotName)DotName.createSimple((String)embedding.className())).types(new Class[]{EmbeddingModel.class})).defaultBean()).setRuntimeInit().unremovable()).scope(ApplicationScoped.class)).supplier(recorder.instantiate(embedding.className()));
            matchingSelected.ifPresent(m -> this.addQualifierIfNecessary(builder, m.getConfigName()));
            beanProducer.produce((BuildItem)builder.done());
        }
    }

    private void addQualifierIfNecessary(SyntheticBeanBuildItem.ExtendedBeanConfigurator builder, String configName) {
        if (!NamedConfigUtil.isDefault((String)configName)) {
            builder.addQualifier(AnnotationInstance.builder(ModelName.class).add("value", configName).build());
        }
    }

    @BuildStep
    void configureNativeExecutableForInProcessEmbedding(List<InProcessEmbeddingBuildItem> embeddings, BuildProducer<RuntimeInitializedClassBuildItem> classes, BuildProducer<NativeImageResourceBuildItem> resources, BuildProducer<ReflectiveClassBuildItem> reflection) {
        for (InProcessEmbeddingBuildItem inProcessEmbeddingBuildItem : embeddings) {
            classes.produce((BuildItem)new RuntimeInitializedClassBuildItem(inProcessEmbeddingBuildItem.className()));
            resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{inProcessEmbeddingBuildItem.onnxModelPath()}));
            resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{inProcessEmbeddingBuildItem.vocabularyPath()}));
            reflection.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{inProcessEmbeddingBuildItem.className()}).constructors().fields().methods().build());
        }
    }

    record LocalEmbeddingModel(String classname, String modelName, String onnxModelPath, String vocabularyPath) {
    }
}

