/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.deployment;

import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.guardrail.InputGuardrail;
import dev.langchain4j.guardrail.InputGuardrailRequest;
import dev.langchain4j.guardrail.InputGuardrailResult;
import dev.langchain4j.guardrail.OutputGuardrail;
import dev.langchain4j.guardrail.OutputGuardrailRequest;
import dev.langchain4j.guardrail.OutputGuardrailResult;
import io.quarkiverse.langchain4j.deployment.LangChain4jDotNames;
import java.util.List;
import java.util.Optional;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

final class GuardrailObservabilityProcessorSupport {
    private static final Logger LOG = Logger.getLogger(GuardrailObservabilityProcessorSupport.class);
    private static final DotName INPUT_GUARDRAIL_REQUEST = DotName.createSimple(InputGuardrailRequest.class);
    private static final DotName INPUT_GUARDRAIL_RESULT = DotName.createSimple(InputGuardrailResult.class);
    private static final DotName OUTPUT_GUARDRAIL_REQUEST = DotName.createSimple(OutputGuardrailRequest.class);
    private static final DotName OUTPUT_GUARDRAIL_RESULT = DotName.createSimple(OutputGuardrailResult.class);
    private static final DotName INPUT_GUARDRAIL = DotName.createSimple(InputGuardrail.class);
    private static final DotName OUTPUT_GUARDRAIL = DotName.createSimple(OutputGuardrail.class);
    static final DotName MICROMETER_TIMED = DotName.createSimple((String)"io.micrometer.core.annotation.Timed");
    static final DotName MICROMETER_COUNTED = DotName.createSimple((String)"io.micrometer.core.annotation.Counted");
    static final DotName WITH_SPAN = DotName.createSimple((String)"io.opentelemetry.instrumentation.annotations.WithSpan");
    private static final DotName USER_MESSAGE = DotName.createSimple(UserMessage.class);
    private static final String VALIDATE_METHOD_NAME = "validate";

    GuardrailObservabilityProcessorSupport() {
    }

    static boolean doesMethodHaveMetricsAnnotations(MethodInfo methodInfo) {
        return !methodInfo.annotations(MICROMETER_TIMED).isEmpty() || !methodInfo.annotations(MICROMETER_COUNTED).isEmpty();
    }

    static boolean doesMethodHaveSpanAnnotation(MethodInfo methodInfo) {
        return !methodInfo.annotations(WITH_SPAN).isEmpty();
    }

    static boolean shouldTransformMethod(MethodInfo methodInfo, IndexView indexView, TransformType transformType) {
        ClassInfo methodClass;
        if (VALIDATE_METHOD_NAME.equals(methodInfo.name()) && !(methodClass = methodInfo.declaringClass()).isInterface()) {
            Boolean shouldTransform = GuardrailType.from(indexView, methodClass).map(guardrailType -> GuardrailObservabilityProcessorSupport.shouldTransformGuardrailValidateMethod(methodInfo, methodClass, transformType, guardrailType)).orElse(false);
            if (shouldTransform.booleanValue()) {
                LOG.debugf("Transforming guardrail method %s on class %s", (Object)methodInfo, (Object)methodClass);
            }
            return shouldTransform;
        }
        return false;
    }

    private static boolean doesMethodAlreadyHaveTransformationAnnotation(MethodInfo methodInfo, TransformType transformType) {
        return switch (transformType.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> GuardrailObservabilityProcessorSupport.doesMethodHaveMetricsAnnotations(methodInfo);
            case 1 -> GuardrailObservabilityProcessorSupport.doesMethodHaveSpanAnnotation(methodInfo);
        };
    }

    private static boolean shouldTransformGuardrailValidateMethod(MethodInfo methodInfo, ClassInfo methodDeclaringClass, TransformType transformType, GuardrailType guardrailType) {
        boolean isOtherValidateMethodVariant;
        if (GuardrailObservabilityProcessorSupport.isGuardrailValidateMethodWithParams(methodInfo)) {
            return !GuardrailObservabilityProcessorSupport.doesMethodAlreadyHaveTransformationAnnotation(methodInfo, transformType);
        }
        switch (guardrailType.ordinal()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 0: {
                boolean bl = GuardrailObservabilityProcessorSupport.isInputGuardrailValidateMethodWithUserMessage(methodInfo);
                break;
            }
            case 1: {
                boolean bl = isOtherValidateMethodVariant = GuardrailObservabilityProcessorSupport.isOutputGuardrailValidateMethodWithAiMessage(methodInfo);
            }
        }
        if (isOtherValidateMethodVariant && !GuardrailObservabilityProcessorSupport.doesMethodAlreadyHaveTransformationAnnotation(methodInfo, transformType)) {
            Type paramType = switch (guardrailType.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> Type.parse((String)INPUT_GUARDRAIL_REQUEST.toString());
                case 1 -> Type.parse((String)OUTPUT_GUARDRAIL_REQUEST.toString());
            };
            MethodInfo otherValidateMethod = methodDeclaringClass.method(VALIDATE_METHOD_NAME, new Type[]{paramType});
            return otherValidateMethod == null;
        }
        return false;
    }

    static boolean isGuardrailValidateMethodWithParams(MethodInfo methodInfo) {
        return VALIDATE_METHOD_NAME.equals(methodInfo.name()) && GuardrailObservabilityProcessorSupport.doesValidateMethodWithParamsHaveCorrectSignature(methodInfo);
    }

    private static boolean isInputGuardrailValidateMethodWithUserMessage(MethodInfo methodInfo) {
        return VALIDATE_METHOD_NAME.equals(methodInfo.name()) && GuardrailObservabilityProcessorSupport.doesValidateMethodWithoutParamsHaveCorrectSignature(methodInfo, USER_MESSAGE);
    }

    private static boolean isOutputGuardrailValidateMethodWithAiMessage(MethodInfo methodInfo) {
        return VALIDATE_METHOD_NAME.equals(methodInfo.name()) && GuardrailObservabilityProcessorSupport.doesValidateMethodWithoutParamsHaveCorrectSignature(methodInfo, LangChain4jDotNames.AI_MESSAGE);
    }

    private static boolean doesValidateMethodWithParamsHaveCorrectSignature(MethodInfo methodInfo) {
        List parameters = methodInfo.parameters();
        if (parameters.size() == 1) {
            DotName paramTypeName = ((MethodParameterInfo)parameters.get(0)).type().name();
            DotName returnType = methodInfo.returnType().name();
            return INPUT_GUARDRAIL_REQUEST.equals((Object)paramTypeName) && INPUT_GUARDRAIL_RESULT.equals((Object)returnType) || OUTPUT_GUARDRAIL_REQUEST.equals((Object)paramTypeName) && OUTPUT_GUARDRAIL_RESULT.equals((Object)returnType);
        }
        return false;
    }

    private static boolean doesValidateMethodWithoutParamsHaveCorrectSignature(MethodInfo methodInfo, DotName paramType) {
        List parameters = methodInfo.parameters();
        if (parameters.size() == 1) {
            DotName paramTypeName = ((MethodParameterInfo)parameters.get(0)).type().name();
            DotName returnType = methodInfo.returnType().name();
            return paramType.equals((Object)paramTypeName) && (INPUT_GUARDRAIL_RESULT.equals((Object)returnType) || OUTPUT_GUARDRAIL_RESULT.equals((Object)returnType));
        }
        return false;
    }

    static enum GuardrailType {
        INPUT,
        OUTPUT;


        static Optional<GuardrailType> from(IndexView indexView, ClassInfo classToCheck) {
            if (indexView.getAllKnownImplementors(INPUT_GUARDRAIL).contains(classToCheck)) {
                return Optional.of(INPUT);
            }
            if (indexView.getAllKnownImplementors(OUTPUT_GUARDRAIL).contains(classToCheck)) {
                return Optional.of(OUTPUT);
            }
            return Optional.empty();
        }
    }

    static enum TransformType {
        METRICS,
        OTEL;

    }
}

