/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.deployment;

import io.quarkiverse.langchain4j.deployment.GuardrailObservabilityProcessorSupport;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import java.util.Optional;
import java.util.function.Consumer;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTransformation;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;

public class GuardrailObservabilityProcessor {
    private static final Logger LOG = Logger.getLogger(GuardrailObservabilityProcessor.class);

    @BuildStep
    void transformWithMetrics(Optional<MetricsCapabilityBuildItem> metricsCapability, CombinedIndexBuildItem indexBuildItem, BuildProducer<AnnotationsTransformerBuildItem> annotationsTransformer) {
        if (metricsCapability.isPresent() && metricsCapability.get().metricsSupported("micrometer")) {
            LOG.debug((Object)"Transforming guardrail methods with @Timed and @Counted annotations");
            annotationsTransformer.produce((BuildItem)new AnnotationsTransformerBuildItem(GuardrailObservabilityProcessor.transformGuardrailValidateMethod(transformationContext -> transformationContext.addAll(new AnnotationInstance[]{AnnotationInstance.builder((DotName)GuardrailObservabilityProcessorSupport.MICROMETER_COUNTED).add("value", "guardrail.invoked").add("description", "Measures the number of times this guardrail was invoked").build(), AnnotationInstance.builder((DotName)GuardrailObservabilityProcessorSupport.MICROMETER_TIMED).add("value", "guardrail.timed").add("description", "Measures the runtime of this guardrail").add("percentiles", new double[]{0.75, 0.95, 0.99}).add("histogram", true).build()}), indexBuildItem.getIndex(), 2000, GuardrailObservabilityProcessorSupport.TransformType.METRICS)));
        }
    }

    @BuildStep
    void transformWithOtel(Capabilities capabilities, CombinedIndexBuildItem indexBuildItem, BuildProducer<AnnotationsTransformerBuildItem> annotationsTransformer) {
        if (capabilities.isPresent("io.quarkus.opentelemetry.tracer")) {
            LOG.debug((Object)"Transforming guardrail methods with @WithSpan annotation");
            annotationsTransformer.produce((BuildItem)new AnnotationsTransformerBuildItem(GuardrailObservabilityProcessor.transformGuardrailValidateMethod(transformationContext -> transformationContext.add(AnnotationInstance.builder((DotName)GuardrailObservabilityProcessorSupport.WITH_SPAN).build()), indexBuildItem.getIndex(), GuardrailObservabilityProcessorSupport.TransformType.OTEL)));
        }
    }

    private static AnnotationTransformation transformGuardrailValidateMethod(Consumer<AnnotationTransformation.TransformationContext> transformation, IndexView index, GuardrailObservabilityProcessorSupport.TransformType transformType) {
        return GuardrailObservabilityProcessor.transformGuardrailValidateMethod(transformation, index, 1000, transformType);
    }

    private static AnnotationTransformation transformGuardrailValidateMethod(Consumer<AnnotationTransformation.TransformationContext> transformation, IndexView index, int priority, GuardrailObservabilityProcessorSupport.TransformType transformType) {
        return ((AnnotationTransformation.MethodBuilder)AnnotationTransformation.forMethods().priority(priority)).whenMethod(methodInfo -> GuardrailObservabilityProcessorSupport.shouldTransformMethod(methodInfo, index, transformType)).transform(transformation);
    }
}

