/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.deployment;

import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import dev.langchain4j.guardrail.OutputGuardrail;
import dev.langchain4j.memory.ChatMemory;
import dev.langchain4j.model.chat.request.json.JsonSchema;
import dev.langchain4j.service.IllegalConfigurationException;
import dev.langchain4j.service.Moderate;
import dev.langchain4j.service.memory.ChatMemoryAccess;
import dev.langchain4j.service.output.JsonSchemas;
import dev.langchain4j.service.output.ServiceOutputParser;
import io.quarkiverse.langchain4j.ModelName;
import io.quarkiverse.langchain4j.RegisterAiService;
import io.quarkiverse.langchain4j.ToolBox;
import io.quarkiverse.langchain4j.deployment.AiServicesUseAnalyzer;
import io.quarkiverse.langchain4j.deployment.AnnotationsImpliesAiServiceBuildItem;
import io.quarkiverse.langchain4j.deployment.AsmUtil;
import io.quarkiverse.langchain4j.deployment.DeclarativeAiServiceBuildItem;
import io.quarkiverse.langchain4j.deployment.DotNames;
import io.quarkiverse.langchain4j.deployment.ExceptionUtil;
import io.quarkiverse.langchain4j.deployment.FallbackToDummyUserMessageBuildItem;
import io.quarkiverse.langchain4j.deployment.JandexUtil;
import io.quarkiverse.langchain4j.deployment.LangChain4jDotNames;
import io.quarkiverse.langchain4j.deployment.MethodParameterAsTemplateVariableAllowance;
import io.quarkiverse.langchain4j.deployment.MethodUtil;
import io.quarkiverse.langchain4j.deployment.ObjectSubstitutionUtil;
import io.quarkiverse.langchain4j.deployment.RequestChatModelBeanBuildItem;
import io.quarkiverse.langchain4j.deployment.RequestImageModelBeanBuildItem;
import io.quarkiverse.langchain4j.deployment.RequestModerationModelBeanBuildItem;
import io.quarkiverse.langchain4j.deployment.SkipOutputFormatInstructionsBuildItem;
import io.quarkiverse.langchain4j.deployment.TemplateUtil;
import io.quarkiverse.langchain4j.deployment.ToolProcessor;
import io.quarkiverse.langchain4j.deployment.ToolProviderMetaBuildItem;
import io.quarkiverse.langchain4j.deployment.TypeArgMapper;
import io.quarkiverse.langchain4j.deployment.config.LangChain4jBuildConfig;
import io.quarkiverse.langchain4j.deployment.devui.ToolProviderInfo;
import io.quarkiverse.langchain4j.deployment.items.AiServicesMethodBuildItem;
import io.quarkiverse.langchain4j.deployment.items.MethodParameterAllowedAnnotationsBuildItem;
import io.quarkiverse.langchain4j.deployment.items.MethodParameterIgnoredAnnotationsBuildItem;
import io.quarkiverse.langchain4j.deployment.items.SelectedChatModelProviderBuildItem;
import io.quarkiverse.langchain4j.deployment.items.ToolMethodBuildItem;
import io.quarkiverse.langchain4j.deployment.items.ToolQualifierProvider;
import io.quarkiverse.langchain4j.guardrails.ClassProvidingAnnotationLiteral;
import io.quarkiverse.langchain4j.guardrails.InputGuardrailsLiteral;
import io.quarkiverse.langchain4j.guardrails.OutputGuardrailAccumulator;
import io.quarkiverse.langchain4j.guardrails.OutputGuardrailsLiteral;
import io.quarkiverse.langchain4j.runtime.AiServicesRecorder;
import io.quarkiverse.langchain4j.runtime.NamedConfigUtil;
import io.quarkiverse.langchain4j.runtime.QuarkusServiceOutputParser;
import io.quarkiverse.langchain4j.runtime.RequestScopeStateDefaultMemoryIdProvider;
import io.quarkiverse.langchain4j.runtime.ResponseSchemaUtil;
import io.quarkiverse.langchain4j.runtime.aiservice.AiServiceClassCreateInfo;
import io.quarkiverse.langchain4j.runtime.aiservice.AiServiceMethodCreateInfo;
import io.quarkiverse.langchain4j.runtime.aiservice.AiServiceMethodImplementationSupport;
import io.quarkiverse.langchain4j.runtime.aiservice.ChatMemoryRemovable;
import io.quarkiverse.langchain4j.runtime.aiservice.ChatMemorySeeder;
import io.quarkiverse.langchain4j.runtime.aiservice.DeclarativeAiServiceCreateInfo;
import io.quarkiverse.langchain4j.runtime.aiservice.MetricsCountedWrapper;
import io.quarkiverse.langchain4j.runtime.aiservice.MetricsTimedWrapper;
import io.quarkiverse.langchain4j.runtime.aiservice.QuarkusAiServiceContext;
import io.quarkiverse.langchain4j.runtime.aiservice.SpanWrapper;
import io.quarkiverse.langchain4j.runtime.types.TypeSignatureParser;
import io.quarkiverse.langchain4j.runtime.types.TypeUtil;
import io.quarkiverse.langchain4j.spi.DefaultMemoryIdProvider;
import io.quarkiverse.langchain4j.spi.PromptTemplateFactoryContentFilterProvider;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.DefaultBean;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.CustomScopeAnnotationsBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.arc.deployment.SynthesisFinishedBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.qute.Expression;
import io.smallrye.mutiny.Multi;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.spi.DeploymentException;
import jakarta.enterprise.util.AnnotationLiteral;
import jakarta.inject.Inject;
import jakarta.interceptor.InterceptorBinding;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.tools.Tool;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.rest.client.inject.RestClient;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.AnalyzerException;

public class AiServicesProcessor {
    private static final Logger log = Logger.getLogger(AiServicesProcessor.class);
    private static final DotName TOOL = DotName.createSimple(Tool.class);
    private static final DotName TOOLBOX = DotName.createSimple(ToolBox.class);
    public static final DotName MICROMETER_TIMED = DotName.createSimple((String)"io.micrometer.core.annotation.Timed");
    public static final DotName MICROMETER_COUNTED = DotName.createSimple((String)"io.micrometer.core.annotation.Counted");
    public static final String DEFAULT_DELIMITER = "\n";
    public static final Predicate<AnnotationInstance> IS_METHOD_PARAMETER_ANNOTATION = ai -> ai.target().kind() == AnnotationTarget.Kind.METHOD_PARAMETER;
    private static final Function<AnnotationInstance, Integer> METHOD_PARAMETER_POSITION_FUNCTION = ai -> ai.target().asMethodParameter().position();
    public static final MethodDescriptor OBJECT_CONSTRUCTOR = MethodDescriptor.ofConstructor(Object.class, (Class[])new Class[0]);
    private static final MethodDescriptor RECORDER_METHOD_CREATE_INFO = MethodDescriptor.ofMethod(AiServicesRecorder.class, (String)"getAiServiceMethodCreateInfo", AiServiceMethodCreateInfo.class, (Class[])new Class[]{String.class, String.class});
    private static final MethodDescriptor SUPPORT_IMPLEMENT = MethodDescriptor.ofMethod(AiServiceMethodImplementationSupport.class, (String)"implement", Object.class, (Class[])new Class[]{AiServiceMethodImplementationSupport.Input.class});
    private static final MethodDescriptor QUARKUS_AI_SERVICES_CONTEXT_CLOSE = MethodDescriptor.ofMethod(QuarkusAiServiceContext.class, (String)"close", Void.TYPE, (Class[])new Class[0]);
    private static final MethodDescriptor QUARKUS_AI_SERVICES_CONTEXT_REMOVE_CHAT_MEMORY_IDS = MethodDescriptor.ofMethod(QuarkusAiServiceContext.class, (String)"removeChatMemoryIds", Void.TYPE, (Class[])new Class[]{Object[].class});
    private static final MethodDescriptor QUARKUS_AI_SERVICES_CONTEXT_EVICT_CHAT_MEMORY = MethodDescriptor.ofMethod(QuarkusAiServiceContext.class, (String)"evictChatMemory", Boolean.TYPE, (Class[])new Class[]{Object.class});
    private static final MethodDescriptor QUARKUS_AI_SERVICES_CONTEXT_GET_CHAT_MEMORY = MethodDescriptor.ofMethod(QuarkusAiServiceContext.class, (String)"getChatMemory", ChatMemory.class, (Class[])new Class[]{Object.class});
    public static final MethodDescriptor CHAT_MEMORY_SEEDER_CONTEXT_METHOD_NAME = MethodDescriptor.ofMethod(ChatMemorySeeder.Context.class, (String)"methodName", String.class, (Class[])new Class[0]);
    private static final DotName CHAT_MEMORY_ACCESS = DotName.createSimple(ChatMemoryAccess.class);
    private static final String METRICS_DEFAULT_NAME = "langchain4j.aiservices";
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final ResultHandle[] EMPTY_RESULT_HANDLES_ARRAY = new ResultHandle[0];
    private static final ServiceOutputParser SERVICE_OUTPUT_PARSER = new QuarkusServiceOutputParser();

    @BuildStep
    public void nativeSupport(CombinedIndexBuildItem indexBuildItem, List<AiServicesMethodBuildItem> aiServicesMethodBuildItems, BuildProducer<ReflectiveClassBuildItem> reflectiveClassProducer, BuildProducer<ServiceProviderBuildItem> serviceProviderProducer) {
        IndexView index = indexBuildItem.getIndex();
        Collection instances = index.getAnnotations(LangChain4jDotNames.DESCRIPTION);
        HashSet<ClassInfo> classesUsingDescription = new HashSet<ClassInfo>();
        for (AnnotationInstance instance : instances) {
            if (instance.target().kind() != AnnotationTarget.Kind.FIELD) continue;
            classesUsingDescription.add(instance.target().asField().declaringClass());
        }
        if (!classesUsingDescription.isEmpty()) {
            reflectiveClassProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])((String[])classesUsingDescription.stream().map(i -> i.name().toString()).toArray(String[]::new))).fields(true).build());
        }
        HashSet<DotName> returnTypesToRegister = new HashSet<DotName>();
        for (AiServicesMethodBuildItem aiServicesMethodBuildItem : aiServicesMethodBuildItems) {
            DotName returnTypeName;
            org.jboss.jandex.Type type = aiServicesMethodBuildItem.getMethodInfo().returnType();
            if (type.kind() == Type.Kind.PRIMITIVE || (returnTypeName = type.name()).toString().startsWith("java.")) continue;
            returnTypesToRegister.add(returnTypeName);
        }
        if (!returnTypesToRegister.isEmpty()) {
            reflectiveClassProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])((String[])returnTypesToRegister.stream().map(DotName::toString).toArray(String[]::new))).constructors().fields().methods().build());
        }
        serviceProviderProducer.produce((BuildItem)new ServiceProviderBuildItem(DefaultMemoryIdProvider.class.getName(), new String[]{RequestScopeStateDefaultMemoryIdProvider.class.getName()}));
        serviceProviderProducer.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)PromptTemplateFactoryContentFilterProvider.class.getName()));
        reflectiveClassProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{PropertyNamingStrategies.SnakeCaseStrategy.class}).constructors().build());
        reflectiveClassProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{PropertyNamingStrategies.LowerCamelCaseStrategy.class}).constructors().build());
    }

    @BuildStep
    public void validateToolsPerAiService(BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> validation, CombinedIndexBuildItem indexBuildItem) {
        IndexView index = indexBuildItem.getIndex();
        Collection instances = index.getAnnotations(LangChain4jDotNames.REGISTER_AI_SERVICES);
        for (AnnotationInstance instance : instances) {
            if (instance.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            ClassInfo declarativeAiServiceClassInfo = instance.target().asClass();
            ArrayList<ClassInfo> tools = new ArrayList<ClassInfo>();
            HashSet<String> visited = new HashSet<String>();
            HashSet<String> toolNames = new HashSet<String>();
            for (ClassInfo toolClass : AiServicesProcessor.tools(instance, index)) {
                if (visited.contains(toolClass.name().toString())) continue;
                tools.add(toolClass);
                visited.add(toolClass.name().toString());
                Set<String> currentToolNames = AiServicesProcessor.gatherToolNames(toolClass);
                for (String toolName : currentToolNames) {
                    if (toolNames.contains(toolName)) {
                        validation.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new IllegalStateException("Duplicate tool name '" + toolName + "' found in tools for ai services class '" + String.valueOf(declarativeAiServiceClassInfo.name()) + "'.")}));
                    }
                    toolNames.add(toolName);
                }
            }
            for (MethodInfo serviceMethodInfo : declarativeAiServiceClassInfo.methods()) {
                AnnotationInstance toolBoxInstance;
                if (!serviceMethodInfo.hasAnnotation(TOOLBOX) || (toolBoxInstance = serviceMethodInfo.declaredAnnotation(TOOLBOX)) == null) continue;
                for (String methodToolClassName : this.gatherMethodToolClassNames(serviceMethodInfo)) {
                    if (visited.contains(methodToolClassName)) continue;
                    visited.add(methodToolClassName);
                    Set<String> currentToolNames = AiServicesProcessor.gatherToolNames(index.getClassByName(methodToolClassName));
                    for (String toolName : currentToolNames) {
                        if (toolNames.contains(toolName)) {
                            validation.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new IllegalStateException("Duplicate tool name '" + toolName + "' found in tools for ai services method '" + serviceMethodInfo.name() + "' of class '" + String.valueOf(declarativeAiServiceClassInfo.name()) + "'.")}));
                        }
                        toolNames.add(toolName);
                    }
                }
            }
        }
    }

    private static Set<String> gatherToolNames(ClassInfo toolClass) {
        HashSet<String> toolNames = new HashSet<String>();
        for (MethodInfo method : toolClass.methods()) {
            String toolName = ToolProcessor.resolveToolName(method);
            if (toolName == null) continue;
            toolNames.add(toolName);
        }
        return toolNames;
    }

    @BuildStep
    public void findDeclarativeServices(CombinedIndexBuildItem indexBuildItem, CustomScopeAnnotationsBuildItem customScopes, List<AnnotationsImpliesAiServiceBuildItem> annotationsImpliesAiServiceItems, BuildProducer<RequestChatModelBeanBuildItem> requestChatModelBeanProducer, BuildProducer<RequestModerationModelBeanBuildItem> requestModerationModelBeanProducer, BuildProducer<RequestImageModelBeanBuildItem> requestImageModelBeanProducer, BuildProducer<DeclarativeAiServiceBuildItem> declarativeAiServiceProducer, BuildProducer<ToolProviderMetaBuildItem> toolProviderProducer, BuildProducer<ReflectiveClassBuildItem> reflectiveClassProducer, BuildProducer<GeneratedClassBuildItem> generatedClassProducer) {
        IndexView index = indexBuildItem.getIndex();
        HashSet<String> chatModelNames = new HashSet<String>();
        HashSet<String> moderationModelNames = new HashSet<String>();
        HashSet<String> imageModelNames = new HashSet<String>();
        ArrayList<ToolProviderInfo> toolProviderInfos = new ArrayList<ToolProviderInfo>();
        GeneratedClassGizmoAdaptor generatedClassOutput = new GeneratedClassGizmoAdaptor(generatedClassProducer, true);
        Set<DotName> annotationsThatImplyAiService = annotationsImpliesAiServiceItems.stream().flatMap(bi -> bi.getAnnotationNames().stream()).collect(Collectors.toSet());
        ArrayList<AnnotationInstance> registerAiServicesInstances = new ArrayList<AnnotationInstance>(index.getAnnotations(LangChain4jDotNames.REGISTER_AI_SERVICES));
        Set<AnnotationInstance> impliedRegisterAiServiceInstance = AiServicesProcessor.determinedImpliedRegisterAiService(annotationsThatImplyAiService, index);
        Set impliedRegisterAiServiceTarget = impliedRegisterAiServiceInstance.stream().map(ai -> ai.target().asClass().name()).collect(Collectors.toSet());
        registerAiServicesInstances.addAll(impliedRegisterAiServiceInstance);
        HashSet<DotName> alreadyHandled = new HashSet<DotName>();
        for (AnnotationInstance instance : registerAiServicesInstances) {
            Object method2;
            ClassInfo declarativeAiServiceClassInfo;
            if (instance.target().kind() != AnnotationTarget.Kind.CLASS || alreadyHandled.contains((declarativeAiServiceClassInfo = instance.target().asClass()).name())) continue;
            alreadyHandled.add(declarativeAiServiceClassInfo.name());
            DotName chatLanguageModelSupplierClassDotName = this.getSupplierDotName(instance.value("chatLanguageModelSupplier"), LangChain4jDotNames.BEAN_CHAT_MODEL_SUPPLIER, supplierDotName -> this.validateSupplierAndRegisterForReflection((DotName)supplierDotName, index, reflectiveClassProducer));
            DotName streamingChatLanguageModelSupplierClassDotName = this.getSupplierDotName(instance.value("streamingChatLanguageModelSupplier"), LangChain4jDotNames.BEAN_STREAMING_CHAT_MODEL_SUPPLIER, supplierDotName -> this.validateSupplierAndRegisterForReflection((DotName)supplierDotName, index, reflectiveClassProducer));
            String chatModelName = AiServicesProcessor.chatModelName(instance, chatLanguageModelSupplierClassDotName, streamingChatLanguageModelSupplierClassDotName, chatModelNames);
            boolean customRetrievalAugmentorSupplierClassIsABean = false;
            DotName retrievalAugmentorSupplierClassName = LangChain4jDotNames.BEAN_IF_EXISTS_RETRIEVAL_AUGMENTOR_SUPPLIER;
            AnnotationValue retrievalAugmentorSupplierValue = instance.value("retrievalAugmentor");
            if (retrievalAugmentorSupplierValue != null && !LangChain4jDotNames.BEAN_IF_EXISTS_RETRIEVAL_AUGMENTOR_SUPPLIER.equals((Object)retrievalAugmentorSupplierValue.asClass().name())) {
                if (LangChain4jDotNames.NO_RETRIEVAL_AUGMENTOR_SUPPLIER.equals((Object)retrievalAugmentorSupplierValue.asClass().name())) {
                    retrievalAugmentorSupplierClassName = null;
                } else {
                    retrievalAugmentorSupplierClassName = retrievalAugmentorSupplierValue.asClass().name();
                    BuiltinScope declaredScope = BuiltinScope.from((ClassInfo)index.getClassByName(retrievalAugmentorSupplierClassName));
                    if (declaredScope != null) {
                        customRetrievalAugmentorSupplierClassIsABean = true;
                    } else {
                        this.validateSupplierAndRegisterForReflection(retrievalAugmentorSupplierClassName, index, reflectiveClassProducer);
                    }
                }
            }
            DotName moderationModelSupplierClassName = LangChain4jDotNames.BEAN_IF_EXISTS_MODERATION_MODEL_SUPPLIER;
            AnnotationValue moderationModelSupplierValue = instance.value("moderationModelSupplier");
            if (moderationModelSupplierValue != null) {
                moderationModelSupplierClassName = moderationModelSupplierValue.asClass().name();
                this.validateSupplierAndRegisterForReflection(moderationModelSupplierClassName, index, reflectiveClassProducer);
            }
            DotName toolProviderClassName = LangChain4jDotNames.BEAN_IF_EXISTS_TOOL_PROVIDER_SUPPLIER;
            AnnotationValue toolProviderValue = instance.value("toolProviderSupplier");
            if (toolProviderValue != null) {
                if (LangChain4jDotNames.NO_TOOL_PROVIDER_SUPPLIER.equals((Object)toolProviderValue.asClass().name())) {
                    toolProviderClassName = null;
                } else {
                    toolProviderClassName = toolProviderValue.asClass().name();
                    this.validateSupplierAndRegisterForReflection(toolProviderClassName, index, reflectiveClassProducer);
                    toolProviderInfos.add(new ToolProviderInfo(toolProviderClassName.toString(), declarativeAiServiceClassInfo.simpleName()));
                }
            }
            for (Object method2 : declarativeAiServiceClassInfo.methods()) {
                org.jboss.jandex.Type returnType = method2.returnType();
                if (!this.isImageOrImageResultResult(returnType)) continue;
                imageModelNames.add(chatModelName);
            }
            String moderationModelName = "<default>";
            method2 = declarativeAiServiceClassInfo.methods().iterator();
            while (method2.hasNext()) {
                String modelNameValueStr;
                MethodInfo method3 = (MethodInfo)method2.next();
                if (!method3.hasAnnotation(LangChain4jDotNames.MODERATE)) continue;
                if (!moderationModelSupplierClassName.equals((Object)LangChain4jDotNames.BEAN_IF_EXISTS_MODERATION_MODEL_SUPPLIER)) break;
                AnnotationValue modelNameValue = instance.value("modelName");
                if (modelNameValue != null && (modelNameValueStr = modelNameValue.asString()) != null && !modelNameValueStr.isEmpty()) {
                    moderationModelName = modelNameValueStr;
                }
                moderationModelNames.add(moderationModelName);
                break;
            }
            String imageModelName = chatModelName;
            List<ClassInfo> tools = AiServicesProcessor.tools(instance, index);
            DotName chatMemoryProviderSupplierClassDotName = this.chatMemoryProviderSupplierClassDotName(reflectiveClassProducer, instance, index);
            if (!tools.isEmpty() && chatMemoryProviderSupplierClassDotName == null) {
                throw new IllegalArgumentException("Tool usage requires chat memory. Offending AiService is '" + String.valueOf(declarativeAiServiceClassInfo.name()) + "'");
            }
            Integer maxSequentialToolInvocations = instance.value("maxSequentialToolInvocations") != null ? instance.value("maxSequentialToolInvocations").asInt() : 0;
            declarativeAiServiceProducer.produce((BuildItem)new DeclarativeAiServiceBuildItem(declarativeAiServiceClassInfo, chatLanguageModelSupplierClassDotName, streamingChatLanguageModelSupplierClassDotName, tools, chatMemoryProviderSupplierClassDotName, retrievalAugmentorSupplierClassName, customRetrievalAugmentorSupplierClassIsABean, moderationModelSupplierClassName, this.imageModelSupplierClassName(reflectiveClassProducer, instance, index), this.determineChatMemorySeeder(declarativeAiServiceClassInfo, (ClassOutput)generatedClassOutput), AiServicesProcessor.cdiScope(customScopes, declarativeAiServiceClassInfo), chatModelName, moderationModelName, imageModelName, toolProviderClassName, AiServicesProcessor.beanName(declarativeAiServiceClassInfo), AiServicesProcessor.toolHallucinationStrategy(instance), AiServicesProcessor.classInputGuardrails(declarativeAiServiceClassInfo, index), AiServicesProcessor.classOutputGuardrails(declarativeAiServiceClassInfo, index), maxSequentialToolInvocations, impliedRegisterAiServiceTarget.contains(declarativeAiServiceClassInfo.name())));
        }
        toolProviderProducer.produce((BuildItem)new ToolProviderMetaBuildItem(toolProviderInfos));
        for (String chatModelName : chatModelNames) {
            requestChatModelBeanProducer.produce((BuildItem)new RequestChatModelBeanBuildItem(chatModelName));
        }
        for (String moderationModelName : moderationModelNames) {
            requestModerationModelBeanProducer.produce((BuildItem)new RequestModerationModelBeanBuildItem(moderationModelName));
        }
        for (String imageModelName : imageModelNames) {
            requestImageModelBeanProducer.produce((BuildItem)new RequestImageModelBeanBuildItem(imageModelName));
        }
    }

    private static Set<AnnotationInstance> determinedImpliedRegisterAiService(Set<DotName> annotationsThatImplyAiService, IndexView index) {
        HashSet<AnnotationInstance> impliedDefaultRegisterAiService = new HashSet<AnnotationInstance>();
        for (DotName ann : annotationsThatImplyAiService) {
            index.getAnnotations(ann).forEach(instance -> {
                ClassInfo ci = switch (instance.target().kind()) {
                    case AnnotationTarget.Kind.METHOD -> instance.target().asMethod().declaringClass();
                    case AnnotationTarget.Kind.CLASS -> instance.target().asClass();
                    case AnnotationTarget.Kind.FIELD -> instance.target().asField().declaringClass();
                    default -> null;
                };
                if (ci == null) {
                    return;
                }
                if (!ci.isInterface()) {
                    return;
                }
                impliedDefaultRegisterAiService.add(AnnotationInstance.builder((DotName)LangChain4jDotNames.REGISTER_AI_SERVICES).buildWithTarget((AnnotationTarget)ci));
            });
        }
        return impliedDefaultRegisterAiService;
    }

    private static String chatModelName(AnnotationInstance instance, DotName chatLanguageModelSupplierClassDotName, DotName streamingChatLanguageModelSupplierClassDotName, Set<String> chatModelNames) {
        String chatModelName = "<default>";
        if (chatLanguageModelSupplierClassDotName == null && streamingChatLanguageModelSupplierClassDotName == null) {
            String modelNameValueStr;
            AnnotationValue modelNameValue = instance.value("modelName");
            if (modelNameValue != null && (modelNameValueStr = modelNameValue.asString()) != null && !modelNameValueStr.isEmpty()) {
                chatModelName = modelNameValueStr;
            }
            chatModelNames.add(chatModelName);
        }
        return chatModelName;
    }

    private static Optional<String> beanName(ClassInfo declarativeAiServiceClassInfo) {
        AnnotationInstance namedAnno = declarativeAiServiceClassInfo.annotation(io.quarkus.arc.processor.DotNames.NAMED);
        Optional<String> beanName = Optional.empty();
        if (namedAnno != null) {
            beanName = Optional.ofNullable(namedAnno.value().asString());
        }
        return beanName;
    }

    private static DotName cdiScope(CustomScopeAnnotationsBuildItem customScopes, ClassInfo declarativeAiServiceClassInfo) {
        DotName cdiScope = BuiltinScope.REQUEST.getInfo().getDotName();
        Optional scopeAnnotation = customScopes.getScope((Collection)declarativeAiServiceClassInfo.annotations());
        if (scopeAnnotation.isPresent()) {
            cdiScope = ((AnnotationInstance)scopeAnnotation.get()).name();
        }
        return cdiScope;
    }

    private DotName imageModelSupplierClassName(BuildProducer<ReflectiveClassBuildItem> reflectiveClassProducer, AnnotationInstance instance, IndexView index) {
        DotName imageModelSupplierClassName = LangChain4jDotNames.BEAN_IF_EXISTS_IMAGE_MODEL_SUPPLIER;
        AnnotationValue imageModelSupplierValue = instance.value("imageModelSupplier");
        if (imageModelSupplierValue != null) {
            imageModelSupplierClassName = imageModelSupplierValue.asClass().name();
            this.validateSupplierAndRegisterForReflection(imageModelSupplierClassName, index, reflectiveClassProducer);
        }
        return imageModelSupplierClassName;
    }

    private DotName chatMemoryProviderSupplierClassDotName(BuildProducer<ReflectiveClassBuildItem> reflectiveClassProducer, AnnotationInstance instance, IndexView index) {
        DotName chatMemoryProviderSupplierClassDotName = LangChain4jDotNames.BEAN_CHAT_MEMORY_PROVIDER_SUPPLIER;
        AnnotationValue chatMemoryProviderSupplierValue = instance.value("chatMemoryProviderSupplier");
        if (chatMemoryProviderSupplierValue != null) {
            chatMemoryProviderSupplierClassDotName = chatMemoryProviderSupplierValue.asClass().name();
            if (chatMemoryProviderSupplierClassDotName.equals((Object)LangChain4jDotNames.NO_CHAT_MEMORY_PROVIDER_SUPPLIER)) {
                chatMemoryProviderSupplierClassDotName = null;
            } else if (!chatMemoryProviderSupplierClassDotName.equals((Object)LangChain4jDotNames.BEAN_CHAT_MEMORY_PROVIDER_SUPPLIER)) {
                this.validateSupplierAndRegisterForReflection(chatMemoryProviderSupplierClassDotName, index, reflectiveClassProducer);
            }
        }
        return chatMemoryProviderSupplierClassDotName;
    }

    private static DeclarativeAiServiceBuildItem.DeclarativeAiServiceInputGuardrails classInputGuardrails(ClassInfo aiServiceClassInfo, IndexView index) {
        Optional<AnnotationInstance> inputGuardrailsAnnotation = Optional.ofNullable(aiServiceClassInfo.annotation(LangChain4jDotNames.INPUT_GUARDRAILS));
        return new DeclarativeAiServiceBuildItem.DeclarativeAiServiceInputGuardrails(AiServicesProcessor.classGuardrails(inputGuardrailsAnnotation, index));
    }

    private static DeclarativeAiServiceBuildItem.DeclarativeAiServiceOutputGuardrails classOutputGuardrails(ClassInfo aiServiceClassInfo, IndexView index) {
        Optional<AnnotationInstance> outputGuardrailsAnnotation = Optional.ofNullable(aiServiceClassInfo.annotation(LangChain4jDotNames.OUTPUT_GUARDRAILS));
        Integer maxRetries = outputGuardrailsAnnotation.map(a -> a.value("maxRetries")).map(AnnotationValue::asInt).orElse(3);
        return new DeclarativeAiServiceBuildItem.DeclarativeAiServiceOutputGuardrails(AiServicesProcessor.classGuardrails(outputGuardrailsAnnotation, index), maxRetries);
    }

    private static List<ClassInfo> classGuardrails(Optional<AnnotationInstance> annotation, IndexView index) {
        return AiServicesProcessor.gatherGuardrailsStream(annotation).map(org.jboss.jandex.Type::name).map(arg_0 -> ((IndexView)index).getClassByName(arg_0)).toList();
    }

    private static InputGuardrailsLiteral classInputGuardrails(DeclarativeAiServiceBuildItem declarativeAiServiceBuildItem) {
        return new InputGuardrailsLiteral(declarativeAiServiceBuildItem.getInputGuardrails().asClassNames());
    }

    private static OutputGuardrailsLiteral classOutputGuardrails(DeclarativeAiServiceBuildItem declarativeAiServiceBuildItem) {
        return new OutputGuardrailsLiteral(declarativeAiServiceBuildItem.getOutputGuardrails().asClassNames(), declarativeAiServiceBuildItem.getOutputGuardrails().maxRetries());
    }

    private static List<ClassInfo> tools(AnnotationInstance instance, IndexView index) {
        AnnotationValue toolsInstance = instance.value("tools");
        if (toolsInstance != null) {
            return Arrays.stream(toolsInstance.asClassArray()).map(t -> {
                ClassInfo ci = index.getClassByName(t.name());
                if (ci == null) {
                    throw new IllegalArgumentException("Cannot find class " + String.valueOf(t.name()) + " in index. Please make sure it's a valid CDI bean known to Quarkus");
                }
                return ci;
            }).toList();
        }
        return Collections.emptyList();
    }

    private static DotName toolHallucinationStrategy(AnnotationInstance instance) {
        AnnotationValue toolHallucinationStrategyInstance = instance.value("toolHallucinationStrategy");
        if (toolHallucinationStrategyInstance != null) {
            return toolHallucinationStrategyInstance.asClass().name();
        }
        return null;
    }

    private DotName getSupplierDotName(AnnotationValue instanceAnnotation, DotName supplierDotName, Consumer<DotName> validator) {
        DotName dotName = null;
        if (instanceAnnotation != null) {
            dotName = instanceAnnotation.asClass().name();
            if (dotName.equals((Object)supplierDotName)) {
                dotName = null;
            } else {
                validator.accept(dotName);
            }
        }
        return dotName;
    }

    private void validateSupplierAndRegisterForReflection(DotName supplierDotName, IndexView index, BuildProducer<ReflectiveClassBuildItem> producer) {
        ClassInfo classInfo = index.getClassByName(supplierDotName);
        if (classInfo == null) {
            log.warn((Object)("'" + supplierDotName.toString() + "' cannot be indexed"));
            return;
        }
        if (!classInfo.hasNoArgsConstructor()) {
            throw new IllegalConfigurationException("Class '" + supplierDotName.toString() + "' which must contain a no-args constructor.");
        }
        producer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{supplierDotName.toString()}).constructors(true).build());
    }

    private boolean isImageOrImageResultResult(org.jboss.jandex.Type returnType) {
        ParameterizedType parameterizedType;
        if (returnType.name().equals((Object)LangChain4jDotNames.IMAGE)) {
            return true;
        }
        return returnType.kind() == Type.Kind.PARAMETERIZED_TYPE && LangChain4jDotNames.RESULT.equals((Object)(parameterizedType = returnType.asParameterizedType()).name()) && parameterizedType.arguments().size() == 1 && ((org.jboss.jandex.Type)parameterizedType.arguments().get(0)).name().equals((Object)LangChain4jDotNames.IMAGE);
    }

    @BuildStep
    public void toolQualifiers(BuildProducer<ToolQualifierProvider.BuildItem> producer) {
        producer.produce((BuildItem)new ToolQualifierProvider.BuildItem(new ToolQualifierProvider(){

            @Override
            public boolean supports(ClassInfo classInfo) {
                return classInfo.hasAnnotation(DotNames.REGISTER_REST_CLIENT);
            }

            @Override
            public AnnotationLiteral<?> qualifier(ClassInfo classInfo) {
                return new RestClient.RestClientLiteral();
            }
        }));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void handleDeclarativeServices(AiServicesRecorder recorder, List<DeclarativeAiServiceBuildItem> declarativeAiServiceItems, List<SelectedChatModelProviderBuildItem> selectedChatModelProvider, List<ToolQualifierProvider.BuildItem> toolQualifierProviderItems, BuildProducer<SyntheticBeanBuildItem> syntheticBeanProducer, BuildProducer<UnremovableBeanBuildItem> unremovableProducer) {
        boolean needsChatModelBean = false;
        boolean needsStreamingChatModelBean = false;
        boolean needsChatMemoryProviderBean = false;
        boolean needsRetrieverBean = false;
        boolean needsRetrievalAugmentorBean = false;
        boolean needsModerationModelBean = false;
        boolean needsImageModelBean = false;
        boolean needsToolProviderBean = false;
        HashSet<DotName> allToolNames = new HashSet<DotName>();
        HashSet<DotName> allToolProviders = new HashSet<DotName>();
        HashSet<DotName> allToolHallucinationStrategies = new HashSet<DotName>();
        for (DeclarativeAiServiceBuildItem bi : declarativeAiServiceItems) {
            boolean hasChatModelSupplier;
            Object method2;
            ClassInfo declarativeAiServiceClassInfo = bi.getServiceClassInfo();
            String serviceClassName = declarativeAiServiceClassInfo.name().toString();
            Integer maxSequentialToolInvocations = bi.getMaxSequentialToolInvocations();
            String chatLanguageModelSupplierClassName = bi.getChatLanguageModelSupplierClassDotName() != null ? bi.getChatLanguageModelSupplierClassDotName().toString() : null;
            String streamingChatLanguageModelSupplierClassName = bi.getStreamingChatLanguageModelSupplierClassDotName() != null ? bi.getStreamingChatLanguageModelSupplierClassDotName().toString() : null;
            List<ToolQualifierProvider> toolQualifierProviders = toolQualifierProviderItems.stream().map(ToolQualifierProvider.BuildItem::getProvider).toList();
            HashMap toolToQualifierMap = new HashMap();
            for (ClassInfo ci : bi.getToolClassInfos()) {
                AnnotationLiteral<?> qualifier = null;
                for (ToolQualifierProvider provider : toolQualifierProviders) {
                    if (!provider.supports(ci)) continue;
                    qualifier = provider.qualifier(ci);
                    break;
                }
                toolToQualifierMap.put(ci.name().toString(), qualifier);
            }
            String toolProviderSupplierClassName = bi.getToolProviderClassDotName() != null ? bi.getToolProviderClassDotName().toString() : null;
            String toolHallucinationStrategyClassName = null;
            if (bi.getToolHallucinationStrategyClassDotName() != null) {
                toolHallucinationStrategyClassName = bi.getToolHallucinationStrategyClassDotName().toString();
                allToolHallucinationStrategies.add(bi.getToolHallucinationStrategyClassDotName());
            }
            String chatMemoryProviderSupplierClassName = bi.getChatMemoryProviderSupplierClassDotName() != null ? bi.getChatMemoryProviderSupplierClassDotName().toString() : null;
            String retrievalAugmentorSupplierClassName = bi.getRetrievalAugmentorSupplierClassDotName() != null ? bi.getRetrievalAugmentorSupplierClassDotName().toString() : null;
            String moderationModelSupplierClassName = bi.getModerationModelSupplierDotName() != null ? bi.getModerationModelSupplierDotName().toString() : null;
            String imageModelSupplierClassName = bi.getImageModelSupplierDotName() != null ? bi.getImageModelSupplierDotName().toString() : null;
            String chatMemorySeederClassName = bi.getChatMemorySeederClassDotName() != null ? bi.getChatMemorySeederClassDotName().toString() : null;
            boolean injectStreamingChatModelBean = false;
            for (Object method2 : declarativeAiServiceClassInfo.methods()) {
                org.jboss.jandex.Type multiType;
                if (LangChain4jDotNames.TOKEN_STREAM.equals((Object)method2.returnType().name())) {
                    injectStreamingChatModelBean = true;
                    continue;
                }
                if (!DotNames.MULTI.equals((Object)method2.returnType().name())) continue;
                boolean isSupportedResponseType = false;
                if (method2.returnType().kind() == Type.Kind.PARAMETERIZED_TYPE && (DotNames.STRING.equals((Object)(multiType = (org.jboss.jandex.Type)method2.returnType().asParameterizedType().arguments().get(0)).name()) || DotNames.CHAT_EVENT.equals((Object)multiType.name()))) {
                    isSupportedResponseType = true;
                }
                if (!isSupportedResponseType) {
                    throw IllegalConfigurationException.illegalConfiguration((String)("Only Multi<String> is supported as a Multi return type. Offending method is '" + method2.declaringClass().name().toString() + "#" + method2.name() + "'"));
                }
                injectStreamingChatModelBean = true;
            }
            boolean injectModerationModelBean = false;
            method2 = declarativeAiServiceClassInfo.methods().iterator();
            while (method2.hasNext()) {
                MethodInfo method3 = (MethodInfo)method2.next();
                if (!method3.hasAnnotation(Moderate.class)) continue;
                injectModerationModelBean = true;
                break;
            }
            boolean injectImageModel = false;
            for (MethodInfo method4 : declarativeAiServiceClassInfo.methods()) {
                if (!this.isImageOrImageResultResult(method4.returnType())) continue;
                injectImageModel = true;
            }
            String chatModelName = bi.getChatModelName();
            String moderationModelName = bi.getModerationModelName();
            SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator = (SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(QuarkusAiServiceContext.class).unremovable()).forceApplicationClass()).createWith(recorder.createDeclarativeAiService(new DeclarativeAiServiceCreateInfo(serviceClassName, chatLanguageModelSupplierClassName, streamingChatLanguageModelSupplierClassName, toolToQualifierMap, toolProviderSupplierClassName, chatMemoryProviderSupplierClassName, retrievalAugmentorSupplierClassName, moderationModelSupplierClassName, imageModelSupplierClassName, chatMemorySeederClassName, chatModelName, moderationModelName, bi.getImageModelName(), injectStreamingChatModelBean, injectModerationModelBean, injectImageModel, toolHallucinationStrategyClassName, AiServicesProcessor.classInputGuardrails(bi), AiServicesProcessor.classOutputGuardrails(bi), maxSequentialToolInvocations))).setRuntimeInit().addQualifier().annotation(LangChain4jDotNames.QUARKUS_AI_SERVICE_CONTEXT_QUALIFIER).addValue("value", (Object)serviceClassName).done()).scope(Dependent.class);
            boolean bl = hasChatModelSupplier = chatLanguageModelSupplierClassName == null && streamingChatLanguageModelSupplierClassName == null;
            if (hasChatModelSupplier && !selectedChatModelProvider.isEmpty()) {
                if (NamedConfigUtil.isDefault((String)chatModelName)) {
                    configurator.addInjectionPoint((org.jboss.jandex.Type)ClassType.create((DotName)LangChain4jDotNames.CHAT_MODEL), new AnnotationInstance[0]);
                    if (injectStreamingChatModelBean) {
                        configurator.addInjectionPoint((org.jboss.jandex.Type)ClassType.create((DotName)LangChain4jDotNames.STREAMING_CHAT_MODEL), new AnnotationInstance[0]);
                        needsStreamingChatModelBean = true;
                    }
                } else {
                    configurator.addInjectionPoint((org.jboss.jandex.Type)ClassType.create((DotName)LangChain4jDotNames.CHAT_MODEL), new AnnotationInstance[]{AnnotationInstance.builder(ModelName.class).add("value", chatModelName).build()});
                    if (injectStreamingChatModelBean) {
                        configurator.addInjectionPoint((org.jboss.jandex.Type)ClassType.create((DotName)LangChain4jDotNames.STREAMING_CHAT_MODEL), new AnnotationInstance[]{AnnotationInstance.builder(ModelName.class).add("value", chatModelName).build()});
                        needsStreamingChatModelBean = true;
                    }
                }
                needsChatModelBean = true;
            }
            for (Map.Entry entry : toolToQualifierMap.entrySet()) {
                DotName dotName = DotName.createSimple((String)((String)entry.getKey()));
                AnnotationLiteral qualifier = (AnnotationLiteral)entry.getValue();
                if (qualifier == null) {
                    configurator.addInjectionPoint((org.jboss.jandex.Type)ClassType.create((DotName)dotName), new AnnotationInstance[0]);
                } else {
                    configurator.addInjectionPoint((org.jboss.jandex.Type)ClassType.create((DotName)dotName), new AnnotationInstance[]{AnnotationInstance.builder((Class)qualifier.annotationType()).build()});
                }
                allToolNames.add(dotName);
            }
            if (bi.getToolHallucinationStrategyClassDotName() != null) {
                configurator.addInjectionPoint((org.jboss.jandex.Type)ClassType.create((DotName)bi.getToolHallucinationStrategyClassDotName()), new AnnotationInstance[0]);
            }
            if (LangChain4jDotNames.BEAN_CHAT_MEMORY_PROVIDER_SUPPLIER.toString().equals(chatMemoryProviderSupplierClassName)) {
                configurator.addInjectionPoint((org.jboss.jandex.Type)ClassType.create((DotName)LangChain4jDotNames.CHAT_MEMORY_PROVIDER), new AnnotationInstance[0]);
                needsChatMemoryProviderBean = true;
            }
            if (LangChain4jDotNames.BEAN_IF_EXISTS_RETRIEVAL_AUGMENTOR_SUPPLIER.toString().equals(retrievalAugmentorSupplierClassName)) {
                configurator.addInjectionPoint((org.jboss.jandex.Type)ParameterizedType.create((DotName)DotNames.CDI_INSTANCE, (org.jboss.jandex.Type[])new org.jboss.jandex.Type[]{ClassType.create((DotName)LangChain4jDotNames.RETRIEVAL_AUGMENTOR)}, null), new AnnotationInstance[0]);
                needsRetrievalAugmentorBean = true;
            } else if (retrievalAugmentorSupplierClassName != null && bi.isCustomRetrievalAugmentorSupplierClassIsABean()) {
                configurator.addInjectionPoint((org.jboss.jandex.Type)ClassType.create((String)retrievalAugmentorSupplierClassName), new AnnotationInstance[0]);
                unremovableProducer.produce((BuildItem)UnremovableBeanBuildItem.beanClassNames((String[])new String[]{retrievalAugmentorSupplierClassName}));
            }
            if (LangChain4jDotNames.BEAN_IF_EXISTS_MODERATION_MODEL_SUPPLIER.toString().equals(moderationModelSupplierClassName) && injectModerationModelBean) {
                if (NamedConfigUtil.isDefault((String)moderationModelName)) {
                    configurator.addInjectionPoint((org.jboss.jandex.Type)ClassType.create((DotName)LangChain4jDotNames.MODERATION_MODEL), new AnnotationInstance[0]);
                } else {
                    configurator.addInjectionPoint((org.jboss.jandex.Type)ClassType.create((DotName)LangChain4jDotNames.MODERATION_MODEL), new AnnotationInstance[]{AnnotationInstance.builder(ModelName.class).add("value", moderationModelName).build()});
                }
                needsModerationModelBean = true;
            }
            if (LangChain4jDotNames.BEAN_IF_EXISTS_IMAGE_MODEL_SUPPLIER.toString().equals(imageModelSupplierClassName) && injectImageModel) {
                if (NamedConfigUtil.isDefault((String)chatModelName)) {
                    configurator.addInjectionPoint((org.jboss.jandex.Type)ClassType.create((DotName)LangChain4jDotNames.IMAGE_MODEL), new AnnotationInstance[0]);
                } else {
                    configurator.addInjectionPoint((org.jboss.jandex.Type)ClassType.create((DotName)LangChain4jDotNames.IMAGE_MODEL), new AnnotationInstance[]{AnnotationInstance.builder(ModelName.class).add("value", chatModelName).build()});
                }
                needsImageModelBean = true;
            }
            if (RegisterAiService.BeanIfExistsToolProviderSupplier.class.getName().equals(toolProviderSupplierClassName)) {
                configurator.addInjectionPoint((org.jboss.jandex.Type)ParameterizedType.create((DotName)DotNames.CDI_INSTANCE, (org.jboss.jandex.Type[])new org.jboss.jandex.Type[]{ClassType.create((DotName)LangChain4jDotNames.TOOL_PROVIDER)}, null), new AnnotationInstance[0]);
                needsToolProviderBean = true;
            } else if (!RegisterAiService.NoToolProviderSupplier.class.getName().equals(toolProviderSupplierClassName) && toolProviderSupplierClassName != null) {
                DotName toolProvider = DotName.createSimple((String)toolProviderSupplierClassName);
                configurator.addInjectionPoint((org.jboss.jandex.Type)ClassType.create((DotName)toolProvider), new AnnotationInstance[0]);
                allToolProviders.add(toolProvider);
            }
            ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)configurator.addInjectionPoint((org.jboss.jandex.Type)ParameterizedType.create((DotName)DotNames.CDI_INSTANCE, (org.jboss.jandex.Type[])new org.jboss.jandex.Type[]{ClassType.create(OutputGuardrail.class)}, null), new AnnotationInstance[0])).done();
            syntheticBeanProducer.produce((BuildItem)configurator.done());
        }
        if (needsChatModelBean) {
            unremovableProducer.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((DotName[])new DotName[]{LangChain4jDotNames.CHAT_MODEL}));
        }
        if (needsStreamingChatModelBean) {
            unremovableProducer.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((DotName[])new DotName[]{LangChain4jDotNames.STREAMING_CHAT_MODEL}));
        }
        if (needsChatMemoryProviderBean) {
            unremovableProducer.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((DotName[])new DotName[]{LangChain4jDotNames.CHAT_MEMORY_PROVIDER}));
        }
        if (needsRetrieverBean) {
            unremovableProducer.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((DotName[])new DotName[]{LangChain4jDotNames.RETRIEVER}));
        }
        if (needsRetrievalAugmentorBean) {
            unremovableProducer.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((DotName[])new DotName[]{LangChain4jDotNames.RETRIEVAL_AUGMENTOR}));
        }
        if (needsModerationModelBean) {
            unremovableProducer.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((DotName[])new DotName[]{LangChain4jDotNames.MODERATION_MODEL}));
        }
        if (needsImageModelBean) {
            unremovableProducer.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((DotName[])new DotName[]{LangChain4jDotNames.IMAGE_MODEL}));
        }
        if (needsToolProviderBean) {
            unremovableProducer.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((DotName[])new DotName[]{LangChain4jDotNames.TOOL_PROVIDER}));
        }
        if (!allToolProviders.isEmpty()) {
            unremovableProducer.produce((BuildItem)UnremovableBeanBuildItem.beanTypes(allToolProviders));
        }
        if (!allToolNames.isEmpty()) {
            unremovableProducer.produce((BuildItem)UnremovableBeanBuildItem.beanTypes(allToolNames));
        }
        if (!allToolHallucinationStrategies.isEmpty()) {
            unremovableProducer.produce((BuildItem)UnremovableBeanBuildItem.beanTypes(allToolHallucinationStrategies));
        }
    }

    @BuildStep
    public void markUsedGuardRailsUnremovable(List<AiServicesMethodBuildItem> methods, BuildProducer<UnremovableBeanBuildItem> unremovableProducer) {
        for (AiServicesMethodBuildItem method : methods) {
            ArrayList list = new ArrayList();
            method.getInputGuardrails().map(ClassProvidingAnnotationLiteral::value).map(Arrays::stream).orElseGet(() -> Stream.of(new Class[0])).map(Class::getName).forEach(list::add);
            method.getOutputGuardrails().map(ClassProvidingAnnotationLiteral::value).map(Arrays::stream).orElseGet(() -> Stream.of(new Class[0])).map(Class::getName).forEach(list::add);
            for (String cn : list) {
                unremovableProducer.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((DotName[])new DotName[]{DotName.createSimple((String)cn)}));
            }
            if (!method.getMethodInfo().hasAnnotation(DotNames.OUTPUT_GUARDRAIL_ACCUMULATOR)) continue;
            DotName name = method.getMethodInfo().annotation(DotNames.OUTPUT_GUARDRAIL_ACCUMULATOR).value().asClass().name();
            unremovableProducer.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((DotName[])new DotName[]{name}));
        }
    }

    @BuildStep
    public void markUsedResponseAugmenterUnremovable(List<AiServicesMethodBuildItem> methods, BuildProducer<UnremovableBeanBuildItem> unremovableProducer) {
        for (AiServicesMethodBuildItem method : methods) {
            String cn = method.getResponseAugmenter();
            if (cn == null) continue;
            unremovableProducer.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((DotName[])new DotName[]{DotName.createSimple((String)cn)}));
        }
    }

    public boolean detectAiServiceMethodThanNeedToBeDispatchedOnWorkerThread(MethodInfo method, List<String> associatedTools, List<ToolMethodBuildItem> tools) {
        boolean reactive = method.returnType().name().equals((Object)DotNames.UNI) || method.returnType().name().equals((Object)DotNames.COMPLETION_STAGE) || method.returnType().name().equals((Object)DotNames.MULTI);
        boolean requireSwitchToWorkerThread = false;
        if (associatedTools.isEmpty()) {
            return false;
        }
        if (!reactive) {
            return false;
        }
        for (String classname : associatedTools) {
            boolean found = false;
            for (ToolMethodBuildItem tool : tools) {
                if (!tool.getDeclaringClassName().equals(classname)) continue;
                found = true;
                if (!tool.requiresSwitchToWorkerThread()) continue;
                requireSwitchToWorkerThread = true;
                break;
            }
            if (found) continue;
            throw new RuntimeException("No tools detected in " + classname);
        }
        return requireSwitchToWorkerThread;
    }

    @BuildStep
    public void validateGuardrails(SynthesisFinishedBuildItem synthesisFinished, List<AiServicesMethodBuildItem> methods, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> errors) {
        for (AiServicesMethodBuildItem method : methods) {
            ArrayList list = new ArrayList();
            method.getInputGuardrails().map(ClassProvidingAnnotationLiteral::value).map(Arrays::stream).orElseGet(() -> Stream.of(new Class[0])).map(Class::getName).forEach(list::add);
            method.getOutputGuardrails().map(ClassProvidingAnnotationLiteral::value).map(Arrays::stream).orElseGet(() -> Stream.of(new Class[0])).map(Class::getName).forEach(list::add);
            for (String cn : list) {
                if (!synthesisFinished.beanStream().withBeanType(DotName.createSimple((String)cn)).isEmpty()) continue;
                errors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new DeploymentException("Missing guardrail bean: " + cn)}));
            }
            DotName dotName = DotName.createSimple(OutputGuardrailAccumulator.class);
            if (!method.getMethodInfo().hasAnnotation(dotName)) continue;
            DotName bean = method.getMethodInfo().annotation(dotName).value().asClass().name();
            if (synthesisFinished.beanStream().withBeanType(bean).isEmpty()) {
                errors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new DeploymentException("Missing accumulator bean: " + bean.toString())}));
            }
            DotName returnedType = method.getMethodInfo().returnType().name();
            if (!DotName.createSimple(Multi.class).equals((Object)returnedType)) {
                errors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new DeploymentException("OutputGuardrailAccumulator can only be used on method returning a " + "`Multi<X>`: found `%s` for method `%s.%s`".formatted(returnedType, method.getMethodInfo().declaringClass().toString(), method.getMethodInfo().name()))}));
            }
            if (method.hasOutputGuardrails()) continue;
            errors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new DeploymentException("OutputGuardrailAccumulator used without dev.langchain4j.service.guardrail.OutputGuardrails in method `%s.%s`".formatted(method.getMethodInfo().declaringClass().toString(), method.getMethodInfo().name()))}));
        }
    }

    @BuildStep
    public void watchResourceFiles(CombinedIndexBuildItem indexBuildItem, BuildProducer<HotDeploymentWatchedFileBuildItem> producer) {
        IndexView index = indexBuildItem.getIndex();
        ArrayList instances = new ArrayList();
        instances.addAll(index.getAnnotations(LangChain4jDotNames.SYSTEM_MESSAGE));
        instances.addAll(index.getAnnotations(LangChain4jDotNames.USER_MESSAGE));
        for (AnnotationInstance instance : instances) {
            AnnotationValue fromResource = instance.value("fromResource");
            if (fromResource == null) continue;
            producer.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(fromResource.asString()));
        }
    }

    @BuildStep
    public MethodParameterAllowedAnnotationsBuildItem markMemoryIdAsAllowedAnnotation() {
        return new MethodParameterAllowedAnnotationsBuildItem(anno -> LangChain4jDotNames.MEMORY_ID.equals((Object)anno.name()));
    }

    @BuildStep
    public void markIgnoredAnnotations(BuildProducer<MethodParameterIgnoredAnnotationsBuildItem> producer) {
        producer.produce((BuildItem)new MethodParameterIgnoredAnnotationsBuildItem(dotname -> dotname.name().toString().startsWith("kotlin")));
        producer.produce((BuildItem)new MethodParameterIgnoredAnnotationsBuildItem(dotname -> dotname.name().toString().startsWith("jakarta.validation.constraints")));
        producer.produce((BuildItem)new MethodParameterIgnoredAnnotationsBuildItem(dotname -> dotname.name().toString().endsWith("NotNull")));
        producer.produce((BuildItem)new MethodParameterIgnoredAnnotationsBuildItem(dotname -> dotname.name().toString().startsWith("io.opentelemetry")));
    }

    @BuildStep
    AnnotationsImpliesAiServiceBuildItem implyAiService() {
        return new AnnotationsImpliesAiServiceBuildItem(List.of(LangChain4jDotNames.SYSTEM_MESSAGE, LangChain4jDotNames.USER_MESSAGE, LangChain4jDotNames.MODERATE));
    }

    @BuildStep
    public void annotationTransformations(BuildProducer<AnnotationsTransformerBuildItem> producer) {
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void handleAiServices(LangChain4jBuildConfig config, AiServicesRecorder recorder, RecorderContext recorderContext, CombinedIndexBuildItem indexBuildItem, CurateOutcomeBuildItem curateOutcomeBuildItem, List<DeclarativeAiServiceBuildItem> declarativeAiServiceItems, List<MethodParameterAllowedAnnotationsBuildItem> methodParameterAllowedAnnotationsItems, List<MethodParameterIgnoredAnnotationsBuildItem> methodParameterIgnoredAnnotationsItems, BuildProducer<GeneratedClassBuildItem> generatedClassProducer, BuildProducer<GeneratedBeanBuildItem> generatedBeanProducer, BuildProducer<ReflectiveClassBuildItem> reflectiveClassProducer, BuildProducer<AiServicesMethodBuildItem> aiServicesMethodProducer, BuildProducer<AdditionalBeanBuildItem> additionalBeanProducer, BuildProducer<UnremovableBeanBuildItem> unremovableBeanProducer, Optional<MetricsCapabilityBuildItem> metricsCapability, Capabilities capabilities, List<ToolMethodBuildItem> tools, List<ToolQualifierProvider.BuildItem> toolQualifierProviderItems, List<AnnotationsImpliesAiServiceBuildItem> annotationsImpliesAiServiceItems, List<SkipOutputFormatInstructionsBuildItem> skipOutputFormatInstructionsItems, List<FallbackToDummyUserMessageBuildItem> fallbackToDummyUserMessageItems) {
        boolean addOpenTelemetrySpan;
        boolean addMicrometerMetrics;
        IndexView index = indexBuildItem.getIndex();
        ArrayList<AiServicesUseAnalyzer.Result.Entry> aiServicesAnalysisResults = new ArrayList<AiServicesUseAnalyzer.Result.Entry>();
        for (Object classInfo : index.getKnownUsers(LangChain4jDotNames.AI_SERVICES)) {
            String string = classInfo.name().toString();
            if (string.startsWith("io.quarkiverse.langchain4j") || string.startsWith("dev.langchain4j")) continue;
            try {
                InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(string.replace('.', '/') + ".class");
                try {
                    if (is == null) {
                        return;
                    }
                    ClassNode cn = new ClassNode(589824);
                    ClassReader cr = new ClassReader(is);
                    cr.accept((ClassVisitor)cn, 0);
                    for (MethodNode method : cn.methods) {
                        aiServicesAnalysisResults.addAll(AiServicesUseAnalyzer.analyze((ClassNode)cn, (MethodNode)method).entries);
                    }
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (IOException e2) {
                throw new UncheckedIOException("Reading bytecode of class '" + string + "' failed", e2);
            }
            catch (AnalyzerException e3) {
                log.debug((Object)("Unable to analyze bytecode of class '" + string + "'"), (Throwable)e3);
            }
        }
        Map<String, Boolean> nameToUsed = aiServicesAnalysisResults.stream().collect(Collectors.toMap(e -> e.createdClassName, e -> e.chatMemoryProviderUsed, (u1, u2) -> u1 != false || u2 != false));
        for (Map.Entry entry : nameToUsed.entrySet()) {
            String className = (String)entry.getKey();
            ClassInfo classInfo = index.getClassByName(className);
            if (classInfo == null || classInfo.annotations(LangChain4jDotNames.MEMORY_ID).isEmpty() || ((Boolean)entry.getValue()).booleanValue()) continue;
            log.warn((Object)("Class '" + className + "' is used in AiServices and while it leverages @MemoryId, a ChatMemoryProvider has not been configured. This will likely result in an exception being thrown when the service is used."));
        }
        HashSet<String> detectedForCreate = new HashSet<String>(nameToUsed.keySet());
        AiServicesProcessor.addCreatedAware(index, detectedForCreate);
        this.addIfacesWithMessageAnns(index, annotationsImpliesAiServiceItems.stream().flatMap(bi -> bi.getAnnotationNames().stream()).collect(Collectors.toList()), detectedForCreate);
        Set set = declarativeAiServiceItems.stream().map(bi -> bi.getServiceClassInfo().name().toString()).collect(Collectors.toUnmodifiableSet());
        detectedForCreate.addAll(set);
        HashSet<ClassInfo> ifacesForCreate = new HashSet<ClassInfo>();
        for (String className : detectedForCreate) {
            ClassInfo classInfo = index.getClassByName(className);
            if (classInfo == null) {
                log.warn((Object)("'" + className + "' used for creating an AiService was not found in the Quarkus index. Attempting to create an AiService using this class will fail"));
                continue;
            }
            if (!classInfo.isInterface()) {
                log.warn((Object)("'" + className + "' used for creating an AiService is not an interface. Attempting to create an AiService using this class will fail"));
            }
            ifacesForCreate.add(classInfo);
        }
        boolean bl = addMicrometerMetrics = metricsCapability.isPresent() && metricsCapability.get().metricsSupported("micrometer");
        if (addMicrometerMetrics) {
            additionalBeanProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(MetricsTimedWrapper.class).build());
            additionalBeanProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(MetricsCountedWrapper.class).build());
        }
        if (addOpenTelemetrySpan = capabilities.isPresent("io.quarkus.opentelemetry.tracer")) {
            additionalBeanProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(SpanWrapper.class).build());
        }
        HashMap<String, AiServiceClassCreateInfo> perClassMetadata = new HashMap<String, AiServiceClassCreateInfo>();
        if (!ifacesForCreate.isEmpty()) {
            GeneratedClassGizmoAdaptor generatedClassOutput = new GeneratedClassGizmoAdaptor(generatedClassProducer, true);
            GeneratedBeanGizmoAdaptor generatedBeanOutput = new GeneratedBeanGizmoAdaptor(generatedBeanProducer);
            for (ClassInfo iface : ifacesForCreate) {
                ArrayList allMethods = new ArrayList(iface.methods());
                JandexUtil.getAllSuperinterfaces(iface, index).stream().filter(ci -> !ci.name().equals((Object)CHAT_MEMORY_ACCESS)).forEach(ci -> allMethods.addAll(ci.methods()));
                ArrayList<MethodInfo> methodsToImplement = new ArrayList<MethodInfo>();
                HashMap<String, AiServiceMethodCreateInfo> perMethodMetadata = new HashMap<String, AiServiceMethodCreateInfo>();
                for (MethodInfo method : allMethods) {
                    short modifiers = method.flags();
                    if (Modifier.isStatic(modifiers) || Modifier.isPrivate(modifiers) || JandexUtil.isDefault(modifiers) || methodsToImplement.stream().anyMatch(m -> MethodUtil.methodSignaturesMatch(m, method))) continue;
                    methodsToImplement.add(method);
                }
                String ifaceName = iface.name().toString();
                String implClassName = ifaceName + "$$QuarkusImpl";
                boolean isRegisteredService = set.contains(ifaceName);
                ClassCreator.Builder classCreatorBuilder = ClassCreator.builder().classOutput((ClassOutput)(isRegisteredService ? generatedBeanOutput : generatedClassOutput)).className(implClassName).interfaces(new String[]{ifaceName, ChatMemoryRemovable.class.getName(), ChatMemoryAccess.class.getName()});
                if (isRegisteredService) {
                    classCreatorBuilder.interfaces(new Class[]{AutoCloseable.class});
                }
                try (ClassCreator classCreator = classCreatorBuilder.build();){
                    ResultHandle contextHandle;
                    MethodCreator mc;
                    DeclarativeAiServiceBuildItem matchingBI = null;
                    if (isRegisteredService) {
                        matchingBI = declarativeAiServiceItems.stream().filter(bi -> bi.getServiceClassInfo().equals(iface)).findFirst().orElseThrow(() -> new IllegalStateException("Unable to determine the CDI scope of " + String.valueOf(iface)));
                        DotName scopeInfo = matchingBI.getCdiScope();
                        classCreator.addAnnotation(scopeInfo.toString());
                        if (matchingBI.getBeanName().isPresent()) {
                            classCreator.addAnnotation(AnnotationInstance.builder((DotName)io.quarkus.arc.processor.DotNames.NAMED).add("value", matchingBI.getBeanName().get()).build());
                        }
                        if (matchingBI.isMakeDefaultBean()) {
                            classCreator.addAnnotation(DefaultBean.class);
                        }
                    }
                    FieldDescriptor contextField = ((FieldCreator)classCreator.getFieldCreator("context", QuarkusAiServiceContext.class).setModifiers(18)).getFieldDescriptor();
                    MethodCreator ctor = classCreator.getMethodCreator("<init>", (Object)"V", new Object[]{QuarkusAiServiceContext.class});
                    ctor.setModifiers(1);
                    ctor.addAnnotation(Inject.class);
                    ctor.getParameterAnnotations(0).addAnnotation(LangChain4jDotNames.QUARKUS_AI_SERVICE_CONTEXT_QUALIFIER.toString()).add("value", (Object)ifaceName);
                    ctor.invokeSpecialMethod(OBJECT_CONSTRUCTOR, ctor.getThis(), new ResultHandle[0]);
                    ctor.writeInstanceField(contextField, ctor.getThis(), ctor.getMethodParam(0));
                    ctor.returnValue(null);
                    MethodCreator noArgsCtor = classCreator.getMethodCreator("<init>", "V", new String[0]);
                    noArgsCtor.setModifiers(1);
                    noArgsCtor.invokeSpecialMethod(OBJECT_CONSTRUCTOR, noArgsCtor.getThis(), new ResultHandle[0]);
                    noArgsCtor.writeInstanceField(contextField, noArgsCtor.getThis(), noArgsCtor.loadNull());
                    noArgsCtor.returnValue(null);
                    for (MethodInfo methodInfo : methodsToImplement) {
                        String methodId = this.createMethodId(methodInfo);
                        Collection allowedPredicates = methodParameterAllowedAnnotationsItems.stream().map(item -> item.getPredicate()).collect(Collectors.toList());
                        Collection ignoredPredicates = methodParameterIgnoredAnnotationsItems.stream().map(item -> item.getPredicate()).collect(Collectors.toList());
                        AiServiceMethodCreateInfo methodCreateInfo = this.gatherMethodMetadata(methodInfo, index, addMicrometerMetrics, addOpenTelemetrySpan, config.responseSchema(), allowedPredicates, ignoredPredicates, tools, toolQualifierProviderItems, skipOutputFormatInstructionsItems.stream().map(SkipOutputFormatInstructionsBuildItem::getPredicate).reduce(mi -> false, Predicate::or), fallbackToDummyUserMessageItems.stream().map(FallbackToDummyUserMessageBuildItem::getPredicate).reduce(mi -> false, Predicate::or));
                        if (!methodCreateInfo.getToolClassInfo().isEmpty()) {
                            if (matchingBI != null && matchingBI.getChatMemoryProviderSupplierClassDotName() == null) {
                                throw new IllegalArgumentException("Tool usage requires chat memory. Offending AiService is '" + String.valueOf(matchingBI.getServiceClassInfo().name()) + "'");
                            }
                            ToolProcessor.warnAboutMissingDeps(curateOutcomeBuildItem, methodCreateInfo.getToolClassInfo().keySet());
                            methodCreateInfo.getToolClassInfo().keySet().stream().map(DotName::createSimple).map(xva$0 -> UnremovableBeanBuildItem.beanTypes((DotName[])new DotName[]{xva$0})).forEach(arg_0 -> unremovableBeanProducer.produce(arg_0));
                        }
                        perMethodMetadata.put(methodId, methodCreateInfo);
                        MethodCreator mc2 = classCreator.getMethodCreator(MethodDescriptor.of((MethodInfo)methodInfo));
                        for (AnnotationInstance annotationInstance : methodInfo.declaredAnnotations()) {
                            if (!this.shouldCopyAnnotation(annotationInstance, index)) continue;
                            mc2.addAnnotation(annotationInstance);
                        }
                        ResultHandle contextHandle2 = mc2.readInstanceField(contextField, mc2.getThis());
                        ResultHandle methodCreateInfoHandle = mc2.invokeStaticMethod(RECORDER_METHOD_CREATE_INFO, new ResultHandle[]{mc2.load(ifaceName), mc2.load(methodId)});
                        ResultHandle paramsHandle = mc2.newArray(Object.class, methodInfo.parametersCount());
                        for (int i = 0; i < methodInfo.parametersCount(); ++i) {
                            mc2.writeArrayValue(paramsHandle, i, mc2.getMethodParam(i));
                        }
                        ResultHandle supportHandle = this.getFromCDI(mc2, AiServiceMethodImplementationSupport.class.getName());
                        ResultHandle inputHandle = mc2.newInstance(MethodDescriptor.ofConstructor(AiServiceMethodImplementationSupport.Input.class, (Class[])new Class[]{QuarkusAiServiceContext.class, AiServiceMethodCreateInfo.class, Object[].class}), new ResultHandle[]{contextHandle2, methodCreateInfoHandle, paramsHandle});
                        ResultHandle resultHandle = mc2.invokeVirtualMethod(SUPPORT_IMPLEMENT, supportHandle, new ResultHandle[]{inputHandle});
                        mc2.returnValue(resultHandle);
                        aiServicesMethodProducer.produce((BuildItem)new AiServicesMethodBuildItem(methodInfo, methodCreateInfo.getInputGuardrails(), methodCreateInfo.getOutputGuardrails(), methodCreateInfo.getResponseAugmenterClassName(), methodCreateInfo));
                    }
                    if (isRegisteredService) {
                        mc = classCreator.getMethodCreator(MethodDescriptor.ofMethod((Object)implClassName, (String)"close", Void.TYPE, (Object[])new Object[0]));
                        mc.addAnnotation(PreDestroy.class);
                        contextHandle = mc.readInstanceField(contextField, mc.getThis());
                        mc.invokeVirtualMethod(QUARKUS_AI_SERVICES_CONTEXT_CLOSE, contextHandle, new ResultHandle[0]);
                        mc.returnVoid();
                    }
                    mc = classCreator.getMethodCreator(MethodDescriptor.ofMethod((Object)implClassName, (String)"remove", Void.TYPE, (Object[])new Object[]{Object[].class}));
                    contextHandle = mc.readInstanceField(contextField, mc.getThis());
                    mc.invokeVirtualMethod(QUARKUS_AI_SERVICES_CONTEXT_REMOVE_CHAT_MEMORY_IDS, contextHandle, new ResultHandle[]{mc.getMethodParam(0)});
                    mc.returnVoid();
                    mc = classCreator.getMethodCreator(MethodDescriptor.ofMethod((Object)implClassName, (String)"evictChatMemory", Boolean.TYPE, (Object[])new Object[]{Object.class}));
                    contextHandle = mc.readInstanceField(contextField, mc.getThis());
                    ResultHandle result = mc.invokeVirtualMethod(QUARKUS_AI_SERVICES_CONTEXT_EVICT_CHAT_MEMORY, contextHandle, new ResultHandle[]{mc.getMethodParam(0)});
                    mc.returnValue(result);
                    mc = classCreator.getMethodCreator(MethodDescriptor.ofMethod((Object)implClassName, (String)"getChatMemory", ChatMemory.class, (Object[])new Object[]{Object.class}));
                    contextHandle = mc.readInstanceField(contextField, mc.getThis());
                    result = mc.invokeVirtualMethod(QUARKUS_AI_SERVICES_CONTEXT_GET_CHAT_MEMORY, contextHandle, new ResultHandle[]{mc.getMethodParam(0)});
                    mc.returnValue(result);
                }
                Optional<DeclarativeAiServiceBuildItem> aiServiceBuildItem = declarativeAiServiceItems.stream().filter(bi -> bi.getServiceClassInfo().equals(iface)).findFirst();
                InputGuardrailsLiteral inputGuardrails = aiServiceBuildItem.map(AiServicesProcessor::classInputGuardrails).orElse(null);
                OutputGuardrailsLiteral outputGuardrails = aiServiceBuildItem.map(AiServicesProcessor::classOutputGuardrails).orElse(null);
                perClassMetadata.put(ifaceName, new AiServiceClassCreateInfo(perMethodMetadata, implClassName, inputGuardrails, outputGuardrails));
                reflectiveClassProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{implClassName}).build());
            }
        }
        ObjectSubstitutionUtil.registerJsonSchema(recorderContext);
        recorder.setMetadata(perClassMetadata);
    }

    private boolean shouldCopyAnnotation(AnnotationInstance annotationInstance, IndexView index) {
        return this.hasInterceptorBinding(annotationInstance, index);
    }

    private boolean hasInterceptorBinding(AnnotationInstance annotationInstance, IndexView index) {
        DotName annotationDotName = annotationInstance.name();
        ClassInfo annotationClassInfo = index.getClassByName(annotationDotName);
        if (annotationClassInfo != null) {
            return annotationClassInfo.declaredAnnotation(InterceptorBinding.class) != null;
        }
        try {
            Class<?> annotationClass = Class.forName(annotationDotName.toString(), false, Thread.currentThread().getContextClassLoader());
            if (annotationClass.isAnnotationPresent(InterceptorBinding.class)) {
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    private ResultHandle getFromCDI(MethodCreator mc, String className) {
        ResultHandle containerHandle = mc.invokeStaticMethod(MethodDescriptor.ofMethod(Arc.class, (String)"container", ArcContainer.class, (Class[])new Class[0]), new ResultHandle[0]);
        ResultHandle instanceHandle = mc.invokeInterfaceMethod(MethodDescriptor.ofMethod(ArcContainer.class, (String)"instance", InstanceHandle.class, (Class[])new Class[]{Class.class, Annotation[].class}), containerHandle, new ResultHandle[]{mc.loadClassFromTCCL(className), mc.newArray(Annotation.class, 0)});
        return mc.invokeInterfaceMethod(MethodDescriptor.ofMethod(InstanceHandle.class, (String)"get", Object.class, (Class[])new Class[0]), instanceHandle, new ResultHandle[0]);
    }

    private String createMethodId(MethodInfo methodInfo) {
        return methodInfo.name() + "(" + Arrays.toString(methodInfo.parameters().stream().map(mp -> mp.type().name().toString()).toArray()) + ")";
    }

    private void addIfacesWithMessageAnns(IndexView index, List<DotName> annotations, Set<String> detectedForCreate) {
        for (DotName annotation : annotations) {
            Collection instances = index.getAnnotations(annotation);
            for (AnnotationInstance instance : instances) {
                ClassInfo declaringClass;
                AnnotationTarget target = instance.target();
                AnnotationTarget.Kind kind = target.kind();
                if (kind == AnnotationTarget.Kind.METHOD) {
                    declaringClass = target.asMethod().declaringClass();
                    if (!declaringClass.isInterface()) continue;
                    detectedForCreate.add(declaringClass.name().toString());
                    continue;
                }
                if (kind != AnnotationTarget.Kind.CLASS || !(declaringClass = target.asClass()).isInterface()) continue;
                detectedForCreate.add(declaringClass.name().toString());
            }
        }
    }

    private static void addCreatedAware(IndexView index, Set<String> detectedForCreate) {
        Collection instances = index.getAnnotations(LangChain4jDotNames.CREATED_AWARE);
        for (AnnotationInstance instance : instances) {
            if (instance.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            detectedForCreate.add(instance.target().asClass().name().toString());
        }
    }

    private AiServiceMethodCreateInfo gatherMethodMetadata(MethodInfo method, IndexView index, boolean addMicrometerMetrics, boolean addOpenTelemetrySpans, boolean generateResponseSchema, Collection<Predicate<AnnotationInstance>> allowedPredicates, Collection<Predicate<AnnotationInstance>> ignoredPredicates, List<ToolMethodBuildItem> tools, List<ToolQualifierProvider.BuildItem> toolQualifierProviders, Predicate<MethodInfo> skipOutputFormatInstructionsPredicate, Predicate<MethodInfo> fallbackToDummyUserMessagePredicate) {
        this.validateReturnType(method);
        boolean requiresModeration = method.hasAnnotation(LangChain4jDotNames.MODERATE);
        Type returnType = this.javaLangReturnType(method);
        List params = method.parameters();
        String outputFormatInstructions = "";
        if (!skipOutputFormatInstructionsPredicate.test(method)) {
            Optional structuredOutputSchema = Optional.empty();
            if (!returnType.equals(Multi.class)) {
                outputFormatInstructions = SERVICE_OUTPUT_PARSER.outputFormatInstructions(returnType);
            }
        }
        List<TemplateParameterInfo> templateParams = this.gatherTemplateParamInfo(method, allowedPredicates, ignoredPredicates);
        Optional<AiServiceMethodCreateInfo.TemplateInfo> systemMessageInfo = this.gatherSystemMessageInfo(method, templateParams);
        AiServiceMethodCreateInfo.UserMessageInfo userMessageInfo = this.gatherUserMessageInfo(method, templateParams, systemMessageInfo, fallbackToDummyUserMessagePredicate);
        AiServiceMethodCreateInfo.ResponseSchemaInfo responseSchemaInfo = AiServiceMethodCreateInfo.ResponseSchemaInfo.of((boolean)generateResponseSchema, systemMessageInfo, (Optional)userMessageInfo.template(), (String)outputFormatInstructions, this.jsonSchemaFrom(returnType));
        if (!generateResponseSchema && responseSchemaInfo.isInSystemMessage()) {
            throw new RuntimeException("The %s placeholder cannot be used if the property quarkus.langchain4j.response-schema is set to false. Found in: %s".formatted(ResponseSchemaUtil.placeholder(), method.declaringClass()));
        }
        if (!generateResponseSchema && responseSchemaInfo.isInUserMessage().isPresent() && ((Boolean)responseSchemaInfo.isInUserMessage().get()).booleanValue()) {
            throw new RuntimeException("The %s placeholder cannot be used if the property quarkus.langchain4j.response-schema is set to false. Found in: %s".formatted(ResponseSchemaUtil.placeholder(), method.declaringClass()));
        }
        Optional<Integer> memoryIdParamPosition = this.gatherMemoryIdParamPosition(method);
        Optional<Integer> overrideChatModelParamPosition = this.gatherOverrideChatModelParameterPosition(method);
        Optional<AiServiceMethodCreateInfo.MetricsTimedInfo> metricsTimedInfo = this.gatherMetricsTimedInfo(method, addMicrometerMetrics);
        Optional<AiServiceMethodCreateInfo.MetricsCountedInfo> metricsCountedInfo = this.gatherMetricsCountedInfo(method, addMicrometerMetrics);
        Optional<AiServiceMethodCreateInfo.SpanInfo> spanInfo = this.gatherSpanInfo(method, addOpenTelemetrySpans);
        Map<String, AnnotationLiteral<?>> methodToolClassInfo = this.gatherMethodToolInfo(method, index, toolQualifierProviders.stream().map(ToolQualifierProvider.BuildItem::getProvider).toList());
        List<String> methodMcpClientNames = this.gatherMethodMcpClientNames(method);
        String accumulatorClassName = AiServicesMethodBuildItem.gatherAccumulator(method);
        String responseAugmenterClassName = AiServicesMethodBuildItem.gatherResponseAugmenter(method);
        boolean switchToWorkerThreadForToolExecution = this.detectIfToolExecutionRequiresAWorkerThread(method, tools, methodToolClassInfo.keySet());
        String methodReturnTypeSignature = this.returnTypeSignature(method.returnType(), new TypeArgMapper(method.declaringClass(), index));
        return new AiServiceMethodCreateInfo(method.declaringClass().name().toString(), method.name(), systemMessageInfo, userMessageInfo, memoryIdParamPosition, requiresModeration, methodReturnTypeSignature, overrideChatModelParamPosition, metricsTimedInfo, metricsCountedInfo, spanInfo, responseSchemaInfo, methodToolClassInfo, methodMcpClientNames, switchToWorkerThreadForToolExecution, accumulatorClassName, responseAugmenterClassName, AiServicesProcessor.gatherInputGuardrails(method), AiServicesProcessor.gatherOutputGuardrails(method, methodReturnTypeSignature));
    }

    private static InputGuardrailsLiteral gatherInputGuardrails(MethodInfo method) {
        return new InputGuardrailsLiteral(AiServicesProcessor.gatherGuardrails(AiServicesProcessor.getGuardrailsAnnotation(method, LangChain4jDotNames.INPUT_GUARDRAILS)));
    }

    private static OutputGuardrailsLiteral gatherOutputGuardrails(MethodInfo method, String methodReturnTypeSignature) {
        Optional<AnnotationInstance> annotationInstance = AiServicesProcessor.getGuardrailsAnnotation(method, LangChain4jDotNames.OUTPUT_GUARDRAILS);
        boolean methodReturnsMulti = TypeUtil.isMulti((Type)TypeSignatureParser.parse((String)methodReturnTypeSignature));
        Integer maxRetriesAsSetByConfig = annotationInstance.map(v -> v.value("maxRetries")).map(AnnotationValue::asInt).or(() -> ConfigProvider.getConfig().getOptionalValue("quarkus.langchain4j.guardrails.max-retries", Integer.class)).orElse(3);
        return new OutputGuardrailsLiteral(AiServicesProcessor.gatherGuardrails(annotationInstance), methodReturnsMulti ? 0 : maxRetriesAsSetByConfig, maxRetriesAsSetByConfig.intValue());
    }

    private static Optional<AnnotationInstance> getGuardrailsAnnotation(MethodInfo methodInfo, DotName annotation) {
        return Optional.ofNullable(methodInfo.annotation(annotation)).or(() -> AiServicesProcessor.getGuardrailsAnnotation(methodInfo.declaringClass(), annotation));
    }

    private static Optional<AnnotationInstance> getGuardrailsAnnotation(ClassInfo classInfo, DotName annotation) {
        return Optional.ofNullable(classInfo.declaredAnnotation(annotation));
    }

    private static Stream<org.jboss.jandex.Type> gatherGuardrailsStream(Optional<AnnotationInstance> annotation) {
        return annotation.map(AnnotationInstance::value).map(AnnotationValue::asClassArray).map(Arrays::stream).orElseGet(() -> Stream.of(new org.jboss.jandex.Type[0])).distinct();
    }

    private static List<String> gatherGuardrails(Optional<AnnotationInstance> annotation) {
        return AiServicesProcessor.gatherGuardrailsStream(annotation).map(t -> t.name().toString()).toList();
    }

    private Optional<JsonSchema> jsonSchemaFrom(Type returnType) {
        if (TypeUtil.isMulti((Type)returnType)) {
            return Optional.empty();
        }
        return JsonSchemas.jsonSchemaFrom((Type)returnType);
    }

    private boolean detectIfToolExecutionRequiresAWorkerThread(MethodInfo method, List<ToolMethodBuildItem> tools, Collection<String> methodToolClassNames) {
        AnnotationValue value;
        ArrayList<String> allTools = new ArrayList<String>(methodToolClassNames);
        AnnotationInstance annotation = method.declaringClass().annotation(LangChain4jDotNames.REGISTER_AI_SERVICES);
        if (annotation != null && (value = annotation.value("tools")) != null) {
            allTools.addAll(Arrays.stream(value.asClassArray()).map(t -> t.name().toString()).toList());
        }
        return this.detectAiServiceMethodThanNeedToBeDispatchedOnWorkerThread(method, allTools, tools);
    }

    private void validateReturnType(MethodInfo method) {
        org.jboss.jandex.Type returnType = method.returnType();
        Type.Kind returnTypeKind = returnType.kind();
        if (returnTypeKind == Type.Kind.VOID) {
            throw IllegalConfigurationException.illegalConfiguration((String)"Return type of method '%s' cannot be void", (Object[])new Object[]{method});
        }
        if (returnTypeKind != Type.Kind.CLASS && returnTypeKind != Type.Kind.PRIMITIVE && returnTypeKind != Type.Kind.PARAMETERIZED_TYPE) {
            throw IllegalConfigurationException.illegalConfiguration((String)"Unsupported type of method '%s", (Object[])new Object[]{method});
        }
    }

    private Type javaLangReturnType(MethodInfo method) {
        try {
            Class<?> declaringClass = Class.forName(method.declaringClass().name().toString(), false, Thread.currentThread().getContextClassLoader());
            ArrayList methodParamTypes = new ArrayList(method.parametersCount());
            for (org.jboss.jandex.Type methodParamType : method.parameterTypes()) {
                methodParamTypes.add(JandexUtil.load(methodParamType, Thread.currentThread().getContextClassLoader()));
            }
            return declaringClass.getDeclaredMethod(method.name(), methodParamTypes.toArray(EMPTY_CLASS_ARRAY)).getGenericReturnType();
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }

    private String returnTypeSignature(org.jboss.jandex.Type returnType, TypeArgMapper typeArgMapper) {
        return AsmUtil.getSignature(returnType, typeArgMapper);
    }

    private List<TemplateParameterInfo> gatherTemplateParamInfo(MethodInfo method, Collection<Predicate<AnnotationInstance>> allowedPredicates, Collection<Predicate<AnnotationInstance>> ignoredPredicates) {
        if (method.parameters().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TemplateParameterInfo> templateParams = new ArrayList<TemplateParameterInfo>();
        for (MethodParameterInfo param : method.parameters()) {
            AnnotationValue value;
            if (this.isParameterAllowedAsTemplateVariable(param, allowedPredicates, ignoredPredicates)) {
                templateParams.add(new TemplateParameterInfo(param.position(), param.name()));
                continue;
            }
            AnnotationInstance vInstance = param.annotation(LangChain4jDotNames.V);
            if (vInstance == null || (value = vInstance.value()) == null) continue;
            templateParams.add(new TemplateParameterInfo(param.position(), value.asString()));
        }
        if (!templateParams.isEmpty() && templateParams.stream().map(TemplateParameterInfo::name).allMatch(Objects::isNull) && !method.declaringClass().name().toString().startsWith("dev.langchain4j")) {
            log.warn((Object)"The application has been compiled without the '-parameters' being set flag on javac. Make sure your build tool is configured to pass this flag to javac, otherwise Quarkus LangChain4j is unlikely to work properly without it.");
        }
        if (templateParams.size() == 1 && method.parameters().size() == 1) {
            templateParams.add(new TemplateParameterInfo(0, "it"));
        }
        return templateParams;
    }

    private boolean isParameterAllowedAsTemplateVariable(MethodParameterInfo param, Collection<Predicate<AnnotationInstance>> allowedPredicates, Collection<Predicate<AnnotationInstance>> ignoredPredicates) {
        Collection allowances = param.annotations().stream().map(anno -> {
            String annotationName = anno.name().toString();
            if (allowedPredicates.stream().anyMatch(predicate -> predicate.test(anno))) {
                log.debugf("Annotation %s matches an allowed predicate, parameter could be used as template variable.", (Object)annotationName);
                return MethodParameterAsTemplateVariableAllowance.FORCE_ALLOW;
            }
            if (ignoredPredicates.stream().anyMatch(predicate -> predicate.test(anno))) {
                log.debugf("Annotation %s matches an ignored predicate, remaining annotations decide parameter allowance as template variable.", (Object)annotationName);
                return MethodParameterAsTemplateVariableAllowance.IGNORE;
            }
            log.debugf("Annotation %s doesn't match any predicate, parameter could not be used as template variable unless force allowed by another annotation.", (Object)annotationName);
            return MethodParameterAsTemplateVariableAllowance.OPTIONAL_DENY;
        }).collect(Collectors.toSet());
        return allowances.contains((Object)MethodParameterAsTemplateVariableAllowance.FORCE_ALLOW) || !allowances.contains((Object)MethodParameterAsTemplateVariableAllowance.OPTIONAL_DENY);
    }

    private Optional<AiServiceMethodCreateInfo.TemplateInfo> gatherSystemMessageInfo(MethodInfo method, List<TemplateParameterInfo> templateParams) {
        AnnotationInstance instance = method.annotation(LangChain4jDotNames.SYSTEM_MESSAGE);
        if (instance == null) {
            instance = method.declaringClass().declaredAnnotation(LangChain4jDotNames.SYSTEM_MESSAGE);
        }
        if (instance != null) {
            String systemMessageTemplate = TemplateUtil.getTemplateFromAnnotationInstance(instance);
            if (systemMessageTemplate.isEmpty()) {
                throw ExceptionUtil.illegalConfigurationForMethod("@SystemMessage's template parameter cannot be empty", method);
            }
            return Optional.of(AiServiceMethodCreateInfo.TemplateInfo.fromText((String)systemMessageTemplate, TemplateParameterInfo.toNameToArgsPositionMap(templateParams)));
        }
        return Optional.empty();
    }

    private Optional<Integer> gatherMemoryIdParamPosition(MethodInfo method) {
        return method.annotations(LangChain4jDotNames.MEMORY_ID).stream().filter(IS_METHOD_PARAMETER_ANNOTATION).map(METHOD_PARAMETER_POSITION_FUNCTION).findFirst();
    }

    private Optional<Integer> gatherOverrideChatModelParameterPosition(MethodInfo method) {
        Optional<Integer> result = method.annotations(LangChain4jDotNames.MODEL_NAME).stream().filter(IS_METHOD_PARAMETER_ANNOTATION).map(METHOD_PARAMETER_POSITION_FUNCTION).findFirst();
        if (result.isPresent() && !DotNames.STRING.equals((Object)((org.jboss.jandex.Type)method.parameterTypes().get(result.get())).name())) {
            throw ExceptionUtil.illegalConfigurationForMethod("Method parameters annotated with @ModelName can only be of type 'String'", method);
        }
        return result;
    }

    private AiServiceMethodCreateInfo.UserMessageInfo gatherUserMessageInfo(MethodInfo method, List<TemplateParameterInfo> templateParams, Optional<AiServiceMethodCreateInfo.TemplateInfo> systemMessageInfo, Predicate<MethodInfo> fallbackToDummyUserMesage) {
        AnnotationInstance userMessageInstance;
        Optional<Integer> pdfParamPosition;
        Optional<Integer> audioParamPosition;
        Optional<Integer> userNameParamPosition = method.annotations(LangChain4jDotNames.USER_NAME).stream().filter(IS_METHOD_PARAMETER_ANNOTATION).map(METHOD_PARAMETER_POSITION_FUNCTION).findFirst();
        Optional<Integer> imageParamPosition = AiServicesProcessor.determineImageParamPosition(method);
        if (imageParamPosition.isPresent()) {
            MethodParameterInfo imageUrlParam = (MethodParameterInfo)method.parameters().get(imageParamPosition.get());
            this.validateImageUrlParam(imageUrlParam);
        }
        if ((audioParamPosition = AiServicesProcessor.determineAudioParamPosition(method)).isPresent()) {
            MethodParameterInfo audioUrlParam = (MethodParameterInfo)method.parameters().get(audioParamPosition.get());
            this.validateAudioUrlParam(audioUrlParam);
        }
        if ((pdfParamPosition = AiServicesProcessor.determinePdfParamPosition(method)).isPresent()) {
            MethodParameterInfo pdfUrlParam = (MethodParameterInfo)method.parameters().get(pdfParamPosition.get());
            this.validatePdfUrlParam(pdfUrlParam);
        }
        if ((userMessageInstance = method.declaredAnnotation(LangChain4jDotNames.USER_MESSAGE)) != null) {
            String userMessageTemplate = TemplateUtil.getTemplateFromAnnotationInstance(userMessageInstance);
            if (userMessageTemplate.contains("{{it}}") && method.parametersCount() != 1) {
                throw ExceptionUtil.illegalConfigurationForMethod("Error: The {{it}} placeholder is present but the method does not have exactly one parameter. Please ensure that methods using the {{it}} placeholder have exactly one parameter", method);
            }
            return AiServiceMethodCreateInfo.UserMessageInfo.fromTemplate((AiServiceMethodCreateInfo.TemplateInfo)AiServiceMethodCreateInfo.TemplateInfo.fromText((String)userMessageTemplate, TemplateParameterInfo.toNameToArgsPositionMap(templateParams)), userNameParamPosition, imageParamPosition, audioParamPosition, pdfParamPosition);
        }
        Optional<AnnotationInstance> userMessageOnMethodParam = method.annotations(LangChain4jDotNames.USER_MESSAGE).stream().filter(IS_METHOD_PARAMETER_ANNOTATION).findFirst();
        if (userMessageOnMethodParam.isPresent()) {
            if (DotNames.STRING.equals((Object)userMessageOnMethodParam.get().target().asMethodParameter().type().name()) && !templateParams.isEmpty()) {
                return AiServiceMethodCreateInfo.UserMessageInfo.fromTemplate((AiServiceMethodCreateInfo.TemplateInfo)AiServiceMethodCreateInfo.TemplateInfo.fromMethodParam((Integer)Short.valueOf(userMessageOnMethodParam.get().target().asMethodParameter().position()).intValue(), TemplateParameterInfo.toNameToArgsPositionMap(templateParams)), userNameParamPosition, imageParamPosition, audioParamPosition, pdfParamPosition);
            }
            return AiServiceMethodCreateInfo.UserMessageInfo.fromMethodParam((int)userMessageOnMethodParam.get().target().asMethodParameter().position(), userNameParamPosition, imageParamPosition, audioParamPosition, pdfParamPosition);
        }
        int numOfMethodParamsUsedInSystemMessage = 0;
        if (systemMessageInfo.isPresent() && systemMessageInfo.get().text().isPresent()) {
            Set templateParamNames = TemplateUtil.parts((String)systemMessageInfo.get().text().get()).stream().flatMap(l -> l.stream().map(Expression.Part::getName)).collect(Collectors.toSet());
            for (MethodParameterInfo parameter : method.parameters()) {
                if (!templateParamNames.contains(parameter.name())) continue;
                ++numOfMethodParamsUsedInSystemMessage;
            }
        }
        if (numOfMethodParamsUsedInSystemMessage != method.parametersCount()) {
            if (method.parametersCount() == 0) {
                throw ExceptionUtil.illegalConfigurationForMethod("Method should have at least one argument", method);
            }
            if (method.parametersCount() == 1) {
                return AiServiceMethodCreateInfo.UserMessageInfo.fromMethodParam((int)0, userNameParamPosition, imageParamPosition, audioParamPosition, pdfParamPosition);
            }
            if (fallbackToDummyUserMesage.test(method)) {
                return AiServiceMethodCreateInfo.UserMessageInfo.fromTemplate((AiServiceMethodCreateInfo.TemplateInfo)AiServiceMethodCreateInfo.TemplateInfo.fromText((String)"", Map.of()), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
            }
            throw ExceptionUtil.illegalConfigurationForMethod("For methods with multiple parameters, each parameter must be annotated with @V (or match an template parameter by name), @UserMessage, @UserName or @MemoryId", method);
        }
        return new AiServiceMethodCreateInfo.UserMessageInfo(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    private static Optional<Integer> determineImageParamPosition(MethodInfo method) {
        Optional<Integer> result = method.annotations(LangChain4jDotNames.IMAGE_URL).stream().filter(IS_METHOD_PARAMETER_ANNOTATION).map(METHOD_PARAMETER_POSITION_FUNCTION).findFirst();
        if (result.isPresent()) {
            return result;
        }
        return method.parameters().stream().filter(pi -> pi.type().name().equals((Object)LangChain4jDotNames.IMAGE)).map(pi -> pi.position()).findFirst();
    }

    private static Optional<Integer> determineAudioParamPosition(MethodInfo method) {
        Optional<Integer> result = method.annotations(LangChain4jDotNames.AUDIO_URL).stream().filter(IS_METHOD_PARAMETER_ANNOTATION).map(METHOD_PARAMETER_POSITION_FUNCTION).findFirst();
        if (result.isPresent()) {
            return result;
        }
        return method.parameters().stream().filter(pi -> pi.type().name().equals((Object)LangChain4jDotNames.AUDIO)).map(pi -> pi.position()).findFirst();
    }

    private static Optional<Integer> determinePdfParamPosition(MethodInfo method) {
        Optional<Integer> result = method.annotations(LangChain4jDotNames.PDF_URL).stream().filter(IS_METHOD_PARAMETER_ANNOTATION).map(METHOD_PARAMETER_POSITION_FUNCTION).findFirst();
        if (result.isPresent()) {
            return result;
        }
        return method.parameters().stream().filter(pi -> pi.type().name().equals((Object)LangChain4jDotNames.PDF_FILE)).map(pi -> pi.position()).findFirst();
    }

    private void validateImageUrlParam(MethodParameterInfo param) {
        if (param == null) {
            throw new IllegalArgumentException("Unhandled @ImageUrl annotation");
        }
        org.jboss.jandex.Type type = param.type();
        DotName typeName = type.name();
        if (typeName.equals((Object)DotNames.STRING) || typeName.equals((Object)DotNames.URI) || typeName.equals((Object)DotNames.URL) || typeName.equals((Object)LangChain4jDotNames.IMAGE)) {
            return;
        }
        throw new IllegalArgumentException("Unhandled @ImageUrl type '" + String.valueOf(type.name()) + "'");
    }

    private void validateAudioUrlParam(MethodParameterInfo param) {
        if (param == null) {
            throw new IllegalArgumentException("Unhandled @ImageUrl annotation");
        }
        org.jboss.jandex.Type type = param.type();
        DotName typeName = type.name();
        if (typeName.equals((Object)DotNames.STRING) || typeName.equals((Object)DotNames.URI) || typeName.equals((Object)DotNames.URL) || typeName.equals((Object)LangChain4jDotNames.AUDIO)) {
            return;
        }
        throw new IllegalArgumentException("Unhandled @AudioUrl type '" + String.valueOf(type.name()) + "'");
    }

    private void validatePdfUrlParam(MethodParameterInfo param) {
        if (param == null) {
            throw new IllegalArgumentException("Unhandled @PdfUrl annotation");
        }
        org.jboss.jandex.Type type = param.type();
        DotName typeName = type.name();
        if (typeName.equals((Object)DotNames.STRING) || typeName.equals((Object)DotNames.URI) || typeName.equals((Object)DotNames.URL) || typeName.equals((Object)LangChain4jDotNames.PDF_FILE)) {
            return;
        }
        throw new IllegalArgumentException("Unhandled @PdfUrl type '" + String.valueOf(type.name()) + "'");
    }

    private Optional<AiServiceMethodCreateInfo.MetricsTimedInfo> gatherMetricsTimedInfo(MethodInfo method, boolean addMicrometerMetrics) {
        AnnotationValue descriptionValue;
        AnnotationValue histogramValue;
        AnnotationValue percentilesValue;
        String nameStr;
        if (!addMicrometerMetrics) {
            return Optional.empty();
        }
        String name = "langchain4j.aiservices.timed";
        List<String> tags = this.defaultMetricsTags(method);
        AnnotationInstance timedInstance = method.annotation(MICROMETER_TIMED);
        if (timedInstance == null) {
            timedInstance = method.declaringClass().declaredAnnotation(MICROMETER_TIMED);
        }
        if (timedInstance == null) {
            return Optional.of(new AiServiceMethodCreateInfo.MetricsTimedInfo.Builder(name).setExtraTags(tags.toArray(EMPTY_STRING_ARRAY)).build());
        }
        AnnotationValue nameValue = timedInstance.value();
        if (nameValue != null && (nameStr = nameValue.asString()) != null && !nameStr.isEmpty()) {
            name = nameStr;
        }
        AiServiceMethodCreateInfo.MetricsTimedInfo.Builder builder = new AiServiceMethodCreateInfo.MetricsTimedInfo.Builder(name);
        AnnotationValue extraTagsValue = timedInstance.value("extraTags");
        if (extraTagsValue != null) {
            tags.addAll(Arrays.asList(extraTagsValue.asStringArray()));
        }
        builder.setExtraTags(tags.toArray(EMPTY_STRING_ARRAY));
        AnnotationValue longTaskValue = timedInstance.value("longTask");
        if (longTaskValue != null) {
            builder.setLongTask(longTaskValue.asBoolean());
        }
        if ((percentilesValue = timedInstance.value("percentiles")) != null) {
            builder.setPercentiles(percentilesValue.asDoubleArray());
        }
        if ((histogramValue = timedInstance.value("histogram")) != null) {
            builder.setHistogram(histogramValue.asBoolean());
        }
        if ((descriptionValue = timedInstance.value("description")) != null) {
            builder.setDescription(descriptionValue.asString());
        }
        return Optional.of(builder.build());
    }

    private Optional<AiServiceMethodCreateInfo.MetricsCountedInfo> gatherMetricsCountedInfo(MethodInfo method, boolean addMicrometerMetrics) {
        AnnotationValue descriptionValue;
        String nameStr;
        if (!addMicrometerMetrics) {
            return Optional.empty();
        }
        String name = "langchain4j.aiservices.counted";
        List<String> tags = this.defaultMetricsTags(method);
        AnnotationInstance timedInstance = method.annotation(MICROMETER_COUNTED);
        if (timedInstance == null) {
            timedInstance = method.declaringClass().declaredAnnotation(MICROMETER_COUNTED);
        }
        if (timedInstance == null) {
            return Optional.of(new AiServiceMethodCreateInfo.MetricsCountedInfo.Builder(name).setExtraTags(tags.toArray(EMPTY_STRING_ARRAY)).build());
        }
        AnnotationValue nameValue = timedInstance.value();
        if (nameValue != null && (nameStr = nameValue.asString()) != null && !nameStr.isEmpty()) {
            name = nameStr;
        }
        AiServiceMethodCreateInfo.MetricsCountedInfo.Builder builder = new AiServiceMethodCreateInfo.MetricsCountedInfo.Builder(name);
        AnnotationValue extraTagsValue = timedInstance.value("extraTags");
        if (extraTagsValue != null) {
            tags.addAll(Arrays.asList(extraTagsValue.asStringArray()));
        }
        builder.setExtraTags(tags.toArray(EMPTY_STRING_ARRAY));
        AnnotationValue recordFailuresOnlyValue = timedInstance.value("recordFailuresOnly");
        if (recordFailuresOnlyValue != null) {
            builder.setRecordFailuresOnly(recordFailuresOnlyValue.asBoolean());
        }
        if ((descriptionValue = timedInstance.value("description")) != null) {
            builder.setDescription(descriptionValue.asString());
        }
        return Optional.of(builder.build());
    }

    private List<String> defaultMetricsTags(MethodInfo method) {
        ArrayList<String> tags = new ArrayList<String>(4);
        tags.add("aiservice");
        tags.add(method.declaringClass().name().withoutPackagePrefix());
        tags.add("method");
        tags.add(method.name());
        return tags;
    }

    private Optional<AiServiceMethodCreateInfo.SpanInfo> gatherSpanInfo(MethodInfo method, boolean addOpenTelemetrySpans) {
        if (!addOpenTelemetrySpans) {
            return Optional.empty();
        }
        String name = this.defaultAiServiceSpanName(method);
        return Optional.of(new AiServiceMethodCreateInfo.SpanInfo(name));
    }

    private Map<String, AnnotationLiteral<?>> gatherMethodToolInfo(MethodInfo method, IndexView index, List<ToolQualifierProvider> toolQualifierProviders) {
        HashMap result = new HashMap();
        for (String methodToolClassName : this.gatherMethodToolClassNames(method)) {
            ClassInfo classInfo = index.getClassByName(methodToolClassName);
            if (classInfo == null) {
                result.put(methodToolClassName, null);
                continue;
            }
            AnnotationLiteral<?> qualifier = null;
            for (ToolQualifierProvider toolQualifierProvider : toolQualifierProviders) {
                if (!toolQualifierProvider.supports(classInfo)) continue;
                qualifier = toolQualifierProvider.qualifier(classInfo);
            }
            result.put(methodToolClassName, qualifier);
        }
        return result;
    }

    private List<String> gatherMethodToolClassNames(MethodInfo method) {
        AnnotationInstance toolBoxInstance = method.declaredAnnotation(ToolBox.class);
        if (toolBoxInstance == null) {
            return Collections.emptyList();
        }
        AnnotationValue toolBoxValue = toolBoxInstance.value();
        if (toolBoxValue == null) {
            return Collections.emptyList();
        }
        org.jboss.jandex.Type[] toolClasses = toolBoxValue.asClassArray();
        if (toolClasses.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.stream(toolClasses).map(t -> t.name().toString()).collect(Collectors.toList());
    }

    private List<String> gatherMethodMcpClientNames(MethodInfo method) {
        AnnotationInstance mcpToolBoxInstance = method.declaredAnnotation(DotNames.MCP_TOOLBOX);
        if (mcpToolBoxInstance == null) {
            return null;
        }
        AnnotationValue mcpToolBoxValue = mcpToolBoxInstance.value();
        if (mcpToolBoxValue == null) {
            return Collections.emptyList();
        }
        String[] mcpClientNames = mcpToolBoxValue.asStringArray();
        if (mcpClientNames.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(mcpClientNames);
    }

    private DotName determineChatMemorySeeder(ClassInfo iface, ClassOutput classOutput) {
        List annotations = iface.annotations(LangChain4jDotNames.SEED_MEMORY);
        if (annotations.isEmpty()) {
            return null;
        }
        if (annotations.size() > 1) {
            throw new IllegalConfigurationException("Only a single @SeedMemory annotation is allowed per AiService. Offending class is '" + String.valueOf(iface.name()) + "'");
        }
        AnnotationInstance seedMemoryInstance = (AnnotationInstance)annotations.get(0);
        AnnotationTarget seedMemoryTarget = seedMemoryInstance.target();
        if (seedMemoryTarget.kind() != AnnotationTarget.Kind.METHOD) {
            throw new IllegalConfigurationException("The @SeedMemory annotation can only be placed on methods. Offending target is '" + String.valueOf(seedMemoryTarget) + "'");
        }
        return DotName.createSimple((String)this.generateAiServiceChatMemorySeeder(iface, seedMemoryTarget.asMethod(), classOutput));
    }

    private String generateAiServiceChatMemorySeeder(ClassInfo iface, MethodInfo seedMemoryTargetMethod, ClassOutput classOutput) {
        ParameterizedType parameterizedType;
        if (!Modifier.isStatic(seedMemoryTargetMethod.flags())) {
            throw new IllegalConfigurationException("The @SeedMemory annotation can only be placed on static methods. Offending method is '" + String.valueOf(seedMemoryTargetMethod.declaringClass().name()) + "#" + seedMemoryTargetMethod.name() + "'");
        }
        boolean hasListChatMessageReturnType = false;
        if (seedMemoryTargetMethod.returnType().kind() == Type.Kind.PARAMETERIZED_TYPE && DotNames.LIST.equals((Object)(parameterizedType = seedMemoryTargetMethod.returnType().asParameterizedType()).name()) && parameterizedType.arguments().size() == 1) {
            hasListChatMessageReturnType = LangChain4jDotNames.CHAT_MESSAGE.equals((Object)((org.jboss.jandex.Type)parameterizedType.arguments().get(0)).name());
        }
        if (!hasListChatMessageReturnType) {
            throw new IllegalConfigurationException("The @SeedMemory annotation can only be placed on methods that return List<ChatMessage>. Offending method is '" + String.valueOf(seedMemoryTargetMethod.declaringClass().name()) + "#" + seedMemoryTargetMethod.name() + "'");
        }
        String implClassName = String.valueOf(iface.name()) + "$$QuarkusChatMemorySeeder";
        ClassCreator.Builder classCreatorBuilder = ClassCreator.builder().classOutput(classOutput).className(implClassName).interfaces(new String[]{ChatMemorySeeder.class.getName()});
        try (ClassCreator classCreator = classCreatorBuilder.build();){
            MethodCreator methodCreator = classCreator.getMethodCreator("seed", List.class, new Class[]{ChatMemorySeeder.Context.class});
            LinkedHashMap<String, ResultHandle> seedMemoryTargetMethodParams = new LinkedHashMap<String, ResultHandle>();
            for (org.jboss.jandex.Type paramType : seedMemoryTargetMethod.parameterTypes()) {
                if (!paramType.name().equals((Object)DotNames.STRING)) {
                    throw new IllegalConfigurationException("The @SeedMemory annotation can only be placed on methods can only take parameters of type 'String' (or no parameters at all). Offending method is '" + String.valueOf(seedMemoryTargetMethod.declaringClass().name()) + "#" + seedMemoryTargetMethod.name() + "'");
                }
                ResultHandle targetMethodParamHandle = methodCreator.invokeVirtualMethod(CHAT_MEMORY_SEEDER_CONTEXT_METHOD_NAME, methodCreator.getMethodParam(0), new ResultHandle[0]);
                seedMemoryTargetMethodParams.put(paramType.name().toString(), targetMethodParamHandle);
            }
            if (seedMemoryTargetMethodParams.isEmpty()) {
                resultHandle = methodCreator.invokeStaticInterfaceMethod(MethodDescriptor.ofMethod((String)seedMemoryTargetMethod.declaringClass().name().toString(), (String)seedMemoryTargetMethod.name(), (String)seedMemoryTargetMethod.returnType().name().toString(), (String[])new String[0]), new ResultHandle[0]);
                methodCreator.returnValue(resultHandle);
            } else {
                resultHandle = methodCreator.invokeStaticInterfaceMethod(MethodDescriptor.ofMethod((String)seedMemoryTargetMethod.declaringClass().name().toString(), (String)seedMemoryTargetMethod.name(), (String)seedMemoryTargetMethod.returnType().name().toString(), (String[])seedMemoryTargetMethodParams.keySet().toArray(EMPTY_STRING_ARRAY)), seedMemoryTargetMethodParams.values().toArray(EMPTY_RESULT_HANDLES_ARRAY));
                methodCreator.returnValue(resultHandle);
            }
        }
        return implClassName;
    }

    private String defaultAiServiceSpanName(MethodInfo method) {
        return "langchain4j.aiservices." + method.declaringClass().name().withoutPackagePrefix() + "." + method.name();
    }

    private record TemplateParameterInfo(int position, String name) {
        static Map<String, Integer> toNameToArgsPositionMap(List<TemplateParameterInfo> list) {
            return list.stream().collect(Collectors.toMap(TemplateParameterInfo::name, TemplateParameterInfo::position));
        }
    }
}

