/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.deployment.devservice;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.quarkiverse.langchain4j.deployment.devservice.JdkOllamaClient;
import java.util.List;
import java.util.concurrent.Flow;

public interface OllamaClient {
    public static OllamaClient create(Options options) {
        return new JdkOllamaClient(options);
    }

    public boolean isRunning();

    public List<ModelInfo> localModels();

    public ModelInfo modelInfo(String var1);

    public Flow.Publisher<PullAsyncLine> pullAsync(String var1);

    public void preloadChatModel(String var1);

    public record Options(String host, int port) {
    }

    public static class ServerUnavailableException
    extends RuntimeException {
        public ServerUnavailableException(String host, int port) {
            super("Ollama server at [" + host + ":" + port + "] is unreachable");
        }
    }

    public static class ModelDoesNotExistException
    extends RuntimeException {
        public ModelDoesNotExistException(String model) {
            super("Model does not exist: " + model);
        }
    }

    public static class ModelNotFoundException
    extends RuntimeException {
        public ModelNotFoundException(String model) {
            super("Model not found: " + model);
        }
    }

    public record PullAsyncLine(String status, Long total, Long completed) {
    }

    public record ModelInfo(String name, @JsonProperty(value="modelfile") String modelFile, String parameters, Details details) {

        public record Details(String family, String parameterSize) {
        }
    }
}

