/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.deployment;

import io.quarkiverse.langchain4j.deployment.DotNames;
import io.quarkiverse.langchain4j.deployment.JandexUtil;
import java.util.List;
import java.util.function.Function;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;

class TypeArgMapper
implements Function<String, Type> {
    private final ClassInfo declaringClass;
    private final IndexView index;

    public TypeArgMapper(ClassInfo declaringClass, IndexView index) {
        this.declaringClass = declaringClass;
        this.index = index;
    }

    @Override
    public Type apply(String v) {
        ClassInfo declarer = this.declaringClass;
        int pos = -1;
        while (true) {
            if (declarer == null || DotNames.OBJECT.equals((Object)declarer.name())) {
                return null;
            }
            List typeParameters = declarer.typeParameters();
            for (int i = 0; i < typeParameters.size(); ++i) {
                TypeVariable tv = (TypeVariable)typeParameters.get(i);
                if (!tv.identifier().equals(v)) continue;
                pos = i;
            }
            if (pos != -1) break;
            declarer = this.index.getClassByName(declarer.superName());
        }
        Type type = JandexUtil.resolveTypeParameters(this.declaringClass.name(), declarer.name(), this.index).get(pos);
        if (type.kind() == Type.Kind.TYPE_VARIABLE && type.asTypeVariable().identifier().equals(v)) {
            List bounds = type.asTypeVariable().bounds();
            if (bounds.isEmpty()) {
                return ClassType.OBJECT_TYPE;
            }
            return (Type)bounds.get(0);
        }
        return type;
    }
}

