/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.deployment;

import dev.langchain4j.agent.tool.P;
import dev.langchain4j.agent.tool.Tool;
import dev.langchain4j.agent.tool.ToolMemoryId;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.model.chat.request.json.JsonArraySchema;
import dev.langchain4j.model.chat.request.json.JsonBooleanSchema;
import dev.langchain4j.model.chat.request.json.JsonEnumSchema;
import dev.langchain4j.model.chat.request.json.JsonIntegerSchema;
import dev.langchain4j.model.chat.request.json.JsonNumberSchema;
import dev.langchain4j.model.chat.request.json.JsonObjectSchema;
import dev.langchain4j.model.chat.request.json.JsonSchemaElement;
import dev.langchain4j.model.chat.request.json.JsonStringSchema;
import dev.langchain4j.model.output.structured.Description;
import io.quarkiverse.langchain4j.deployment.DotNames;
import io.quarkiverse.langchain4j.deployment.HashUtil;
import io.quarkiverse.langchain4j.deployment.JandexUtil;
import io.quarkiverse.langchain4j.deployment.LangChain4jDotNames;
import io.quarkiverse.langchain4j.deployment.ObjectSubstitutionUtil;
import io.quarkiverse.langchain4j.deployment.ToolsMetadataBeforeRemovalBuildItem;
import io.quarkiverse.langchain4j.deployment.ToolsMetadataBuildItem;
import io.quarkiverse.langchain4j.deployment.items.ToolMethodBuildItem;
import io.quarkiverse.langchain4j.runtime.ToolsRecorder;
import io.quarkiverse.langchain4j.runtime.prompt.Mappable;
import io.quarkiverse.langchain4j.runtime.tool.ToolInvoker;
import io.quarkiverse.langchain4j.runtime.tool.ToolMethodCreateInfo;
import io.quarkiverse.langchain4j.runtime.tool.ToolSpanWrapper;
import io.quarkiverse.langchain4j.runtime.tool.ToolSpecificationObjectSubstitution;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.execannotations.ExecutionModelAnnotationsAllowedBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.ClassTransformer;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.objectweb.asm.ClassVisitor;

public class ToolProcessor {
    private static final DotName TOOL = DotName.createSimple(Tool.class);
    private static final DotName TOOL_MEMORY_ID = DotName.createSimple(ToolMemoryId.class);
    private static final DotName P = DotName.createSimple(P.class);
    private static final DotName DESCRIPTION = DotName.createSimple(Description.class);
    private static final MethodDescriptor METHOD_METADATA_CTOR = MethodDescriptor.ofConstructor(ToolInvoker.MethodMetadata.class, (Class[])new Class[]{Boolean.TYPE, Map.class, Integer.class});
    private static final MethodDescriptor HASHMAP_CTOR = MethodDescriptor.ofConstructor(HashMap.class, (Class[])new Class[0]);
    public static final MethodDescriptor MAP_PUT = MethodDescriptor.ofMethod(Map.class, (String)"put", Object.class, (Class[])new Class[]{Object.class, Object.class});
    private static final ResultHandle[] EMPTY_RESULT_HANDLE_ARRAY = new ResultHandle[0];
    private static final Logger log = Logger.getLogger(ToolProcessor.class);

    @BuildStep
    public void telemetry(Capabilities capabilities, BuildProducer<AdditionalBeanBuildItem> additionalBeanProducer) {
        boolean addOpenTelemetrySpan = capabilities.isPresent("io.quarkus.opentelemetry.tracer");
        if (addOpenTelemetrySpan) {
            additionalBeanProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(ToolSpanWrapper.class).build());
        }
    }

    @BuildStep
    public void handleTools(BuildProducer<ToolMethodBuildItem> toolMethodBuildItemProducer, CombinedIndexBuildItem indexBuildItem, BuildProducer<AdditionalBeanBuildItem> additionalBeanProducer, BuildProducer<BytecodeTransformerBuildItem> transformerProducer, BuildProducer<GeneratedClassBuildItem> generatedClassProducer, BuildProducer<ReflectiveClassBuildItem> reflectiveClassProducer, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> validation, BuildProducer<ToolsMetadataBeforeRemovalBuildItem> toolsMetadataProducer) {
        IndexView index = indexBuildItem.getIndex();
        Collection instances = index.getAnnotations(TOOL);
        HashMap<String, List<ToolMethodCreateInfo>> metadata = new HashMap<String, List<ToolMethodCreateInfo>>();
        ArrayList<String> generatedInvokerClasses = new ArrayList<String>();
        ArrayList<String> generatedArgumentMapperClasses = new ArrayList<String>();
        HashSet<String> toolsNames = new HashSet<String>();
        if (!instances.isEmpty()) {
            GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClassProducer, true);
            HashMap<DotName, List> methodsPerClass = new HashMap<DotName, List>();
            for (AnnotationInstance instance : instances) {
                if (instance.target().kind() != AnnotationTarget.Kind.METHOD) continue;
                MethodInfo methodInfo = instance.target().asMethod();
                ClassInfo classInfo = methodInfo.declaringClass();
                boolean causeValidationError = false;
                if (classInfo.isInterface()) {
                    if (!classInfo.hasAnnotation(LangChain4jDotNames.REGISTER_AI_SERVICES) && !classInfo.hasAnnotation(DotNames.REGISTER_REST_CLIENT)) {
                        causeValidationError = true;
                    }
                } else if (Modifier.isAbstract(classInfo.flags())) {
                    causeValidationError = true;
                }
                if (causeValidationError) {
                    validation.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new IllegalStateException("@Tool is only supported on non-abstract classes, all other usages are ignored. Offending method is '" + methodInfo.declaringClass().name().toString() + "#" + methodInfo.name() + "'")}));
                    continue;
                }
                DotName declaringClassName = classInfo.name();
                methodsPerClass.computeIfAbsent(declaringClassName, n -> new ArrayList()).add(methodInfo);
            }
            boolean validationErrorFound = false;
            HashMap<String, ClassInfo> discoveredTools = new HashMap<String, ClassInfo>();
            for (Map.Entry entry : methodsPerClass.entrySet()) {
                DotName className = (DotName)entry.getKey();
                List toolMethods = (List)entry.getValue();
                ArrayList<MethodInfo> privateMethods = new ArrayList<MethodInfo>();
                for (MethodInfo toolMethod : toolMethods) {
                    if (discoveredTools.containsKey(toolMethod.name())) {
                        validation.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new IllegalStateException("A tool with the name '" + toolMethod.name() + "' from class '" + String.valueOf(className) + "' is already declared in class '" + String.valueOf(discoveredTools.get(toolMethod.name())) + "'. Tools method name must be unique.")}));
                        validationErrorFound = true;
                        continue;
                    }
                    discoveredTools.put(toolMethod.name(), toolMethod.declaringClass());
                    if (!Modifier.isPrivate(toolMethod.flags())) continue;
                    privateMethods.add(toolMethod);
                }
                if (!privateMethods.isEmpty()) {
                    transformerProducer.produce((BuildItem)new BytecodeTransformerBuildItem(className.toString(), (BiFunction)new RemovePrivateFromMethodsVisitor(privateMethods)));
                }
                if (validationErrorFound) {
                    return;
                }
                for (MethodInfo toolMethod : toolMethods) {
                    AnnotationInstance instance = toolMethod.annotation(TOOL);
                    boolean ignoreToolMethod = this.ignoreToolMethod(toolMethod, index);
                    if (ignoreToolMethod) continue;
                    if (LangChain4jDotNames.WEB_SEARCH_TOOL.equals((Object)className)) {
                        additionalBeanProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(className.toString()).setUnremovable().build());
                    }
                    AnnotationValue nameValue = instance.value("name");
                    AnnotationValue descriptionValue = instance.value();
                    String toolName = ToolProcessor.getToolName(nameValue, toolMethod);
                    String toolDescription = this.getToolDescription(descriptionValue);
                    ToolSpecification.Builder builder = ToolSpecification.builder().name(toolName).description(toolDescription);
                    LinkedHashMap<String, JsonSchemaElement> properties = new LinkedHashMap<String, JsonSchemaElement>(toolMethod.parametersCount());
                    ArrayList<String> required = new ArrayList<String>(toolMethod.parametersCount());
                    MethodParameterInfo memoryIdParameter = null;
                    for (MethodParameterInfo parameter : toolMethod.parameters()) {
                        if (parameter.hasAnnotation(TOOL_MEMORY_ID)) {
                            memoryIdParameter = parameter;
                            continue;
                        }
                        AnnotationInstance pInstance = parameter.annotation(P);
                        JsonSchemaElement jsonSchemaElement = this.toJsonSchemaElement(parameter, index);
                        properties.put(parameter.name(), jsonSchemaElement);
                        if (pInstance != null && (pInstance.value("required") == null || !pInstance.value("required").asBoolean())) continue;
                        required.add(parameter.name());
                    }
                    builder.parameters(JsonObjectSchema.builder().properties(properties).required(required).build());
                    Map<String, Integer> nameToParamPosition = toolMethod.parameters().stream().collect(Collectors.toMap(MethodParameterInfo::name, i -> i.position()));
                    String methodSignature = ToolProcessor.createUniqueSignature(toolMethod);
                    String invokerClassName = ToolProcessor.generateInvoker(toolMethod, (ClassOutput)classOutput, nameToParamPosition, memoryIdParameter != null ? Short.valueOf(memoryIdParameter.position()) : null, methodSignature);
                    generatedInvokerClasses.add(invokerClassName);
                    String argumentMapperClassName = this.generateArgumentMapper(toolMethod, (ClassOutput)classOutput, methodSignature);
                    generatedArgumentMapperClasses.add(argumentMapperClassName);
                    ToolSpecification toolSpecification = builder.build();
                    ToolMethodCreateInfo methodCreateInfo = new ToolMethodCreateInfo(toolMethod.name(), invokerClassName, toolSpecification, argumentMapperClassName, this.determineExecutionModel(toolMethod));
                    this.validateExecutionModel(methodCreateInfo, toolMethod, validation);
                    if (toolsNames.add(toolName)) {
                        toolMethodBuildItemProducer.produce((BuildItem)new ToolMethodBuildItem(toolMethod, methodCreateInfo));
                    } else {
                        validation.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new IllegalStateException("A tool with the name '" + toolName + "' is already declared. Tools method name must be unique.")}));
                    }
                    metadata.computeIfAbsent(className.toString(), c -> new ArrayList()).add(methodCreateInfo);
                }
            }
        }
        if (!generatedInvokerClasses.isEmpty()) {
            reflectiveClassProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])((String[])generatedInvokerClasses.toArray(String[]::new))).constructors(true).build());
        }
        if (!generatedArgumentMapperClasses.isEmpty()) {
            reflectiveClassProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])((String[])generatedArgumentMapperClasses.toArray(String[]::new))).fields(true).constructors(true).build());
        }
        toolsMetadataProducer.produce((BuildItem)new ToolsMetadataBeforeRemovalBuildItem(metadata));
    }

    @BuildStep
    ExecutionModelAnnotationsAllowedBuildItem toolsMethods() {
        return new ExecutionModelAnnotationsAllowedBuildItem((Predicate)new Predicate<MethodInfo>(){

            @Override
            public boolean test(MethodInfo method) {
                return method.hasDeclaredAnnotation(DotNames.TOOL);
            }
        });
    }

    private void validateExecutionModel(ToolMethodCreateInfo methodCreateInfo, MethodInfo toolMethod, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> validation) {
        String methodName = String.valueOf(toolMethod.declaringClass().name()) + "." + toolMethod.name();
        if (DotNames.MULTI.equals((Object)toolMethod.returnType().name())) {
            validation.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new Exception("Method " + methodName + " returns Multi, which is not supported for tools")}));
        }
        if (methodCreateInfo.executionModel() == ToolMethodCreateInfo.ExecutionModel.VIRTUAL_THREAD) {
            if (DotNames.UNI.equals((Object)toolMethod.returnType().name())) {
                validation.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new Exception("Method " + methodName + " returns Uni, which is not supported with @RunOnVirtualThread for tools")}));
            }
            if (DotNames.COMPLETION_STAGE.equals((Object)toolMethod.returnType().name())) {
                validation.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new Exception("Method " + methodName + " returns CompletionStage, which is not supported with @RunOnVirtualThread for tools")}));
            }
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public ToolsMetadataBuildItem filterOutRemovedTools(ToolsMetadataBeforeRemovalBuildItem beforeRemoval, ValidationPhaseBuildItem validationPhase, RecorderContext recorderContext, ToolsRecorder recorder) {
        if (beforeRemoval != null) {
            recorderContext.registerSubstitution(ToolSpecification.class, ToolSpecificationObjectSubstitution.Serialized.class, ToolSpecificationObjectSubstitution.class);
            ObjectSubstitutionUtil.registerJsonSchema(recorderContext);
            Map<String, List<ToolMethodCreateInfo>> metadataWithoutRemovedBeans = beforeRemoval.getMetadata().entrySet().stream().filter(entry -> validationPhase.getContext().removedBeans().stream().noneMatch(retainedBean -> DotName.createSimple((String)((String)entry.getKey())).equals((Object)retainedBean.getBeanClass()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            ToolsMetadataBuildItem toolsMetadata = new ToolsMetadataBuildItem(metadataWithoutRemovedBeans);
            recorder.setMetadata(toolsMetadata.getMetadata());
            log.debug((Object)("Tool classes before filtering out removed beans: " + String.valueOf(beforeRemoval.getMetadata().keySet())));
            log.debug((Object)("Tool classes after filtering out removed beans: " + String.valueOf(toolsMetadata.getMetadata().keySet())));
            return toolsMetadata;
        }
        return null;
    }

    private boolean ignoreToolMethod(MethodInfo toolMethod, IndexView indexView) {
        ClassInfo declaringClass = toolMethod.declaringClass();
        if (LangChain4jDotNames.WEB_SEARCH_TOOL.equals((Object)declaringClass.name()) && indexView.getAllKnownImplementors(LangChain4jDotNames.WEB_SEARCH_ENGINE).isEmpty()) {
            log.debug((Object)("Ignoring tool " + String.valueOf(LangChain4jDotNames.WEB_SEARCH_TOOL) + "#" + toolMethod.name() + " as there is no implementation of " + String.valueOf(LangChain4jDotNames.WEB_SEARCH_ENGINE) + " on the classpath"));
            return true;
        }
        return false;
    }

    private static String createUniqueSignature(MethodInfo toolMethod) {
        StringBuilder sigBuilder = new StringBuilder();
        sigBuilder.append(toolMethod.name()).append(toolMethod.returnType().name().toString());
        for (MethodParameterInfo t : toolMethod.parameters()) {
            sigBuilder.append(t.type().name().toString());
        }
        return sigBuilder.toString();
    }

    private static String getToolName(AnnotationValue nameValue, MethodInfo methodInfo) {
        if (nameValue == null) {
            return methodInfo.name();
        }
        String annotationValue = nameValue.asString();
        if (annotationValue.isEmpty()) {
            return methodInfo.name();
        }
        return annotationValue;
    }

    private String getToolDescription(AnnotationValue descriptionValue) {
        if (descriptionValue == null) {
            return "";
        }
        return String.join((CharSequence)"\n", descriptionValue.asStringArray());
    }

    private static String generateInvoker(MethodInfo methodInfo, ClassOutput classOutput, Map<String, Integer> nameToParamPosition, Short memoryIdParamPosition, String methodSignature) {
        String implClassName = String.valueOf(methodInfo.declaringClass().name()) + "$$QuarkusInvoker$" + methodInfo.name() + "_" + HashUtil.sha1(methodSignature);
        try (ClassCreator classCreator = ClassCreator.builder().classOutput(classOutput).className(implClassName).interfaces(new Class[]{ToolInvoker.class}).build();){
            boolean toolReturnsVoid;
            MethodCreator invokeMc = classCreator.getMethodCreator(MethodDescriptor.ofMethod((Object)implClassName, (String)"invoke", Object.class, (Object[])new Object[]{Object.class, Object[].class}));
            ResultHandle[] targetMethodHandles = EMPTY_RESULT_HANDLE_ARRAY;
            if (methodInfo.parametersCount() > 0) {
                ArrayList<ResultHandle> argumentHandles = new ArrayList<ResultHandle>(methodInfo.parametersCount());
                for (int i = 0; i < methodInfo.parametersCount(); ++i) {
                    argumentHandles.add(invokeMc.readArrayValue(invokeMc.getMethodParam(1), i));
                }
                targetMethodHandles = argumentHandles.toArray(EMPTY_RESULT_HANDLE_ARRAY);
            }
            ResultHandle result = methodInfo.declaringClass().isInterface() ? invokeMc.invokeInterfaceMethod(MethodDescriptor.of((MethodInfo)methodInfo), invokeMc.getMethodParam(0), targetMethodHandles) : invokeMc.invokeVirtualMethod(MethodDescriptor.of((MethodInfo)methodInfo), invokeMc.getMethodParam(0), targetMethodHandles);
            boolean bl = toolReturnsVoid = methodInfo.returnType().kind() == Type.Kind.VOID;
            if (toolReturnsVoid) {
                invokeMc.returnValue(invokeMc.load("Success"));
            } else {
                invokeMc.returnValue(result);
            }
            MethodCreator methodMetadataMc = classCreator.getMethodCreator(MethodDescriptor.ofMethod((Object)implClassName, (String)"methodMetadata", ToolInvoker.MethodMetadata.class, (Object[])new Object[0]));
            ResultHandle nameToParamPositionHandle = methodMetadataMc.newInstance(HASHMAP_CTOR, new ResultHandle[0]);
            for (Map.Entry<String, Integer> entry : nameToParamPosition.entrySet()) {
                methodMetadataMc.invokeInterfaceMethod(MAP_PUT, nameToParamPositionHandle, new ResultHandle[]{methodMetadataMc.load(entry.getKey()), methodMetadataMc.load(entry.getValue().intValue())});
            }
            ResultHandle resultHandle = methodMetadataMc.newInstance(METHOD_METADATA_CTOR, new ResultHandle[]{methodMetadataMc.load(toolReturnsVoid), nameToParamPositionHandle, memoryIdParamPosition != null ? methodMetadataMc.load(Integer.valueOf(memoryIdParamPosition.shortValue()).intValue()) : methodMetadataMc.loadNull()});
            methodMetadataMc.returnValue(resultHandle);
        }
        return implClassName;
    }

    private String generateArgumentMapper(MethodInfo methodInfo, ClassOutput classOutput, String methodSignature) {
        String implClassName = String.valueOf(methodInfo.declaringClass().name()) + "$$QuarkusToolArgumentMapper$" + methodInfo.name() + "_" + HashUtil.sha1(methodSignature);
        try (ClassCreator classCreator = ClassCreator.builder().classOutput(classOutput).className(implClassName).interfaces(new Class[]{Mappable.class}).build();){
            ArrayList<FieldDescriptor> fieldDescriptors = new ArrayList<FieldDescriptor>();
            for (MethodParameterInfo parameter : methodInfo.parameters()) {
                FieldDescriptor fieldDescriptor = FieldDescriptor.of((String)implClassName, (String)parameter.name(), (String)parameter.type().name().toString());
                fieldDescriptors.add(fieldDescriptor);
                classCreator.getFieldCreator(fieldDescriptor).setModifiers(1);
            }
            MethodCreator mc = classCreator.getMethodCreator(MethodDescriptor.ofMethod((Object)implClassName, (String)"obtainFieldValuesMap", Map.class, (Object[])new Object[0]));
            ResultHandle mapHandle = mc.newInstance(MethodDescriptor.ofConstructor(HashMap.class, (Class[])new Class[0]), new ResultHandle[0]);
            for (FieldDescriptor field : fieldDescriptors) {
                ResultHandle fieldValue = mc.readInstanceField(field, mc.getThis());
                mc.invokeInterfaceMethod(MAP_PUT, mapHandle, new ResultHandle[]{mc.load(field.getName()), fieldValue});
            }
            mc.returnValue(mapHandle);
        }
        return implClassName;
    }

    private JsonSchemaElement toJsonSchemaElement(MethodParameterInfo parameter, IndexView index) {
        Type type = parameter.type();
        String description = ToolProcessor.descriptionFrom(parameter);
        return this.toJsonSchemaElement(type, index, description);
    }

    private JsonSchemaElement toJsonSchemaElement(Type type, IndexView index, String description) {
        DotName typeName = type.name();
        if (type.kind() == Type.Kind.WILDCARD_TYPE) {
            Type boundType = type.asWildcardType().extendsBound();
            if (boundType == null) {
                boundType = type.asWildcardType().superBound();
            }
            if (boundType != null) {
                return this.toJsonSchemaElement(boundType, index, description);
            }
            throw new IllegalArgumentException("Unsupported wildcard type with no bounds: " + String.valueOf(type));
        }
        if (DotNames.STRING.equals((Object)typeName) || DotNames.CHARACTER.equals((Object)typeName) || DotNames.PRIMITIVE_CHAR.equals((Object)typeName)) {
            return JsonStringSchema.builder().description(description).build();
        }
        if (DotNames.BOOLEAN.equals((Object)typeName) || DotNames.PRIMITIVE_BOOLEAN.equals((Object)typeName)) {
            return JsonBooleanSchema.builder().description(description).build();
        }
        if (DotNames.BYTE.equals((Object)typeName) || DotNames.PRIMITIVE_BYTE.equals((Object)typeName) || DotNames.SHORT.equals((Object)typeName) || DotNames.PRIMITIVE_SHORT.equals((Object)typeName) || DotNames.INTEGER.equals((Object)typeName) || DotNames.PRIMITIVE_INT.equals((Object)typeName) || DotNames.LONG.equals((Object)typeName) || DotNames.PRIMITIVE_LONG.equals((Object)typeName) || DotNames.BIG_INTEGER.equals((Object)typeName)) {
            return JsonIntegerSchema.builder().description(description).build();
        }
        if (DotNames.FLOAT.equals((Object)typeName) || DotNames.PRIMITIVE_FLOAT.equals((Object)typeName) || DotNames.DOUBLE.equals((Object)typeName) || DotNames.PRIMITIVE_DOUBLE.equals((Object)typeName) || DotNames.BIG_DECIMAL.equals((Object)typeName)) {
            return JsonNumberSchema.builder().description(description).build();
        }
        if (type.kind() == Type.Kind.ARRAY || DotNames.LIST.equals((Object)typeName) || DotNames.SET.equals((Object)typeName)) {
            ParameterizedType parameterizedType = type.kind() == Type.Kind.PARAMETERIZED_TYPE ? type.asParameterizedType() : null;
            Type elementType = parameterizedType != null ? (Type)parameterizedType.arguments().get(0) : type.asArrayType().component();
            JsonSchemaElement element = this.toJsonSchemaElement(elementType, index, null);
            return JsonArraySchema.builder().description(description).items(element).build();
        }
        if (this.isEnum(type, index)) {
            List<String> enums = Arrays.stream(ToolProcessor.enumConstants(type)).filter(e -> e.getClass().isEnum()).map(e -> ((Enum)e).name()).toList();
            return JsonEnumSchema.builder().enumValues(enums).description(Optional.ofNullable(description).orElseGet(() -> ToolProcessor.descriptionFrom(type))).build();
        }
        if (this.isComplexType(type)) {
            JsonObjectSchema.Builder builder = JsonObjectSchema.builder().description(Optional.ofNullable(description).orElseGet(() -> ToolProcessor.descriptionFrom(type)));
            Optional.ofNullable(index.getClassByName(type.name())).map(ClassInfo::fields).orElseGet(List::of).forEach(field -> {
                String fieldName = field.name();
                Type fieldType = field.type();
                String fieldDescription = ToolProcessor.descriptionFrom(field);
                JsonSchemaElement fieldSchema = this.toJsonSchemaElement(fieldType, index, fieldDescription);
                builder.addProperty(fieldName, fieldSchema);
            });
            return builder.build();
        }
        throw new IllegalArgumentException("Unsupported type: " + String.valueOf(type));
    }

    private boolean isComplexType(Type type) {
        return type.kind() == Type.Kind.CLASS || type.kind() == Type.Kind.PARAMETERIZED_TYPE;
    }

    private boolean isEnum(Type returnType, IndexView index) {
        if (returnType.kind() != Type.Kind.CLASS) {
            return false;
        }
        ClassInfo maybeEnum = index.getClassByName(returnType.name());
        return maybeEnum != null && maybeEnum.isEnum();
    }

    private static String descriptionFrom(String[] description) {
        return description != null ? String.join((CharSequence)" ", description) : null;
    }

    private static String descriptionFrom(Type type) {
        return Optional.ofNullable(type.annotation(DESCRIPTION)).map(annotationInstance -> ToolProcessor.descriptionFrom(annotationInstance.value().asStringArray())).orElse(null);
    }

    private static String descriptionFrom(FieldInfo field) {
        return Optional.ofNullable(field.annotation(DESCRIPTION)).map(annotationInstance -> ToolProcessor.descriptionFrom(annotationInstance.value().asStringArray())).orElse(null);
    }

    private static String descriptionFrom(MethodParameterInfo parameter) {
        return Optional.ofNullable(parameter.annotation(P)).map(p -> p.value().asString()).orElse(null);
    }

    private static Object[] enumConstants(Type type) {
        return JandexUtil.load(type, Thread.currentThread().getContextClassLoader()).getEnumConstants();
    }

    private ToolMethodCreateInfo.ExecutionModel determineExecutionModel(MethodInfo methodInfo) {
        if (methodInfo.hasAnnotation(DotNames.BLOCKING)) {
            return ToolMethodCreateInfo.ExecutionModel.BLOCKING;
        }
        Type returnedType = methodInfo.returnType();
        if (methodInfo.hasAnnotation(DotNames.NON_BLOCKING) || DotNames.UNI.equals((Object)returnedType.name()) || DotNames.COMPLETION_STAGE.equals((Object)returnedType.name()) || DotNames.MULTI.equals((Object)returnedType.name())) {
            return ToolMethodCreateInfo.ExecutionModel.NON_BLOCKING;
        }
        if (methodInfo.hasAnnotation(DotNames.RUN_ON_VIRTUAL_THREAD)) {
            return ToolMethodCreateInfo.ExecutionModel.VIRTUAL_THREAD;
        }
        return ToolMethodCreateInfo.ExecutionModel.BLOCKING;
    }

    private static class RemovePrivateFromMethodsVisitor
    implements BiFunction<String, ClassVisitor, ClassVisitor> {
        private final List<MethodInfo> privateMethods;

        private RemovePrivateFromMethodsVisitor(List<MethodInfo> privateMethods) {
            this.privateMethods = privateMethods;
        }

        @Override
        public ClassVisitor apply(String className, ClassVisitor classVisitor) {
            ClassTransformer transformer = new ClassTransformer(className);
            for (MethodInfo method : this.privateMethods) {
                transformer.modifyMethod(MethodDescriptor.of((MethodInfo)method)).removeModifiers(2);
            }
            return transformer.applyTo(classVisitor);
        }
    }
}

