/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.deployment;

import io.quarkiverse.langchain4j.QuarkusPromptTemplateFactory;
import io.quarkus.qute.Engine;
import io.quarkus.qute.Expression;
import io.quarkus.qute.ParserHook;
import io.quarkus.qute.Template;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;

public class TemplateUtil {
    static List<List<Expression.Part>> parts(String templateStr) {
        Template template = Holder.ENGINE.parse(templateStr);
        List expressions = template.getExpressions();
        if (expressions.isEmpty()) {
            return Collections.emptyList();
        }
        return expressions.stream().map(Expression::getParts).collect(Collectors.toList());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getTemplateFromAnnotationInstance(AnnotationInstance instance) {
        if (instance == null) {
            return "";
        }
        AnnotationValue fromResourceValue = instance.value("fromResource");
        if (fromResourceValue != null) {
            Object fromResource = fromResourceValue.asString();
            if (!((String)fromResource).startsWith("/")) {
                fromResource = "/" + (String)fromResource;
            }
            try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream((String)fromResource);){
                if (is == null) throw new FileNotFoundException("Resource not found: " + (String)fromResource);
                String string = new String(is.readAllBytes());
                return string;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        AnnotationValue valueValue = instance.value();
        if (valueValue == null) return "";
        AnnotationValue delimiterValue = instance.value("delimiter");
        String delimiter = delimiterValue != null ? delimiterValue.asString() : "\n";
        return String.join((CharSequence)delimiter, valueValue.asStringArray());
    }

    private static class Holder {
        private static final Engine ENGINE = Engine.builder().addDefaults().addParserHook((ParserHook)new QuarkusPromptTemplateFactory.MustacheTemplateVariableStyleParserHook()).build();

        private Holder() {
        }
    }
}

