/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.deployment;

import io.quarkiverse.langchain4j.deployment.DotNames;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.jandex.ArrayType;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;
import org.jboss.logging.Logger;

class JandexUtil {
    private static final Logger log = Logger.getLogger(JandexUtil.class);

    JandexUtil() {
    }

    static Collection<ClassInfo> getAllSuperinterfaces(ClassInfo interfaceName, IndexView index) {
        HashSet<ClassInfo> result = new HashSet<ClassInfo>();
        ArrayDeque<DotName> workQueue = new ArrayDeque<DotName>();
        HashSet<DotName> alreadyProcessed = new HashSet<DotName>();
        workQueue.add(interfaceName.name());
        while (!workQueue.isEmpty()) {
            DotName iface = (DotName)workQueue.remove();
            if (!alreadyProcessed.add(iface)) continue;
            ArrayList<ClassInfo> directSuperInterfaces = new ArrayList<ClassInfo>();
            for (DotName name : interfaceName.interfaceNames()) {
                ClassInfo classInfo = index.getClassByName(name);
                if (classInfo == null) {
                    log.warn((Object)("'" + String.valueOf(name) + "' used for creating an AiService is not an interface. Attempting to create an AiService using this class will fail"));
                }
                directSuperInterfaces.add(classInfo);
            }
            for (ClassInfo directSubInterface : directSuperInterfaces) {
                result.add(directSubInterface);
                workQueue.add(directSubInterface.name());
            }
        }
        return result;
    }

    static boolean isDefault(short flags) {
        return (flags & 0x409) == 1;
    }

    static Class<?> load(Type type, ClassLoader classLoader) {
        if (type.kind() == Type.Kind.PRIMITIVE) {
            PrimitiveType prim = type.asPrimitiveType();
            switch (prim.primitive()) {
                case INT: {
                    return Integer.TYPE;
                }
                case BYTE: {
                    return Byte.TYPE;
                }
                case CHAR: {
                    return Character.TYPE;
                }
                case LONG: {
                    return Long.TYPE;
                }
                case FLOAT: {
                    return Float.TYPE;
                }
                case SHORT: {
                    return Short.TYPE;
                }
                case DOUBLE: {
                    return Double.TYPE;
                }
                case BOOLEAN: {
                    return Boolean.TYPE;
                }
            }
            throw new RuntimeException("Unknown type " + String.valueOf(prim.primitive()));
        }
        try {
            return Class.forName(type.name().toString(), false, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    static List<Type> resolveTypeParameters(DotName input, DotName target, IndexView index) {
        ClassInfo inputClassInfo = JandexUtil.fetchFromIndex(input, index);
        Type startingType = JandexUtil.getType(inputClassInfo, index);
        List<Type> result = JandexUtil.findParametersRecursively(startingType, target, new HashSet<DotName>(), index);
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    private static Type getType(ClassInfo inputClassInfo, IndexView index) {
        List typeParameters = inputClassInfo.typeParameters();
        if (typeParameters.isEmpty()) {
            return ClassType.create((DotName)inputClassInfo.name(), (Type.Kind)Type.Kind.CLASS);
        }
        Type owner = null;
        if (inputClassInfo.enclosingClass() != null && !Modifier.isStatic(inputClassInfo.flags())) {
            owner = JandexUtil.getType(JandexUtil.fetchFromIndex(inputClassInfo.enclosingClass(), index), index);
        }
        return ParameterizedType.create((DotName)inputClassInfo.name(), (Type[])typeParameters.toArray(new Type[0]), owner);
    }

    private static List<Type> findParametersRecursively(Type type, DotName target, Set<DotName> visitedTypes, IndexView index) {
        DotName name = type.name();
        if (!visitedTypes.add(name)) {
            return null;
        }
        if (DotNames.OBJECT.equals((Object)name) || DotNames.RECORD.equals((Object)name)) {
            return null;
        }
        ClassInfo inputClassInfo = JandexUtil.fetchFromIndex(name, index);
        if (target.equals((Object)name)) {
            Type thisType = JandexUtil.getType(inputClassInfo, index);
            if (thisType.kind() == Type.Kind.CLASS) {
                return Collections.emptyList();
            }
            return thisType.asParameterizedType().arguments();
        }
        Type superClassType = inputClassInfo.superClassType();
        List<Type> superResult = JandexUtil.findParametersRecursively(superClassType, target, visitedTypes, index);
        if (superResult != null) {
            return JandexUtil.mapTypeArguments(superClassType, superResult, index);
        }
        for (Type interfaceType : inputClassInfo.interfaceTypes()) {
            List<Type> ret = JandexUtil.findParametersRecursively(interfaceType, target, visitedTypes, index);
            if (ret == null) continue;
            return JandexUtil.mapTypeArguments(interfaceType, ret, index);
        }
        return null;
    }

    private static List<Type> mapTypeArguments(Type appliedType, List<Type> typeArgumentsFromSupertype, IndexView index) {
        ArrayList<Type> appliedArguments;
        if (typeArgumentsFromSupertype.isEmpty()) {
            return typeArgumentsFromSupertype;
        }
        if (!JandexUtil.containsTypeParameters(typeArgumentsFromSupertype)) {
            return typeArgumentsFromSupertype;
        }
        ClassInfo superType = JandexUtil.fetchFromIndex(appliedType.name(), index);
        if (superType.typeParameters().isEmpty()) {
            return typeArgumentsFromSupertype;
        }
        if (appliedType.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            appliedArguments = appliedType.asParameterizedType().arguments();
        } else {
            appliedArguments = new ArrayList<Type>(superType.typeParameters().size());
            for (TypeVariable typeVariable : superType.typeParameters()) {
                if (!typeVariable.bounds().isEmpty()) {
                    appliedArguments.add((Type)typeVariable.bounds().get(0));
                    continue;
                }
                appliedArguments.add(ClassType.create((DotName)DotNames.OBJECT, (Type.Kind)Type.Kind.CLASS));
            }
        }
        if (appliedArguments.size() != superType.typeParameters().size()) {
            throw new IllegalArgumentException("Our supertype instance " + String.valueOf(appliedType) + " does not match supertype declared arguments: " + String.valueOf(superType.typeParameters()));
        }
        HashMap<String, Type> mapping = new HashMap<String, Type>();
        for (int i = 0; i < superType.typeParameters().size(); ++i) {
            TypeVariable typeParameter = (TypeVariable)superType.typeParameters().get(i);
            mapping.put(typeParameter.identifier(), (Type)appliedArguments.get(i));
        }
        return JandexUtil.mapGenerics(typeArgumentsFromSupertype, mapping);
    }

    private static boolean containsTypeParameters(List<Type> typeArgumentsFromSupertype) {
        for (Type type : typeArgumentsFromSupertype) {
            if (!JandexUtil.containsTypeParameters(type)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsTypeParameters(Type type) {
        switch (type.kind()) {
            case ARRAY: {
                return JandexUtil.containsTypeParameters(type.asArrayType().constituent());
            }
            case PARAMETERIZED_TYPE: {
                ParameterizedType parameterizedType = type.asParameterizedType();
                if (parameterizedType.owner() != null && JandexUtil.containsTypeParameters(parameterizedType.owner())) {
                    return true;
                }
                return JandexUtil.containsTypeParameters(parameterizedType.arguments());
            }
            case TYPE_VARIABLE: {
                return true;
            }
        }
        return false;
    }

    private static List<Type> mapGenerics(List<Type> types, Map<String, Type> mapping) {
        ArrayList<Type> ret = new ArrayList<Type>(types.size());
        for (Type type : types) {
            ret.add(JandexUtil.mapGenerics(type, mapping));
        }
        return ret;
    }

    private static Type mapGenerics(Type type, Map<String, Type> mapping) {
        switch (type.kind()) {
            case ARRAY: {
                ArrayType arrayType = type.asArrayType();
                return ArrayType.create((Type)JandexUtil.mapGenerics(arrayType.constituent(), mapping), (int)arrayType.dimensions());
            }
            case CLASS: {
                return type;
            }
            case PARAMETERIZED_TYPE: {
                ParameterizedType parameterizedType = type.asParameterizedType();
                Type owner = null;
                if (parameterizedType.owner() != null) {
                    owner = JandexUtil.mapGenerics(parameterizedType.owner(), mapping);
                }
                return ParameterizedType.create((DotName)parameterizedType.name(), (Type[])JandexUtil.mapGenerics(parameterizedType.arguments(), mapping).toArray(new Type[0]), (Type)owner);
            }
            case TYPE_VARIABLE: {
                Type ret = mapping.get(type.asTypeVariable().identifier());
                if (ret == null) {
                    throw new IllegalArgumentException("Missing type argument mapping for " + String.valueOf(type));
                }
                return ret;
            }
        }
        throw new IllegalArgumentException("Illegal type in hierarchy: " + String.valueOf(type));
    }

    private static ClassInfo fetchFromIndex(DotName dotName, IndexView index) {
        ClassInfo classInfo = index.getClassByName(dotName);
        if (classInfo == null) {
            throw new IllegalArgumentException("Class " + String.valueOf(dotName) + " was not found in the index");
        }
        return classInfo;
    }
}

