/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.azure.openai.runtime;

import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.DisabledChatModel;
import dev.langchain4j.model.chat.DisabledStreamingChatModel;
import dev.langchain4j.model.chat.StreamingChatModel;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.embedding.DisabledEmbeddingModel;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.image.DisabledImageModel;
import dev.langchain4j.model.image.ImageModel;
import io.quarkiverse.langchain4j.auth.ModelAuthProvider;
import io.quarkiverse.langchain4j.azure.openai.AzureOpenAiChatModel;
import io.quarkiverse.langchain4j.azure.openai.AzureOpenAiEmbeddingModel;
import io.quarkiverse.langchain4j.azure.openai.AzureOpenAiImageModel;
import io.quarkiverse.langchain4j.azure.openai.AzureOpenAiStreamingChatModel;
import io.quarkiverse.langchain4j.azure.openai.runtime.config.ChatModelConfig;
import io.quarkiverse.langchain4j.azure.openai.runtime.config.EmbeddingModelConfig;
import io.quarkiverse.langchain4j.azure.openai.runtime.config.ImageModelConfig;
import io.quarkiverse.langchain4j.azure.openai.runtime.config.LangChain4jAzureOpenAiConfig;
import io.quarkiverse.langchain4j.openai.common.QuarkusOpenAiClient;
import io.quarkiverse.langchain4j.openai.common.runtime.AdditionalPropertiesHack;
import io.quarkiverse.langchain4j.runtime.NamedConfigUtil;
import io.quarkiverse.langchain4j.runtime.OptionalUtil;
import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.smallrye.config.ConfigValidationException;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.util.TypeLiteral;
import java.lang.annotation.Annotation;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

@Recorder
public class AzureOpenAiRecorder {
    static final String AZURE_ENDPOINT_URL_PATTERN = "https://%s.%s/openai/deployments/%s";
    public static final ConfigValidationException.Problem[] EMPTY_PROBLEMS = new ConfigValidationException.Problem[0];
    private static final TypeLiteral<Instance<ChatModelListener>> CHAT_MODEL_LISTENER_TYPE_LITERAL = new TypeLiteral<Instance<ChatModelListener>>(){};
    private static final TypeLiteral<Instance<ModelAuthProvider>> MODEL_AUTH_PROVIDER_TYPE_LITERAL = new TypeLiteral<Instance<ModelAuthProvider>>(){};
    private final RuntimeValue<LangChain4jAzureOpenAiConfig> runtimeConfig;

    public AzureOpenAiRecorder(RuntimeValue<LangChain4jAzureOpenAiConfig> runtimeConfig) {
        this.runtimeConfig = runtimeConfig;
    }

    public Function<SyntheticCreationalContext<ChatModel>, ChatModel> chatModel(final String configName) {
        LangChain4jAzureOpenAiConfig.AzureAiConfig azureAiConfig = this.correspondingAzureOpenAiConfig((LangChain4jAzureOpenAiConfig)this.runtimeConfig.getValue(), configName);
        if (azureAiConfig.enableIntegration().booleanValue()) {
            ChatModelConfig chatModelConfig = azureAiConfig.chatModel();
            final String apiKey = (String)OptionalUtil.firstOrDefault(null, (Optional[])new Optional[]{chatModelConfig.apiKey(), azureAiConfig.apiKey()});
            final String adToken = (String)OptionalUtil.firstOrDefault(null, (Optional[])new Optional[]{chatModelConfig.adToken(), azureAiConfig.adToken()});
            final AzureOpenAiChatModel.Builder builder = AzureOpenAiChatModel.builder().endpoint(AzureOpenAiRecorder.getEndpoint(azureAiConfig, configName, LangChain4jAzureOpenAiConfig.AzureAiConfig.EndpointType.CHAT)).configName(NamedConfigUtil.isDefault((String)configName) ? null : configName).apiKey(apiKey).adToken(adToken).apiVersion(chatModelConfig.apiVersion().orElse(azureAiConfig.apiVersion())).timeout(azureAiConfig.timeout().orElse(Duration.ofSeconds(10L))).maxRetries(azureAiConfig.maxRetries()).logRequests((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{chatModelConfig.logRequests(), azureAiConfig.logRequests()})).logResponses((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{chatModelConfig.logResponses(), azureAiConfig.logResponses()})).temperature(chatModelConfig.temperature()).topP(chatModelConfig.topP()).presencePenalty(chatModelConfig.presencePenalty()).frequencyPenalty(chatModelConfig.frequencyPenalty()).responseFormat(chatModelConfig.responseFormat().orElse(null));
            azureAiConfig.proxyHost().ifPresent(host -> builder.proxy(new Proxy(Proxy.Type.valueOf(azureAiConfig.proxyType()), new InetSocketAddress((String)host, (int)azureAiConfig.proxyPort()))));
            if (chatModelConfig.maxTokens().isPresent()) {
                builder.maxTokens(chatModelConfig.maxTokens().get());
            }
            return new Function<SyntheticCreationalContext<ChatModel>, ChatModel>(this){
                final /* synthetic */ AzureOpenAiRecorder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public ChatModel apply(SyntheticCreationalContext<ChatModel> context) {
                    this.this$0.throwIfApiKeysNotConfigured(apiKey, adToken, AzureOpenAiRecorder.isAuthProviderAvailable(context, configName), configName);
                    builder.listeners(((Instance)context.getInjectedReference(CHAT_MODEL_LISTENER_TYPE_LITERAL, new Annotation[0])).stream().collect(Collectors.toList()));
                    return builder.build();
                }
            };
        }
        return new Function<SyntheticCreationalContext<ChatModel>, ChatModel>(){

            @Override
            public ChatModel apply(SyntheticCreationalContext<ChatModel> context) {
                return new DisabledChatModel();
            }
        };
    }

    public Function<SyntheticCreationalContext<StreamingChatModel>, StreamingChatModel> streamingChatModel(final String configName) {
        LangChain4jAzureOpenAiConfig.AzureAiConfig azureAiConfig = this.correspondingAzureOpenAiConfig((LangChain4jAzureOpenAiConfig)this.runtimeConfig.getValue(), configName);
        if (azureAiConfig.enableIntegration().booleanValue()) {
            ChatModelConfig chatModelConfig = azureAiConfig.chatModel();
            final String apiKey = azureAiConfig.apiKey().orElse(null);
            final String adToken = azureAiConfig.adToken().orElse(null);
            final AzureOpenAiStreamingChatModel.Builder builder = AzureOpenAiStreamingChatModel.builder().endpoint(AzureOpenAiRecorder.getEndpoint(azureAiConfig, configName, LangChain4jAzureOpenAiConfig.AzureAiConfig.EndpointType.CHAT)).apiKey(apiKey).adToken(adToken).configName(NamedConfigUtil.isDefault((String)configName) ? null : configName).apiVersion(azureAiConfig.apiVersion()).timeout(azureAiConfig.timeout().orElse(Duration.ofSeconds(10L))).logRequests((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{chatModelConfig.logRequests(), azureAiConfig.logRequests()})).logResponses((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{chatModelConfig.logResponses(), azureAiConfig.logResponses()})).temperature(chatModelConfig.temperature()).topP(chatModelConfig.topP()).presencePenalty(chatModelConfig.presencePenalty()).frequencyPenalty(chatModelConfig.frequencyPenalty()).responseFormat(chatModelConfig.responseFormat().orElse(null));
            azureAiConfig.proxyHost().ifPresent(host -> builder.proxy(new Proxy(Proxy.Type.valueOf(azureAiConfig.proxyType()), new InetSocketAddress((String)host, (int)azureAiConfig.proxyPort()))));
            if (chatModelConfig.maxTokens().isPresent()) {
                builder.maxTokens(chatModelConfig.maxTokens().get());
            }
            return new Function<SyntheticCreationalContext<StreamingChatModel>, StreamingChatModel>(this){
                final /* synthetic */ AzureOpenAiRecorder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public StreamingChatModel apply(SyntheticCreationalContext<StreamingChatModel> context) {
                    this.this$0.throwIfApiKeysNotConfigured(apiKey, adToken, AzureOpenAiRecorder.isAuthProviderAvailable(context, configName), configName);
                    builder.listeners(((Instance)context.getInjectedReference(CHAT_MODEL_LISTENER_TYPE_LITERAL, new Annotation[0])).stream().collect(Collectors.toList()));
                    return builder.build();
                }
            };
        }
        return new Function<SyntheticCreationalContext<StreamingChatModel>, StreamingChatModel>(){

            @Override
            public StreamingChatModel apply(SyntheticCreationalContext<StreamingChatModel> context) {
                return new DisabledStreamingChatModel();
            }
        };
    }

    public Function<SyntheticCreationalContext<EmbeddingModel>, EmbeddingModel> embeddingModel(final String configName) {
        LangChain4jAzureOpenAiConfig.AzureAiConfig azureAiConfig = this.correspondingAzureOpenAiConfig((LangChain4jAzureOpenAiConfig)this.runtimeConfig.getValue(), configName);
        if (azureAiConfig.enableIntegration().booleanValue()) {
            EmbeddingModelConfig embeddingModelConfig = azureAiConfig.embeddingModel();
            final String apiKey = (String)OptionalUtil.firstOrDefault(null, (Optional[])new Optional[]{embeddingModelConfig.apiKey(), azureAiConfig.apiKey()});
            final String adToken = (String)OptionalUtil.firstOrDefault(null, (Optional[])new Optional[]{embeddingModelConfig.adToken(), azureAiConfig.adToken()});
            final AzureOpenAiEmbeddingModel.Builder builder = AzureOpenAiEmbeddingModel.builder().endpoint(AzureOpenAiRecorder.getEndpoint(azureAiConfig, configName, LangChain4jAzureOpenAiConfig.AzureAiConfig.EndpointType.EMBEDDING)).apiKey(apiKey).adToken(adToken).configName(NamedConfigUtil.isDefault((String)configName) ? null : configName).apiVersion(embeddingModelConfig.apiVersion().orElse(azureAiConfig.apiVersion())).timeout(azureAiConfig.timeout().orElse(Duration.ofSeconds(10L))).maxRetries(azureAiConfig.maxRetries()).logRequests((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{embeddingModelConfig.logRequests(), azureAiConfig.logRequests()})).logResponses((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{embeddingModelConfig.logResponses(), azureAiConfig.logResponses()}));
            azureAiConfig.proxyHost().ifPresent(host -> builder.proxy(new Proxy(Proxy.Type.valueOf(azureAiConfig.proxyType()), new InetSocketAddress((String)host, (int)azureAiConfig.proxyPort()))));
            return new Function<SyntheticCreationalContext<EmbeddingModel>, EmbeddingModel>(this){
                final /* synthetic */ AzureOpenAiRecorder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public EmbeddingModel apply(SyntheticCreationalContext<EmbeddingModel> context) {
                    this.this$0.throwIfApiKeysNotConfigured(apiKey, adToken, AzureOpenAiRecorder.isAuthProviderAvailable(context, configName), configName);
                    return builder.build();
                }
            };
        }
        return new Function<SyntheticCreationalContext<EmbeddingModel>, EmbeddingModel>(){

            @Override
            public EmbeddingModel apply(SyntheticCreationalContext<EmbeddingModel> context) {
                return new DisabledEmbeddingModel();
            }
        };
    }

    public Function<SyntheticCreationalContext<ImageModel>, ImageModel> imageModel(final String configName) {
        LangChain4jAzureOpenAiConfig.AzureAiConfig azureAiConfig = this.correspondingAzureOpenAiConfig((LangChain4jAzureOpenAiConfig)this.runtimeConfig.getValue(), configName);
        if (azureAiConfig.enableIntegration().booleanValue()) {
            ImageModelConfig imageModelConfig = azureAiConfig.imageModel();
            final String apiKey = (String)OptionalUtil.firstOrDefault(null, (Optional[])new Optional[]{imageModelConfig.apiKey(), azureAiConfig.apiKey()});
            final String adToken = (String)OptionalUtil.firstOrDefault(null, (Optional[])new Optional[]{imageModelConfig.adToken(), azureAiConfig.adToken()});
            final AzureOpenAiImageModel.Builder builder = AzureOpenAiImageModel.builder().endpoint(AzureOpenAiRecorder.getEndpoint(azureAiConfig, configName, LangChain4jAzureOpenAiConfig.AzureAiConfig.EndpointType.IMAGE)).apiKey(apiKey).adToken(adToken).apiVersion(imageModelConfig.apiVersion().orElse(azureAiConfig.apiVersion())).timeout(azureAiConfig.timeout().orElse(Duration.ofSeconds(10L))).maxRetries(azureAiConfig.maxRetries()).logRequests((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{imageModelConfig.logRequests(), azureAiConfig.logRequests()})).logResponses((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{imageModelConfig.logResponses(), azureAiConfig.logResponses()})).modelName(imageModelConfig.modelName()).configName(NamedConfigUtil.isDefault((String)configName) ? null : configName).size(imageModelConfig.size()).quality(imageModelConfig.quality()).style(imageModelConfig.style()).responseFormat(imageModelConfig.responseFormat()).user(imageModelConfig.user());
            Optional<Path> persistDirectory = Optional.empty();
            if (imageModelConfig.persist().isPresent()) {
                if (imageModelConfig.persist().get().booleanValue()) {
                    persistDirectory = imageModelConfig.persistDirectory().or((Supplier<Optional<Path>>)new Supplier<Optional<? extends Path>>(){

                        @Override
                        public Optional<? extends Path> get() {
                            return Optional.of(Paths.get(System.getProperty("java.io.tmpdir"), "dall-e-images"));
                        }
                    });
                }
            } else if (imageModelConfig.persistDirectory().isPresent()) {
                persistDirectory = imageModelConfig.persistDirectory();
            }
            builder.persistDirectory(persistDirectory);
            return new Function<SyntheticCreationalContext<ImageModel>, ImageModel>(this){
                final /* synthetic */ AzureOpenAiRecorder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public ImageModel apply(SyntheticCreationalContext<ImageModel> context) {
                    this.this$0.throwIfApiKeysNotConfigured(apiKey, adToken, AzureOpenAiRecorder.isAuthProviderAvailable(context, configName), configName);
                    return builder.build();
                }
            };
        }
        return new Function<SyntheticCreationalContext<ImageModel>, ImageModel>(){

            @Override
            public ImageModel apply(SyntheticCreationalContext<ImageModel> context) {
                return new DisabledImageModel();
            }
        };
    }

    static String getEndpoint(LangChain4jAzureOpenAiConfig.AzureAiConfig azureAiConfig, String configName, LangChain4jAzureOpenAiConfig.AzureAiConfig.EndpointType type) {
        Optional<String> endpoint = azureAiConfig.endPointFor(type);
        return endpoint.isPresent() && !endpoint.get().trim().isBlank() ? endpoint.get() : AzureOpenAiRecorder.constructEndpointFromConfig(azureAiConfig, configName, type);
    }

    private static String constructEndpointFromConfig(LangChain4jAzureOpenAiConfig.AzureAiConfig azureAiConfig, String configName, LangChain4jAzureOpenAiConfig.AzureAiConfig.EndpointType type) {
        Optional<String> resourceName = azureAiConfig.resourceNameFor(type);
        Optional<String> domainName = azureAiConfig.domainNameFor(type);
        Optional<String> deploymentName = azureAiConfig.deploymentNameFor(type);
        if (resourceName.isEmpty() || deploymentName.isEmpty() || domainName.isEmpty()) {
            ArrayList<ConfigValidationException.Problem> configProblems = new ArrayList<ConfigValidationException.Problem>();
            if (resourceName.isEmpty()) {
                configProblems.add(AzureOpenAiRecorder.createConfigProblem("resource-name", configName));
            }
            if (deploymentName.isEmpty()) {
                configProblems.add(AzureOpenAiRecorder.createConfigProblem("deployment-name", configName));
            }
            if (domainName.isEmpty()) {
                configProblems.add(AzureOpenAiRecorder.createConfigProblem("domain-name", configName));
            }
            throw new ConfigValidationException(configProblems.toArray(EMPTY_PROBLEMS));
        }
        return String.format(AZURE_ENDPOINT_URL_PATTERN, resourceName.get(), domainName.get(), deploymentName.get());
    }

    private LangChain4jAzureOpenAiConfig.AzureAiConfig correspondingAzureOpenAiConfig(LangChain4jAzureOpenAiConfig runtimeConfig, String configName) {
        LangChain4jAzureOpenAiConfig.AzureAiConfig azureAiConfig = NamedConfigUtil.isDefault((String)configName) ? runtimeConfig.defaultConfig() : runtimeConfig.namedConfig().get(configName);
        return azureAiConfig;
    }

    private void throwIfApiKeysNotConfigured(String apiKey, String adToken, boolean authProviderAvailable, String configName) {
        if (apiKey != null == (adToken != null) && !authProviderAvailable) {
            throw new ConfigValidationException(this.createKeyMisconfigurationProblem(configName));
        }
    }

    private ConfigValidationException.Problem[] createKeyMisconfigurationProblem(String configName) {
        return new ConfigValidationException.Problem[]{new ConfigValidationException.Problem(String.format("SRCFG00014: Exactly of the configuration properties must be present: quarkus.langchain4j.azure-openai%s%s or quarkus.langchain4j.azure-openai%s%s", NamedConfigUtil.isDefault((String)configName) ? "." : "." + configName + ".", "api-key", NamedConfigUtil.isDefault((String)configName) ? "." : "." + configName + ".", "ad-token"))};
    }

    private static ConfigValidationException.Problem createConfigProblem(String key, String configName) {
        return new ConfigValidationException.Problem(String.format("SRCFG00014: The config property quarkus.langchain4j.azure-openai%s%s is required but it could not be found in any config source", NamedConfigUtil.isDefault((String)configName) ? "." : "." + configName + ".", key));
    }

    private static <T> boolean isAuthProviderAvailable(SyntheticCreationalContext<T> context, String configName) {
        return ((Instance)context.getInjectedReference(MODEL_AUTH_PROVIDER_TYPE_LITERAL, new Annotation[0])).isResolvable();
    }

    public void cleanUp(ShutdownContext shutdown) {
        AdditionalPropertiesHack.reset();
        shutdown.addShutdownTask(new Runnable(){

            @Override
            public void run() {
                QuarkusOpenAiClient.clearCache();
            }
        });
    }
}

