/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.entity;

import io.qameta.allure.entity.EntityUtils;
import io.qameta.allure.entity.Time;
import io.qameta.allure.entity.Timeable;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;

public class GroupTime
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Long start;
    protected Long stop;
    protected Long duration;
    protected Long minDuration;
    protected Long maxDuration;
    protected Long sumDuration;

    public void merge(GroupTime groupTime) {
        if (Objects.isNull(groupTime)) {
            return;
        }
        GroupTime.update(EntityUtils.firstNonNull(this.getStart(), Long.MAX_VALUE), groupTime.getStart(), Math::min, this::setStart);
        GroupTime.update(EntityUtils.firstNonNull(this.getStop(), 0L), groupTime.getStop(), Math::max, this::setStop);
        GroupTime.update(this.getStop(), this.getStart(), (a, b) -> a - b, this::setDuration);
        GroupTime.update(EntityUtils.firstNonNull(this.getMinDuration(), Long.MAX_VALUE), groupTime.getMinDuration(), Math::min, this::setMinDuration);
        GroupTime.update(EntityUtils.firstNonNull(this.getMaxDuration(), 0L), groupTime.getMaxDuration(), Math::max, this::setMaxDuration);
        GroupTime.update(EntityUtils.firstNonNull(this.getSumDuration(), 0L), groupTime.getSumDuration(), (a, b) -> a + b, this::setSumDuration);
    }

    public void update(Timeable timeable) {
        if (Objects.isNull(timeable)) {
            return;
        }
        this.update(timeable.getTime());
    }

    public void update(Time time) {
        if (Objects.isNull(time)) {
            return;
        }
        GroupTime.update(EntityUtils.firstNonNull(this.getStart(), Long.MAX_VALUE), time.getStart(), Math::min, this::setStart);
        GroupTime.update(EntityUtils.firstNonNull(this.getStop(), 0L), time.getStop(), Math::max, this::setStop);
        GroupTime.update(this.getStop(), this.getStart(), (a, b) -> a - b, this::setDuration);
        GroupTime.update(EntityUtils.firstNonNull(this.getMinDuration(), Long.MAX_VALUE), time.getDuration(), Math::min, this::setMinDuration);
        GroupTime.update(EntityUtils.firstNonNull(this.getMaxDuration(), 0L), time.getDuration(), Math::max, this::setMaxDuration);
        GroupTime.update(EntityUtils.firstNonNull(this.getSumDuration(), 0L), time.getDuration(), (a, b) -> a + b, this::setSumDuration);
    }

    protected static <T> void update(T first, T second, BiFunction<T, T, T> merge, Consumer<T> setter) {
        if (Objects.nonNull(first) && Objects.nonNull(second)) {
            setter.accept(merge.apply(first, second));
        }
    }

    public Long getStart() {
        return this.start;
    }

    public Long getStop() {
        return this.stop;
    }

    public Long getDuration() {
        return this.duration;
    }

    public Long getMinDuration() {
        return this.minDuration;
    }

    public Long getMaxDuration() {
        return this.maxDuration;
    }

    public Long getSumDuration() {
        return this.sumDuration;
    }

    public GroupTime setStart(Long start) {
        this.start = start;
        return this;
    }

    public GroupTime setStop(Long stop) {
        this.stop = stop;
        return this;
    }

    public GroupTime setDuration(Long duration) {
        this.duration = duration;
        return this;
    }

    public GroupTime setMinDuration(Long minDuration) {
        this.minDuration = minDuration;
        return this;
    }

    public GroupTime setMaxDuration(Long maxDuration) {
        this.maxDuration = maxDuration;
        return this;
    }

    public GroupTime setSumDuration(Long sumDuration) {
        this.sumDuration = sumDuration;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GroupTime)) {
            return false;
        }
        GroupTime other = (GroupTime)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$start = this.getStart();
        Long other$start = other.getStart();
        if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
            return false;
        }
        Long this$stop = this.getStop();
        Long other$stop = other.getStop();
        if (this$stop == null ? other$stop != null : !((Object)this$stop).equals(other$stop)) {
            return false;
        }
        Long this$duration = this.getDuration();
        Long other$duration = other.getDuration();
        if (this$duration == null ? other$duration != null : !((Object)this$duration).equals(other$duration)) {
            return false;
        }
        Long this$minDuration = this.getMinDuration();
        Long other$minDuration = other.getMinDuration();
        if (this$minDuration == null ? other$minDuration != null : !((Object)this$minDuration).equals(other$minDuration)) {
            return false;
        }
        Long this$maxDuration = this.getMaxDuration();
        Long other$maxDuration = other.getMaxDuration();
        if (this$maxDuration == null ? other$maxDuration != null : !((Object)this$maxDuration).equals(other$maxDuration)) {
            return false;
        }
        Long this$sumDuration = this.getSumDuration();
        Long other$sumDuration = other.getSumDuration();
        return !(this$sumDuration == null ? other$sumDuration != null : !((Object)this$sumDuration).equals(other$sumDuration));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GroupTime;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
        Long $stop = this.getStop();
        result = result * 59 + ($stop == null ? 43 : ((Object)$stop).hashCode());
        Long $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : ((Object)$duration).hashCode());
        Long $minDuration = this.getMinDuration();
        result = result * 59 + ($minDuration == null ? 43 : ((Object)$minDuration).hashCode());
        Long $maxDuration = this.getMaxDuration();
        result = result * 59 + ($maxDuration == null ? 43 : ((Object)$maxDuration).hashCode());
        Long $sumDuration = this.getSumDuration();
        result = result * 59 + ($sumDuration == null ? 43 : ((Object)$sumDuration).hashCode());
        return result;
    }

    public String toString() {
        return "GroupTime(start=" + this.getStart() + ", stop=" + this.getStop() + ", duration=" + this.getDuration() + ", minDuration=" + this.getMinDuration() + ", maxDuration=" + this.getMaxDuration() + ", sumDuration=" + this.getSumDuration() + ")";
    }
}

