/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.retry;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.qameta.allure.Aggregator;
import io.qameta.allure.CommonJsonAggregator;
import io.qameta.allure.core.LaunchResults;
import io.qameta.allure.retry.RetryTrendItem;
import io.qameta.allure.trend.AbstractTrendPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RetryTrendPlugin
extends AbstractTrendPlugin<RetryTrendItem> {
    private static final String JSON_FILE_NAME = "retry-trend.json";
    public static final String RETRY_TREND_BLOCK_NAME = "retry-trend";

    public RetryTrendPlugin() {
        super(Arrays.asList(new Aggregator[]{new JsonAggregator(), new WidgetAggregator()}), JSON_FILE_NAME, RETRY_TREND_BLOCK_NAME);
    }

    @Override
    protected Optional<RetryTrendItem> parseItem(ObjectMapper mapper, JsonNode child) throws JsonProcessingException {
        return Optional.ofNullable(mapper.treeToValue((TreeNode)child, RetryTrendItem.class));
    }

    static List<RetryTrendItem> getData(List<LaunchResults> launchesResults) {
        RetryTrendItem item = RetryTrendPlugin.createCurrent(launchesResults);
        List<RetryTrendItem> data = RetryTrendPlugin.getHistoryItems(launchesResults);
        return Stream.concat(Stream.of(item), data.stream()).limit(20L).collect(Collectors.toList());
    }

    private static List<RetryTrendItem> getHistoryItems(List<LaunchResults> launchesResults) {
        return launchesResults.stream().map(RetryTrendPlugin::getPreviousTrendData).reduce(new ArrayList(), (first, second) -> {
            first.addAll(second);
            return first;
        });
    }

    private static List<RetryTrendItem> getPreviousTrendData(LaunchResults results) {
        return (List)results.getExtra(RETRY_TREND_BLOCK_NAME, ArrayList::new);
    }

    private static RetryTrendItem createCurrent(List<LaunchResults> launchesResults) {
        RetryTrendItem item = new RetryTrendItem();
        RetryTrendPlugin.extractLatestExecutor(launchesResults).ifPresent(info -> {
            item.setBuildOrder(info.getBuildOrder());
            item.setReportName(info.getReportName());
            item.setReportUrl(info.getReportUrl());
        });
        launchesResults.stream().flatMap(launch -> launch.getAllResults().stream()).forEach(item::update);
        return item;
    }

    private static class WidgetAggregator
    extends CommonJsonAggregator {
        WidgetAggregator() {
            super("widgets", RetryTrendPlugin.JSON_FILE_NAME);
        }

        public List<RetryTrendItem> getData(List<LaunchResults> launches) {
            return RetryTrendPlugin.getData(launches);
        }
    }

    protected static class JsonAggregator
    extends CommonJsonAggregator {
        JsonAggregator() {
            super("history", RetryTrendPlugin.JSON_FILE_NAME);
        }

        protected List<RetryTrendItem> getData(List<LaunchResults> launches) {
            return RetryTrendPlugin.getData(launches);
        }
    }
}

