/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure;

import io.qameta.allure.Aggregator;
import io.qameta.allure.DefaultResultsVisitor;
import io.qameta.allure.core.Configuration;
import io.qameta.allure.core.LaunchResults;
import io.qameta.allure.core.ResultsVisitor;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportGenerator.class);
    private final Configuration configuration;

    public ReportGenerator(Configuration configuration) {
        this.configuration = configuration;
    }

    public LaunchResults readResults(Path resultsDirectory) {
        DefaultResultsVisitor visitor = new DefaultResultsVisitor(this.configuration);
        this.configuration.getReaders().forEach(reader -> reader.readResults(this.configuration, (ResultsVisitor)visitor, resultsDirectory));
        return visitor.getLaunchResults();
    }

    public void aggregate(List<LaunchResults> results, Path outputDirectory) throws IOException {
        for (Aggregator aggregator : this.configuration.getAggregators()) {
            aggregator.aggregate(this.configuration, results, outputDirectory);
        }
    }

    public void generate(Path outputDirectory, List<Path> resultsDirectories) throws IOException {
        this.generate(outputDirectory, resultsDirectories.stream());
    }

    public void generate(Path outputDirectory, Path ... resultsDirectories) throws IOException {
        this.generate(outputDirectory, Stream.of(resultsDirectories));
    }

    private void generate(Path outputDirectory, Stream<Path> resultsDirectories) throws IOException {
        List<LaunchResults> results = resultsDirectories.filter(this::isValidResultsDirectory).map(this::readResults).collect(Collectors.toList());
        this.aggregate(results, outputDirectory);
    }

    private boolean isValidResultsDirectory(Path resultsDirectory) {
        if (Files.notExists(resultsDirectory, new LinkOption[0])) {
            LOGGER.warn("{} does not exists", (Object)resultsDirectory);
            return false;
        }
        if (!Files.isDirectory(resultsDirectory, new LinkOption[0])) {
            LOGGER.warn("{} is not a directory", (Object)resultsDirectory);
            return false;
        }
        return true;
    }
}

