/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.websocket;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.nio.charset.Charset;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.NettyOutbound;

public interface WebsocketOutbound
extends NettyOutbound {
    public static final Function<? super String, ? extends WebSocketFrame> stringToWebsocketFrame = TextWebSocketFrame::new;
    public static final Function<? super ByteBuf, ? extends WebSocketFrame> bytebufToWebsocketFrame = BinaryWebSocketFrame::new;

    public @Nullable String selectedSubprotocol();

    public NettyOutbound send(Publisher<? extends ByteBuf> var1);

    public Mono<Void> sendClose();

    public Mono<Void> sendClose(int var1);

    public Mono<Void> sendClose(int var1, @Nullable String var2);

    public Mono<Void> sendClose(int var1, int var2, @Nullable String var3);

    default public NettyOutbound sendString(Publisher<? extends String> dataStream, Charset charset) {
        return this.sendObject((Publisher)Flux.from(dataStream).map(stringToWebsocketFrame));
    }
}

