/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import reactor.netty.http.client.AbstractHttpClientMetricsHandler;
import reactor.netty.http.client.ContextAwareHttpClientMetricsRecorder;

final class ContextAwareHttpClientMetricsHandler
extends AbstractHttpClientMetricsHandler {
    final ContextAwareHttpClientMetricsRecorder recorder;

    ContextAwareHttpClientMetricsHandler(ContextAwareHttpClientMetricsRecorder recorder, SocketAddress remoteAddress, @Nullable SocketAddress proxyAddress, @Nullable Function<String, String> uriTagValue) {
        super(remoteAddress, proxyAddress, uriTagValue);
        this.recorder = recorder;
    }

    ContextAwareHttpClientMetricsHandler(ContextAwareHttpClientMetricsHandler copy) {
        super(copy);
        this.recorder = copy.recorder;
    }

    @Override
    protected ContextAwareHttpClientMetricsRecorder recorder() {
        return this.recorder;
    }

    @Override
    protected void recordException(ChannelHandlerContext ctx) {
        if (this.contextView != null) {
            if (this.proxyAddress == null) {
                this.recorder().incrementErrorsCount(this.contextView, this.remoteAddress, Objects.requireNonNull(this.path));
            } else {
                this.recorder().incrementErrorsCount(this.contextView, this.remoteAddress, this.proxyAddress, Objects.requireNonNull(this.path));
            }
        } else {
            super.recordException(ctx);
        }
    }

    @Override
    protected void recordWrite(SocketAddress address) {
        if (this.contextView != null) {
            if (this.proxyAddress == null) {
                this.recorder.recordDataSentTime(this.contextView, address, Objects.requireNonNull(this.path), Objects.requireNonNull(this.method), Duration.ofNanos(System.nanoTime() - this.dataSentTime));
                this.recorder.recordDataSent(this.contextView, address, this.path, this.dataSent);
            } else {
                this.recorder.recordDataSentTime(this.contextView, address, this.proxyAddress, Objects.requireNonNull(this.path), Objects.requireNonNull(this.method), Duration.ofNanos(System.nanoTime() - this.dataSentTime));
                this.recorder.recordDataSent(this.contextView, address, this.proxyAddress, this.path, this.dataSent);
            }
        } else {
            super.recordWrite(address);
        }
    }

    @Override
    protected void recordRead(Channel channel, SocketAddress address) {
        if (this.contextView != null) {
            if (this.proxyAddress == null) {
                this.recorder.recordDataReceivedTime(this.contextView, address, Objects.requireNonNull(this.path), Objects.requireNonNull(this.method), Objects.requireNonNull(this.status), Duration.ofNanos(System.nanoTime() - this.dataReceivedTime));
                this.recorder.recordResponseTime(this.contextView, address, this.path, this.method, this.status, Duration.ofNanos(System.nanoTime() - this.dataSentTime));
                this.recorder.recordDataReceived(this.contextView, address, this.path, this.dataReceived);
            } else {
                this.recorder.recordDataReceivedTime(this.contextView, address, this.proxyAddress, Objects.requireNonNull(this.path), Objects.requireNonNull(this.method), Objects.requireNonNull(this.status), Duration.ofNanos(System.nanoTime() - this.dataReceivedTime));
                this.recorder.recordResponseTime(this.contextView, address, this.proxyAddress, this.path, this.method, this.status, Duration.ofNanos(System.nanoTime() - this.dataSentTime));
                this.recorder.recordDataReceived(this.contextView, address, this.proxyAddress, this.path, this.dataReceived);
            }
        } else {
            super.recordRead(channel, address);
        }
    }
}

