/*
 * Decompiled with CFR 0.152.
 */
package reactor.pool.introspection.micrometer;

import io.micrometer.common.docs.KeyName;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.docs.MeterDocumentation;

enum PoolMetersDocumentation implements MeterDocumentation
{
    ACQUIRED{

        public String getName() {
            return "reactor.pool.resources.acquired";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        public KeyName[] getKeyNames() {
            return CommonTags.values();
        }
    }
    ,
    ALLOCATED{

        public String getName() {
            return "reactor.pool.resources.allocated";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        public KeyName[] getKeyNames() {
            return CommonTags.values();
        }
    }
    ,
    IDLE{

        public String getName() {
            return "reactor.pool.resources.idle";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        public KeyName[] getKeyNames() {
            return CommonTags.values();
        }
    }
    ,
    PENDING_ACQUIRE{

        public String getName() {
            return "reactor.pool.resources.pendingAcquire";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        public KeyName[] getKeyNames() {
            return CommonTags.values();
        }
    }
    ,
    ALLOCATION{

        public String getName() {
            return "reactor.pool.allocation";
        }

        public Meter.Type getType() {
            return Meter.Type.TIMER;
        }

        public KeyName[] getKeyNames() {
            return KeyName.merge((KeyName[][])new KeyName[][]{CommonTags.values(), AllocationTags.values()});
        }
    }
    ,
    DESTROYED{

        public String getName() {
            return "reactor.pool.destroyed";
        }

        public Meter.Type getType() {
            return Meter.Type.TIMER;
        }

        public KeyName[] getKeyNames() {
            return CommonTags.values();
        }
    }
    ,
    SUMMARY_IDLENESS{

        public String getName() {
            return "reactor.pool.resources.summary.idleness";
        }

        public Meter.Type getType() {
            return Meter.Type.TIMER;
        }

        public KeyName[] getKeyNames() {
            return CommonTags.values();
        }
    }
    ,
    SUMMARY_LIFETIME{

        public String getName() {
            return "reactor.pool.resources.summary.lifetime";
        }

        public Meter.Type getType() {
            return Meter.Type.TIMER;
        }

        public KeyName[] getKeyNames() {
            return CommonTags.values();
        }
    }
    ,
    RECYCLED{

        public String getName() {
            return "reactor.pool.recycled";
        }

        public Meter.Type getType() {
            return Meter.Type.COUNTER;
        }

        public KeyName[] getKeyNames() {
            return CommonTags.values();
        }
    }
    ,
    RECYCLED_NOTABLE{

        public String getName() {
            return "reactor.pool.recycled.notable";
        }

        public Meter.Type getType() {
            return Meter.Type.COUNTER;
        }

        public KeyName[] getKeyNames() {
            return KeyName.merge((KeyName[][])new KeyName[][]{CommonTags.values(), RecycledNotableTags.values()});
        }
    }
    ,
    RESET{

        public String getName() {
            return "reactor.pool.reset";
        }

        public Meter.Type getType() {
            return Meter.Type.TIMER;
        }

        public KeyName[] getKeyNames() {
            return CommonTags.values();
        }
    };


    public static enum CommonTags implements KeyName
    {
        POOL_NAME{

            public String asString() {
                return "pool.name";
            }
        };

    }

    public static enum RecycledNotableTags implements KeyName
    {
        PATH{

            public String asString() {
                return "pool.recycling.path";
            }
        };

        public static final Tag PATH_SLOW;
        public static final Tag PATH_FAST;

        static {
            PATH_SLOW = Tag.of((String)PATH.asString(), (String)"slow");
            PATH_FAST = Tag.of((String)PATH.asString(), (String)"fast");
        }
    }

    public static enum AllocationTags implements KeyName
    {
        OUTCOME{

            public String asString() {
                return "pool.allocation.outcome";
            }
        };

        public static final Tag OUTCOME_SUCCESS;
        public static final Tag OUTCOME_FAILURE;

        static {
            OUTCOME_SUCCESS = Tag.of((String)OUTCOME.asString(), (String)"success");
            OUTCOME_FAILURE = Tag.of((String)OUTCOME.asString(), (String)"failure");
        }
    }
}

