/*
 * Decompiled with CFR 0.152.
 */
package reactor.scheduler.forkjoin;

import java.util.ArrayDeque;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import org.jspecify.annotations.Nullable;
import reactor.core.Disposable;
import reactor.core.Exceptions;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.util.Logger;
import reactor.util.Loggers;

public final class ForkJoinPoolScheduler
implements Scheduler {
    private static volatile @Nullable BiConsumer<Thread, ? super Throwable> onHandleErrorHook;
    private final ForkJoinPool pool;
    private final Scheduler scheduler;
    private final boolean disposeScheduler;
    private static final AtomicLong COUNTER;
    private static final Logger log;
    private static final BooleanSupplier NO_PARENT;

    public static Scheduler create(String name) {
        return ForkJoinPoolScheduler.create(name, Runtime.getRuntime().availableProcessors());
    }

    public static Scheduler create(String name, int parallelism) {
        return new ForkJoinPoolScheduler(parallelism, new SchedulerForkJoinWorkerThreadFactory(name, COUNTER), Schedulers.newSingle((String)(name + "-timer"), (boolean)true), true);
    }

    public static Scheduler create(int parallelism, ForkJoinPool.ForkJoinWorkerThreadFactory workerThreadFactory, Scheduler timeScheduler) {
        return new ForkJoinPoolScheduler(parallelism, workerThreadFactory, timeScheduler, false);
    }

    static void handleError(Throwable ex) {
        Thread thread = Thread.currentThread();
        Throwable t = Exceptions.unwrap((Throwable)ex);
        Exceptions.throwIfJvmFatal((Throwable)t);
        Thread.UncaughtExceptionHandler x = thread.getUncaughtExceptionHandler();
        if (x != null) {
            x.uncaughtException(thread, t);
        } else {
            log.error("Scheduler worker failed with an uncaught exception", t);
        }
        BiConsumer<Thread, ? super Throwable> errorHook = onHandleErrorHook;
        if (errorHook != null) {
            errorHook.accept(thread, t);
        }
    }

    public static void onHandleError(BiConsumer<Thread, ? super Throwable> c) {
        log.info("Hooking new: onHandleError");
        onHandleErrorHook = Objects.requireNonNull(c, "onHandleError");
    }

    public static void resetOnHandleError() {
        log.info("Reset to default: onHandleError");
        onHandleErrorHook = null;
    }

    private ForkJoinPoolScheduler(int parallelism, ForkJoinPool.ForkJoinWorkerThreadFactory workerThreadFactory, Scheduler scheduler, boolean disposeScheduler) {
        this.pool = new ForkJoinPool(parallelism, workerThreadFactory, this::uncaughtException, true);
        this.scheduler = scheduler;
        this.disposeScheduler = disposeScheduler;
    }

    public Scheduler.Worker createWorker() {
        return new Worker(this.pool, this.scheduler);
    }

    public void dispose() {
        if (this.disposeScheduler) {
            this.scheduler.dispose();
        }
        this.pool.shutdownNow();
    }

    public boolean isDisposed() {
        return this.pool.isShutdown();
    }

    public Disposable schedule(Runnable runnable) {
        return new DisposableForkJoinTask((ForkJoinTask<?>)this.pool.submit(runnable));
    }

    public Disposable schedule(Runnable task, long delay, TimeUnit unit) {
        if (delay == 0L) {
            return this.schedule(task);
        }
        TrampolinedTask trampolinedTask = new TrampolinedTask(this.pool, task, NO_PARENT);
        return new CompositeDisposable(this.scheduler.schedule((Runnable)trampolinedTask, delay, unit), trampolinedTask);
    }

    public Disposable schedulePeriodically(Runnable task, long initialDelay, long period, TimeUnit unit) {
        TrampolinedTask trampolinedTask = new TrampolinedTask(this.pool, task, NO_PARENT);
        return new CompositeDisposable(this.scheduler.schedulePeriodically((Runnable)trampolinedTask, initialDelay, period, unit), trampolinedTask);
    }

    private void uncaughtException(Thread t, Throwable e) {
        log.error("Scheduler worker in group " + t.getThreadGroup().getName() + " failed with an uncaught exception", e);
    }

    static {
        COUNTER = new AtomicLong();
        log = Loggers.getLogger(Schedulers.class);
        NO_PARENT = () -> false;
    }

    private static final class SchedulerForkJoinWorkerThreadFactory
    implements ForkJoinPool.ForkJoinWorkerThreadFactory {
        final String name;
        final AtomicLong COUNTER;

        SchedulerForkJoinWorkerThreadFactory(String name, AtomicLong COUNTER) {
            this.name = name;
            this.COUNTER = COUNTER;
        }

        @Override
        public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
            return new SchedulerForkJoinWorkerThread(this.name + "-" + this.COUNTER.incrementAndGet(), pool);
        }
    }

    private static final class SchedulerForkJoinWorkerThread
    extends ForkJoinWorkerThread {
        SchedulerForkJoinWorkerThread(String name, ForkJoinPool pool) {
            super(pool);
            this.setName(name);
        }
    }

    private static class DisposableWorkerTask
    implements Disposable,
    Runnable {
        private final Runnable task;
        private final BooleanSupplier isParentDisposed;
        private volatile boolean disposed;

        private DisposableWorkerTask(Runnable task, BooleanSupplier disposed) {
            this.task = task;
            this.isParentDisposed = disposed;
        }

        public void dispose() {
            this.disposed = true;
        }

        public boolean isDisposed() {
            return this.disposed || this.isParentDisposed.getAsBoolean();
        }

        @Override
        public void run() {
            if (this.isDisposed()) {
                return;
            }
            this.task.run();
        }
    }

    private static class Worker
    implements Scheduler.Worker {
        private final Executor executor;
        private final Scheduler scheduler;
        private final Object lock = new Object();
        private final Queue<Runnable> tasks = new ArrayDeque<Runnable>();
        private boolean executing = false;
        private final Runnable processTaskQueue = this::processTaskQueue;
        private final Executor workerExecutor = this::execute;
        private volatile boolean shutdown;
        private final BooleanSupplier isDisposed = this::isDisposed;

        Worker(Executor executor, Scheduler scheduler) {
            this.executor = executor;
            this.scheduler = scheduler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
            Object object = this.lock;
            synchronized (object) {
                this.tasks.clear();
            }
        }

        public boolean isDisposed() {
            return this.shutdown;
        }

        public Disposable schedule(Runnable task) {
            if (this.shutdown) {
                throw Exceptions.failWithRejected();
            }
            DisposableWorkerTask workerTask = new DisposableWorkerTask(task, this.isDisposed);
            try {
                this.execute(workerTask);
            }
            catch (RejectedExecutionException ignored) {
                workerTask.dispose();
                throw ignored;
            }
            return workerTask;
        }

        public Disposable schedule(Runnable task, long delay, TimeUnit unit) {
            if (delay == 0L) {
                return this.schedule(task);
            }
            if (this.shutdown) {
                throw Exceptions.failWithRejected();
            }
            TrampolinedTask trampolinedTask = new TrampolinedTask(this.workerExecutor, task, this.isDisposed);
            return new CompositeDisposable(this.scheduler.schedule((Runnable)trampolinedTask, delay, unit), trampolinedTask);
        }

        public Disposable schedulePeriodically(Runnable task, long initialDelay, long period, TimeUnit unit) {
            if (this.shutdown) {
                throw Exceptions.failWithRejected();
            }
            TrampolinedTask trampolinedTask = new TrampolinedTask(this.workerExecutor, task, this.isDisposed);
            return new CompositeDisposable(this.scheduler.schedulePeriodically((Runnable)trampolinedTask, initialDelay, period, unit), trampolinedTask);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void execute(Runnable command) {
            boolean schedule;
            Object object = this.lock;
            synchronized (object) {
                this.tasks.add(command);
                if (this.executing) {
                    schedule = false;
                } else {
                    this.executing = true;
                    schedule = true;
                }
            }
            if (schedule) {
                this.executor.execute(this.processTaskQueue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processTaskQueue() {
            while (true) {
                Runnable task;
                Object object = this.lock;
                synchronized (object) {
                    task = this.tasks.poll();
                    if (task == null) {
                        this.executing = false;
                        return;
                    }
                }
                try {
                    task.run();
                    continue;
                }
                catch (Throwable ex) {
                    ForkJoinPoolScheduler.handleError(ex);
                    continue;
                }
                break;
            }
        }
    }

    static final class CompositeDisposable
    implements Disposable {
        final Disposable a;
        final Disposable b;

        CompositeDisposable(Disposable a, Disposable b) {
            this.a = a;
            this.b = b;
        }

        public void dispose() {
            this.a.dispose();
            this.b.dispose();
        }

        public boolean isDisposed() {
            return this.a.isDisposed() && this.b.isDisposed();
        }
    }

    private static class TrampolinedTask
    implements Runnable,
    Disposable {
        private final Executor executor;
        private final Runnable task;
        private final BooleanSupplier isParentDisposed;
        private volatile boolean disposed;

        public TrampolinedTask(Executor executor, Runnable task, BooleanSupplier isParentDisposed) {
            this.executor = executor;
            this.task = task;
            this.isParentDisposed = isParentDisposed;
        }

        public void dispose() {
            this.disposed = true;
        }

        public boolean isDisposed() {
            return this.disposed || this.isParentDisposed.getAsBoolean();
        }

        @Override
        public void run() {
            this.executor.execute(() -> {
                if (!this.isDisposed()) {
                    this.task.run();
                }
            });
        }
    }

    private static class DisposableForkJoinTask
    implements Disposable {
        private final ForkJoinTask<?> task;

        DisposableForkJoinTask(ForkJoinTask<?> task) {
            this.task = task;
        }

        public void dispose() {
            this.task.cancel(false);
        }

        public boolean isDisposed() {
            return this.task.isDone();
        }
    }
}

