/*
 * Decompiled with CFR 0.152.
 */
package io.pebbletemplates.pebble.tokenParser;

import io.pebbletemplates.pebble.error.ParserException;
import io.pebbletemplates.pebble.lexer.Token;
import io.pebbletemplates.pebble.lexer.TokenStream;
import io.pebbletemplates.pebble.node.BlockNode;
import io.pebbletemplates.pebble.node.EmbedNode;
import io.pebbletemplates.pebble.node.RenderableNode;
import io.pebbletemplates.pebble.node.expression.Expression;
import io.pebbletemplates.pebble.node.expression.MapExpression;
import io.pebbletemplates.pebble.parser.Parser;
import io.pebbletemplates.pebble.tokenParser.BlockTokenParser;
import io.pebbletemplates.pebble.tokenParser.TokenParser;
import java.util.ArrayList;
import java.util.List;

public class EmbedTokenParser
implements TokenParser {
    private BlockTokenParser blockTokenParser = new BlockTokenParser();

    @Override
    public RenderableNode parse(Token token, Parser parser) {
        TokenStream stream = parser.getStream();
        int lineNumber = token.getLineNumber();
        stream.next();
        Expression<?> embedExpression = parser.getExpressionParser().parseExpression();
        Token current = stream.current();
        MapExpression mapExpression = null;
        if (current.getType().equals((Object)Token.Type.NAME) && current.getValue().equals("with")) {
            stream.next();
            Expression<?> parsedExpression = parser.getExpressionParser().parseExpression();
            if (parsedExpression instanceof MapExpression) {
                mapExpression = (MapExpression)parsedExpression;
            } else {
                throw new ParserException(null, String.format("Unexpected expression '%1s'.", parsedExpression.getClass().getCanonicalName()), token.getLineNumber(), stream.getFilename());
            }
        }
        stream.expect(Token.Type.EXECUTE_END);
        List<BlockNode> blocks = this.parseBlocks(token, parser, stream);
        return new EmbedNode(lineNumber, embedExpression, mapExpression, blocks);
    }

    private List<BlockNode> parseBlocks(Token token, Parser parser, TokenStream stream) {
        BlockNode node;
        ArrayList<BlockNode> blocks = new ArrayList<BlockNode>();
        while ((node = this.parseBlock(token, parser, stream)) != null) {
            blocks.add(node);
        }
        return blocks;
    }

    private BlockNode parseBlock(Token token, Parser parser, TokenStream stream) {
        Token textToken;
        if (stream.current().test(Token.Type.TEXT) && (textToken = stream.expect(Token.Type.TEXT)).getValue().trim().length() > 0) {
            throw new ParserException(null, "A template that extends another one cannot include content outside blocks. Did you forget to put the content inside a {% block %} tag?", textToken.getLineNumber(), stream.getFilename());
        }
        stream.expect(Token.Type.EXECUTE_START);
        if (stream.current().test(Token.Type.NAME, "end" + this.getTag())) {
            stream.expect(Token.Type.NAME, "end" + this.getTag());
            stream.expect(Token.Type.EXECUTE_END);
            return null;
        }
        return (BlockNode)this.blockTokenParser.parse(token, parser);
    }

    @Override
    public String getTag() {
        return "embed";
    }
}

