/*
 * Decompiled with CFR 0.152.
 */
package io.pebbletemplates.pebble.loader;

import io.pebbletemplates.pebble.error.LoaderException;
import io.pebbletemplates.pebble.loader.Loader;
import io.pebbletemplates.pebble.utils.PathUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLoader
implements Loader<String> {
    private static final Logger logger = LoggerFactory.getLogger(FileLoader.class);
    private String prefix;
    private String suffix;
    private String charset = "UTF-8";

    public FileLoader(String prefix) {
        this.setPrefix(prefix);
    }

    @Override
    public Reader getReader(String templateName) {
        File file = this.getFile(templateName);
        try {
            FileInputStream is = new FileInputStream(file);
            return new BufferedReader(new InputStreamReader((InputStream)is, this.charset));
        }
        catch (FileNotFoundException e) {
            throw new LoaderException(e, String.format("Could not find template [prefix='%s', templateName='%s']", this.prefix, templateName));
        }
        catch (UnsupportedEncodingException e) {
            throw new LoaderException(e, String.format("Invalid charset '%s'", this.charset));
        }
    }

    private File getFile(String templateName) {
        templateName = templateName + (this.getSuffix() == null ? "" : this.getSuffix());
        templateName = PathUtils.sanitize(templateName, File.separatorChar);
        Path path = Paths.get(this.getPrefix(), templateName);
        logger.trace("Looking for template in {}.", (Object)path);
        this.checkIfDirectoryTraversal(templateName);
        return path.toFile();
    }

    public String getSuffix() {
        return this.suffix;
    }

    @Override
    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void setPrefix(String prefix) {
        if (prefix == null) {
            throw new LoaderException(null, "Prefix cannot be null");
        }
        String trimmedPrefix = prefix.trim();
        if (trimmedPrefix.isEmpty()) {
            throw new LoaderException(null, "Prefix cannot be empty");
        }
        if (!Paths.get(trimmedPrefix, new String[0]).isAbsolute()) {
            throw new LoaderException(null, "Prefix must be an absolute path");
        }
        this.prefix = trimmedPrefix;
    }

    public String getCharset() {
        return this.charset;
    }

    @Override
    public void setCharset(String charset) {
        this.charset = charset;
    }

    @Override
    public String resolveRelativePath(String relativePath, String anchorPath) {
        return PathUtils.resolveRelativePath(relativePath, anchorPath, File.separatorChar);
    }

    @Override
    public String createCacheKey(String templateName) {
        return templateName;
    }

    @Override
    public boolean resourceExists(String templateName) {
        return this.getFile(templateName).exists();
    }

    private void checkIfDirectoryTraversal(String templateName) {
        Path baseDirPath = Paths.get(this.prefix, new String[0]);
        Path userPath = Paths.get(templateName, new String[0]);
        if (userPath.isAbsolute()) {
            throw new LoaderException(null, String.format("templateName '%s' must be relative", templateName));
        }
        Path resolvedPath = baseDirPath.resolve(userPath).normalize();
        if (!resolvedPath.startsWith(baseDirPath)) {
            throw new LoaderException(null, String.format("template is not in the base directory path [baseDir='%s', templateName='%s']", this.prefix, templateName));
        }
    }
}

