/*
 * Decompiled with CFR 0.152.
 */
package io.pebbletemplates.pebble.extension.core;

import io.pebbletemplates.pebble.extension.AbstractExtension;
import io.pebbletemplates.pebble.extension.Filter;
import io.pebbletemplates.pebble.extension.Function;
import io.pebbletemplates.pebble.extension.NodeVisitorFactory;
import io.pebbletemplates.pebble.extension.Test;
import io.pebbletemplates.pebble.extension.core.AbbreviateFilter;
import io.pebbletemplates.pebble.extension.core.AbsFilter;
import io.pebbletemplates.pebble.extension.core.Base64DecoderFilter;
import io.pebbletemplates.pebble.extension.core.Base64EncoderFilter;
import io.pebbletemplates.pebble.extension.core.CapitalizeFilter;
import io.pebbletemplates.pebble.extension.core.DateFilter;
import io.pebbletemplates.pebble.extension.core.DefaultFilter;
import io.pebbletemplates.pebble.extension.core.DefinedTest;
import io.pebbletemplates.pebble.extension.core.EmptyTest;
import io.pebbletemplates.pebble.extension.core.EvenTest;
import io.pebbletemplates.pebble.extension.core.FirstFilter;
import io.pebbletemplates.pebble.extension.core.IterableTest;
import io.pebbletemplates.pebble.extension.core.JoinFilter;
import io.pebbletemplates.pebble.extension.core.LastFilter;
import io.pebbletemplates.pebble.extension.core.LengthFilter;
import io.pebbletemplates.pebble.extension.core.LowerFilter;
import io.pebbletemplates.pebble.extension.core.MacroAndBlockRegistrantNodeVisitorFactory;
import io.pebbletemplates.pebble.extension.core.MapTest;
import io.pebbletemplates.pebble.extension.core.MaxFunction;
import io.pebbletemplates.pebble.extension.core.MergeFilter;
import io.pebbletemplates.pebble.extension.core.MinFunction;
import io.pebbletemplates.pebble.extension.core.Nl2brFilter;
import io.pebbletemplates.pebble.extension.core.NullTest;
import io.pebbletemplates.pebble.extension.core.NumberFormatFilter;
import io.pebbletemplates.pebble.extension.core.OddTest;
import io.pebbletemplates.pebble.extension.core.RangeFunction;
import io.pebbletemplates.pebble.extension.core.ReplaceFilter;
import io.pebbletemplates.pebble.extension.core.ReverseFilter;
import io.pebbletemplates.pebble.extension.core.RsortFilter;
import io.pebbletemplates.pebble.extension.core.Sha256Filter;
import io.pebbletemplates.pebble.extension.core.SliceFilter;
import io.pebbletemplates.pebble.extension.core.SortFilter;
import io.pebbletemplates.pebble.extension.core.SplitFilter;
import io.pebbletemplates.pebble.extension.core.TitleFilter;
import io.pebbletemplates.pebble.extension.core.TrimFilter;
import io.pebbletemplates.pebble.extension.core.UpperFilter;
import io.pebbletemplates.pebble.extension.core.UrlEncoderFilter;
import io.pebbletemplates.pebble.node.expression.AddExpression;
import io.pebbletemplates.pebble.node.expression.AndExpression;
import io.pebbletemplates.pebble.node.expression.ConcatenateExpression;
import io.pebbletemplates.pebble.node.expression.ContainsExpression;
import io.pebbletemplates.pebble.node.expression.DivideExpression;
import io.pebbletemplates.pebble.node.expression.EqualsExpression;
import io.pebbletemplates.pebble.node.expression.FilterExpression;
import io.pebbletemplates.pebble.node.expression.GreaterThanEqualsExpression;
import io.pebbletemplates.pebble.node.expression.GreaterThanExpression;
import io.pebbletemplates.pebble.node.expression.LessThanEqualsExpression;
import io.pebbletemplates.pebble.node.expression.LessThanExpression;
import io.pebbletemplates.pebble.node.expression.ModulusExpression;
import io.pebbletemplates.pebble.node.expression.MultiplyExpression;
import io.pebbletemplates.pebble.node.expression.NegativeTestExpression;
import io.pebbletemplates.pebble.node.expression.NotEqualsExpression;
import io.pebbletemplates.pebble.node.expression.OrExpression;
import io.pebbletemplates.pebble.node.expression.PositiveTestExpression;
import io.pebbletemplates.pebble.node.expression.RangeExpression;
import io.pebbletemplates.pebble.node.expression.SubtractExpression;
import io.pebbletemplates.pebble.node.expression.UnaryMinusExpression;
import io.pebbletemplates.pebble.node.expression.UnaryNotExpression;
import io.pebbletemplates.pebble.node.expression.UnaryPlusExpression;
import io.pebbletemplates.pebble.operator.Associativity;
import io.pebbletemplates.pebble.operator.BinaryOperator;
import io.pebbletemplates.pebble.operator.BinaryOperatorImpl;
import io.pebbletemplates.pebble.operator.BinaryOperatorType;
import io.pebbletemplates.pebble.operator.UnaryOperator;
import io.pebbletemplates.pebble.operator.UnaryOperatorImpl;
import io.pebbletemplates.pebble.tokenParser.BlockTokenParser;
import io.pebbletemplates.pebble.tokenParser.CacheTokenParser;
import io.pebbletemplates.pebble.tokenParser.EmbedTokenParser;
import io.pebbletemplates.pebble.tokenParser.ExtendsTokenParser;
import io.pebbletemplates.pebble.tokenParser.FilterTokenParser;
import io.pebbletemplates.pebble.tokenParser.FlushTokenParser;
import io.pebbletemplates.pebble.tokenParser.ForTokenParser;
import io.pebbletemplates.pebble.tokenParser.FromTokenParser;
import io.pebbletemplates.pebble.tokenParser.IfTokenParser;
import io.pebbletemplates.pebble.tokenParser.ImportTokenParser;
import io.pebbletemplates.pebble.tokenParser.IncludeTokenParser;
import io.pebbletemplates.pebble.tokenParser.MacroTokenParser;
import io.pebbletemplates.pebble.tokenParser.ParallelTokenParser;
import io.pebbletemplates.pebble.tokenParser.SetTokenParser;
import io.pebbletemplates.pebble.tokenParser.TokenParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CoreExtension
extends AbstractExtension {
    @Override
    public List<TokenParser> getTokenParsers() {
        ArrayList<TokenParser> parsers = new ArrayList<TokenParser>();
        parsers.add(new BlockTokenParser());
        parsers.add(new ExtendsTokenParser());
        parsers.add(new EmbedTokenParser());
        parsers.add(new FilterTokenParser());
        parsers.add(new FlushTokenParser());
        parsers.add(new ForTokenParser());
        parsers.add(new IfTokenParser());
        parsers.add(new ImportTokenParser());
        parsers.add(new IncludeTokenParser());
        parsers.add(new MacroTokenParser());
        parsers.add(new ParallelTokenParser());
        parsers.add(new SetTokenParser());
        parsers.add(new CacheTokenParser());
        parsers.add(new FromTokenParser());
        return parsers;
    }

    @Override
    public List<UnaryOperator> getUnaryOperators() {
        ArrayList<UnaryOperator> operators = new ArrayList<UnaryOperator>();
        operators.add(new UnaryOperatorImpl("not", 500, UnaryNotExpression.class));
        operators.add(new UnaryOperatorImpl("+", 500, UnaryPlusExpression.class));
        operators.add(new UnaryOperatorImpl("-", 500, UnaryMinusExpression.class));
        return operators;
    }

    @Override
    public List<BinaryOperator> getBinaryOperators() {
        ArrayList<BinaryOperator> operators = new ArrayList<BinaryOperator>();
        operators.add(new BinaryOperatorImpl("or", 10, OrExpression::new, BinaryOperatorType.NORMAL, Associativity.LEFT));
        operators.add(new BinaryOperatorImpl("and", 15, AndExpression::new, BinaryOperatorType.NORMAL, Associativity.LEFT));
        operators.add(new BinaryOperatorImpl("is", 20, PositiveTestExpression::new, BinaryOperatorType.TEST, Associativity.LEFT));
        operators.add(new BinaryOperatorImpl("is not", 20, NegativeTestExpression::new, BinaryOperatorType.TEST, Associativity.LEFT));
        operators.add(new BinaryOperatorImpl("contains", 20, ContainsExpression::new, BinaryOperatorType.NORMAL, Associativity.LEFT));
        operators.add(new BinaryOperatorImpl("==", 30, EqualsExpression::new, BinaryOperatorType.NORMAL, Associativity.LEFT));
        operators.add(new BinaryOperatorImpl("equals", 30, EqualsExpression::new, BinaryOperatorType.NORMAL, Associativity.LEFT));
        operators.add(new BinaryOperatorImpl("!=", 30, NotEqualsExpression::new, BinaryOperatorType.NORMAL, Associativity.LEFT));
        operators.add(new BinaryOperatorImpl(">", 30, GreaterThanExpression::new, BinaryOperatorType.NORMAL, Associativity.LEFT));
        operators.add(new BinaryOperatorImpl("<", 30, LessThanExpression::new, BinaryOperatorType.NORMAL, Associativity.LEFT));
        operators.add(new BinaryOperatorImpl(">=", 30, GreaterThanEqualsExpression::new, BinaryOperatorType.NORMAL, Associativity.LEFT));
        operators.add(new BinaryOperatorImpl("<=", 30, LessThanEqualsExpression::new, BinaryOperatorType.NORMAL, Associativity.LEFT));
        operators.add(new BinaryOperatorImpl("+", 40, AddExpression::new, BinaryOperatorType.NORMAL, Associativity.LEFT));
        operators.add(new BinaryOperatorImpl("-", 40, SubtractExpression::new, BinaryOperatorType.NORMAL, Associativity.LEFT));
        operators.add(new BinaryOperatorImpl("*", 60, MultiplyExpression::new, BinaryOperatorType.NORMAL, Associativity.LEFT));
        operators.add(new BinaryOperatorImpl("/", 60, DivideExpression::new, BinaryOperatorType.NORMAL, Associativity.LEFT));
        operators.add(new BinaryOperatorImpl("%", 60, ModulusExpression::new, BinaryOperatorType.NORMAL, Associativity.LEFT));
        operators.add(new BinaryOperatorImpl("|", 100, FilterExpression::new, BinaryOperatorType.FILTER, Associativity.LEFT));
        operators.add(new BinaryOperatorImpl("~", 110, ConcatenateExpression::new, BinaryOperatorType.NORMAL, Associativity.LEFT));
        operators.add(new BinaryOperatorImpl("..", 120, RangeExpression::new, BinaryOperatorType.NORMAL, Associativity.LEFT));
        return operators;
    }

    @Override
    public Map<String, Filter> getFilters() {
        HashMap<String, Filter> filters = new HashMap<String, Filter>();
        filters.put("abbreviate", new AbbreviateFilter());
        filters.put("abs", new AbsFilter());
        filters.put("capitalize", new CapitalizeFilter());
        filters.put("date", new DateFilter());
        filters.put("default", new DefaultFilter());
        filters.put("first", new FirstFilter());
        filters.put("join", new JoinFilter());
        filters.put("last", new LastFilter());
        filters.put("lower", new LowerFilter());
        filters.put("numberformat", new NumberFormatFilter());
        filters.put("slice", new SliceFilter());
        filters.put("sort", new SortFilter());
        filters.put("rsort", new RsortFilter());
        filters.put("reverse", new ReverseFilter());
        filters.put("title", new TitleFilter());
        filters.put("trim", new TrimFilter());
        filters.put("upper", new UpperFilter());
        filters.put("urlencode", new UrlEncoderFilter());
        filters.put("length", new LengthFilter());
        filters.put("replace", new ReplaceFilter());
        filters.put("merge", new MergeFilter());
        filters.put("split", new SplitFilter());
        filters.put("base64encode", new Base64EncoderFilter());
        filters.put("base64decode", new Base64DecoderFilter());
        filters.put("sha256", new Sha256Filter());
        filters.put("nl2br", new Nl2brFilter());
        return filters;
    }

    @Override
    public Map<String, Test> getTests() {
        HashMap<String, Test> tests = new HashMap<String, Test>();
        tests.put("empty", new EmptyTest());
        tests.put("even", new EvenTest());
        tests.put("iterable", new IterableTest());
        tests.put("map", new MapTest());
        tests.put("null", new NullTest());
        tests.put("odd", new OddTest());
        tests.put("defined", new DefinedTest());
        return tests;
    }

    @Override
    public Map<String, Function> getFunctions() {
        HashMap<String, Function> functions = new HashMap<String, Function>();
        functions.put("max", new MaxFunction());
        functions.put("min", new MinFunction());
        functions.put("range", new RangeFunction());
        return functions;
    }

    @Override
    public Map<String, Object> getGlobalVariables() {
        return null;
    }

    @Override
    public List<NodeVisitorFactory> getNodeVisitors() {
        ArrayList<NodeVisitorFactory> visitors = new ArrayList<NodeVisitorFactory>();
        visitors.add(new MacroAndBlockRegistrantNodeVisitorFactory());
        return visitors;
    }
}

