/*
 * Decompiled with CFR 0.152.
 */
package io.pebbletemplates.pebble.extension.core;

import io.pebbletemplates.pebble.error.PebbleException;
import io.pebbletemplates.pebble.extension.Filter;
import io.pebbletemplates.pebble.template.EvaluationContext;
import io.pebbletemplates.pebble.template.PebbleTemplate;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;

public class AbsFilter
implements Filter {
    @Override
    public List<String> getArgumentNames() {
        return null;
    }

    @Override
    public Number apply(Object input, Map<String, Object> args, PebbleTemplate self, EvaluationContext context, int lineNumber) throws PebbleException {
        if (input == null) {
            throw new PebbleException(null, "Can not pass null value to \"abs\" filter.", lineNumber, self.getName());
        }
        if (input instanceof Integer) {
            return Math.abs((Integer)input);
        }
        if (input instanceof Byte) {
            return Math.abs(((Byte)input).byteValue());
        }
        if (input instanceof Short) {
            return Math.abs(((Short)input).shortValue());
        }
        if (input instanceof Float) {
            return Float.valueOf(Math.abs(((Float)input).floatValue()));
        }
        if (input instanceof Long) {
            return Math.abs((Long)input);
        }
        if (input instanceof Double) {
            return Math.abs((Double)input);
        }
        if (input instanceof BigDecimal) {
            return ((BigDecimal)input).abs();
        }
        if (input instanceof BigInteger) {
            return ((BigInteger)input).abs();
        }
        if (input instanceof Number) {
            return Math.abs(((Number)input).doubleValue());
        }
        throw new PebbleException(null, "The 'abs' filter does require as input a number.", lineNumber, self.getName());
    }
}

