/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.web.webfilter;

import io.opentracing.Tracer;
import io.opentracing.contrib.spring.web.webfilter.TracingOperator;
import io.opentracing.contrib.spring.web.webfilter.WebFluxSpanDecorator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.Ordered;
import org.springframework.http.server.PathContainer;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;
import reactor.core.publisher.Mono;

public class TracingWebFilter
implements WebFilter,
Ordered {
    private static final Log LOG = LogFactory.getLog(TracingWebFilter.class);
    static final String SERVER_SPAN_CONTEXT = TracingWebFilter.class.getName() + ".activeSpanContext";
    private final Tracer tracer;
    private final int order;
    @Nullable
    private final Pattern skipPattern;
    private final Set<PathPattern> urlPatterns;
    private final List<WebFluxSpanDecorator> spanDecorators;

    public TracingWebFilter(Tracer tracer, int order, Pattern skipPattern, List<String> urlPatterns, List<WebFluxSpanDecorator> spanDecorators) {
        this.tracer = tracer;
        this.order = order;
        this.skipPattern = skipPattern != null && StringUtils.hasText((String)skipPattern.pattern()) ? skipPattern : null;
        PathPatternParser pathPatternParser = new PathPatternParser();
        this.urlPatterns = urlPatterns.stream().map(arg_0 -> ((PathPatternParser)pathPatternParser).parse(arg_0)).collect(Collectors.toSet());
        this.spanDecorators = spanDecorators;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        ServerHttpRequest request = exchange.getRequest();
        if (!this.shouldBeTraced(request)) {
            return chain.filter(exchange);
        }
        if (exchange.getAttribute(SERVER_SPAN_CONTEXT) != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Not tracing request " + request + " because it is already being traced"));
            }
            return chain.filter(exchange);
        }
        return new TracingOperator((Mono<? extends Void>)chain.filter(exchange), exchange, this.tracer, this.spanDecorators);
    }

    boolean shouldBeTraced(ServerHttpRequest request) {
        String url;
        PathContainer pathWithinApplication = request.getPath().pathWithinApplication();
        if (this.skipPattern != null && this.skipPattern.matcher(url = pathWithinApplication.value()).matches()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Not tracing request " + request + " because it matches skip pattern: " + this.skipPattern));
            }
            return false;
        }
        if (!this.urlPatterns.isEmpty() && this.urlPatterns.stream().noneMatch(urlPattern -> urlPattern.matches(pathWithinApplication))) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Not tracing request " + request + " because it does not match any URL pattern: " + this.urlPatterns));
            }
            return false;
        }
        return true;
    }

    public int getOrder() {
        return this.order;
    }
}

