/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.web.client;

import io.opentracing.Tracer;
import io.opentracing.contrib.spring.web.client.TracingExchangeFilterFunction;
import io.opentracing.contrib.spring.web.client.WebClientSpanDecorator;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;

public class TracingWebClientBeanPostProcessor
implements BeanPostProcessor {
    private final Tracer tracer;
    private final List<WebClientSpanDecorator> spanDecorators;

    public TracingWebClientBeanPostProcessor(Tracer tracer, List<WebClientSpanDecorator> spanDecorators) {
        this.tracer = tracer;
        this.spanDecorators = spanDecorators;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof WebClient) {
            WebClient webClient = (WebClient)bean;
            return webClient.mutate().filters(this.addTraceExchangeFilterFunctionIfNotPresent()).build();
        }
        if (bean instanceof WebClient.Builder) {
            WebClient.Builder webClientBuilder = (WebClient.Builder)bean;
            return webClientBuilder.filters(this.addTraceExchangeFilterFunctionIfNotPresent());
        }
        return bean;
    }

    private Consumer<List<ExchangeFilterFunction>> addTraceExchangeFilterFunctionIfNotPresent() {
        return functions -> {
            if (functions.stream().noneMatch(function -> function instanceof TracingExchangeFilterFunction)) {
                functions.add(new TracingExchangeFilterFunction(this.tracer, this.spanDecorators));
            }
        };
    }
}

